/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Checks {
    @NotNull
    @NonNls
    public static final String PRECONDITION_IS_NOT_SATISFIED = "Precondition is not satisfied";
    @NotNull
    @NonNls
    public static final String INVARIANT_IS_NOT_SATISFIED = "Invariant is not satisfied";
    @NotNull
    @NonNls
    public static final String POSTCONDITION_IS_NOT_SATISFIED = "Postcondition is not satisfied";

    private Checks() {
    }

    @Contract(value="false -> fail")
    public static void require(boolean statement) {
        if (!statement) {
            throw new IllegalArgumentException(PRECONDITION_IS_NOT_SATISFIED);
        }
    }

    @Contract(value="false, _ -> fail")
    public static void require(boolean statement, @NotNull Supplier<Object> lazyMessage) {
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(0);
        }
        if (!statement) {
            throw new IllegalArgumentException(lazyMessage.get().toString());
        }
    }

    @Contract(value="false, _ -> fail")
    public static void require(boolean statement, @NotNull String message) {
        if (message == null) {
            Checks.$$$reportNull$$$0(1);
        }
        if (!statement) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void require(@NotNull String message, @NotNull BooleanSupplier statementSupplier) {
        if (message == null) {
            Checks.$$$reportNull$$$0(2);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(3);
        }
        if (!statementSupplier.getAsBoolean()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void require(@NotNull Supplier<Object> lazyMessage, @NotNull BooleanSupplier statementSupplier) {
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(4);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(5);
        }
        if (!statementSupplier.getAsBoolean()) {
            throw new IllegalArgumentException(lazyMessage.get().toString());
        }
    }

    public static void requireAndLog(@NotNull Class<?> loggingClass, boolean statement) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(6);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalArgumentException(PRECONDITION_IS_NOT_SATISFIED));
        }
    }

    public static void requireAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull Supplier<Object> lazyMessage) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(7);
        }
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(8);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalArgumentException(lazyMessage.get().toString()));
        }
    }

    public static void requireAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull String message) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(9);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(10);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalArgumentException(message));
        }
    }

    public static void requireAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull String message, Attachment ... attachments) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(11);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(12);
        }
        if (attachments == null) {
            Checks.$$$reportNull$$$0(13);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(message, (Throwable)new IllegalArgumentException(message), attachments);
        }
    }

    public static void requireAndLog(@NotNull Class<?> loggingClass, @NotNull String message, @NotNull BooleanSupplier statementSupplier) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(14);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(15);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(16);
        }
        if (!statementSupplier.getAsBoolean()) {
            Logger.getInstance(loggingClass).error(new IllegalArgumentException(message));
        }
    }

    public static void requireAndLog(@NotNull Class<?> loggingClass, @NotNull Supplier<Object> lazyMessage, @NotNull BooleanSupplier statementSupplier) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(17);
        }
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(18);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(19);
        }
        if (!statementSupplier.getAsBoolean()) {
            Logger.getInstance(loggingClass).error(new IllegalArgumentException(lazyMessage.get().toString()));
        }
    }

    @Contract(value="false -> fail")
    public static void check(boolean statement) {
        if (!statement) {
            throw new IllegalStateException(INVARIANT_IS_NOT_SATISFIED);
        }
    }

    @Contract(value="false, _ -> fail")
    public static void check(boolean statement, @NotNull Supplier<Object> lazyMessage) {
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(20);
        }
        if (!statement) {
            throw new IllegalStateException(lazyMessage.get().toString());
        }
    }

    @Contract(value="false, _ -> fail")
    public static void check(boolean statement, @NotNull String message) {
        if (message == null) {
            Checks.$$$reportNull$$$0(21);
        }
        if (!statement) {
            throw new IllegalStateException(message);
        }
    }

    public static void check(@NotNull String message, @NotNull BooleanSupplier statementSupplier) {
        if (message == null) {
            Checks.$$$reportNull$$$0(22);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(23);
        }
        if (!statementSupplier.getAsBoolean()) {
            throw new IllegalStateException(message);
        }
    }

    public static void check(@NotNull Supplier<Object> lazyMessage, @NotNull BooleanSupplier statementSupplier) {
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(24);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(25);
        }
        if (!statementSupplier.getAsBoolean()) {
            throw new IllegalStateException(lazyMessage.get().toString());
        }
    }

    public static void checkAndLog(@NotNull Class<?> loggingClass, boolean statement) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(26);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalStateException(INVARIANT_IS_NOT_SATISFIED));
        }
    }

    public static void checkAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull Supplier<Object> lazyMessage) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(27);
        }
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(28);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalStateException(lazyMessage.get().toString()));
        }
    }

    public static void checkAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull String message) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(29);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(30);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalStateException(message));
        }
    }

    public static void checkAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull String message, Attachment ... attachments) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(31);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(32);
        }
        if (attachments == null) {
            Checks.$$$reportNull$$$0(33);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(message, (Throwable)new IllegalStateException(message), attachments);
        }
    }

    public static void checkAndLog(@NotNull Class<?> loggingClass, @NotNull String message, @NotNull BooleanSupplier statementSupplier) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(34);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(35);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(36);
        }
        if (!statementSupplier.getAsBoolean()) {
            Logger.getInstance(loggingClass).error(new IllegalStateException(message));
        }
    }

    public static void checkAndLog(@NotNull Class<?> loggingClass, @NotNull Supplier<Object> lazyMessage, @NotNull BooleanSupplier statementSupplier) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(37);
        }
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(38);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(39);
        }
        if (!statementSupplier.getAsBoolean()) {
            Logger.getInstance(loggingClass).error(new IllegalStateException(lazyMessage.get().toString()));
        }
    }

    public static void checkIndex(int index, int size) {
        Checks.checkIndex(index, size, "index");
    }

    public static void checkIndex(int index, int size, @NotNull String indexDescription) {
        if (indexDescription == null) {
            Checks.$$$reportNull$$$0(40);
        }
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Checks.badElementIndex(index, size, indexDescription));
        }
    }

    public static void checkIndexAndLog(@NotNull Class<?> loggingClass, int index, int size) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(41);
        }
        Checks.checkIndexAndLog(loggingClass, index, size, "index");
    }

    public static void checkIndexAndLog(@NotNull Class<?> loggingClass, int index, int size, @NotNull String indexDescription) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(42);
        }
        if (indexDescription == null) {
            Checks.$$$reportNull$$$0(43);
        }
        if (index < 0 || index >= size) {
            Logger.getInstance(loggingClass).error(new IndexOutOfBoundsException(Checks.badElementIndex(index, size, indexDescription)));
        }
    }

    public static void checkIndexAndLog(@NotNull Class<?> loggingClass, int index, int size, @NotNull String indexDescription, Attachment ... attachments) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(44);
        }
        if (indexDescription == null) {
            Checks.$$$reportNull$$$0(45);
        }
        if (attachments == null) {
            Checks.$$$reportNull$$$0(46);
        }
        if (index < 0 || index >= size) {
            String message = Checks.badElementIndex(index, size, indexDescription);
            Logger.getInstance(loggingClass).error(message, (Throwable)new IndexOutOfBoundsException(message), attachments);
        }
    }

    @NotNull
    private static String badElementIndex(int index, int size, @NotNull String indexDescription) {
        if (indexDescription == null) {
            Checks.$$$reportNull$$$0(47);
        }
        if (index < 0) {
            String string2 = indexDescription + " (" + index + ") must not be negative";
            if (string2 == null) {
                Checks.$$$reportNull$$$0(48);
            }
            return string2;
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        String string3 = indexDescription + " (" + index + ") must be less than size (" + size + ")";
        if (string3 == null) {
            Checks.$$$reportNull$$$0(49);
        }
        return string3;
    }

    @Contract(value="false -> fail")
    public static void ensure(boolean statement) {
        if (!statement) {
            throw new IllegalPostconditionException(POSTCONDITION_IS_NOT_SATISFIED);
        }
    }

    @Contract(value="false, _ -> fail")
    public static void ensure(boolean statement, @NotNull Supplier<Object> lazyMessage) {
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(50);
        }
        if (!statement) {
            throw new IllegalPostconditionException(lazyMessage.get().toString());
        }
    }

    @Contract(value="false, _ -> fail")
    public static void ensure(boolean statement, @NotNull String message) {
        if (message == null) {
            Checks.$$$reportNull$$$0(51);
        }
        if (!statement) {
            throw new IllegalPostconditionException(message);
        }
    }

    public static void ensure(@NotNull String message, @NotNull BooleanSupplier statementSupplier) {
        if (message == null) {
            Checks.$$$reportNull$$$0(52);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(53);
        }
        if (!statementSupplier.getAsBoolean()) {
            throw new IllegalPostconditionException(message);
        }
    }

    public static void ensure(@NotNull Supplier<Object> lazyMessage, @NotNull BooleanSupplier statementSupplier) {
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(54);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(55);
        }
        if (!statementSupplier.getAsBoolean()) {
            throw new IllegalPostconditionException(lazyMessage.get().toString());
        }
    }

    public static void ensureAndLog(@NotNull Class<?> loggingClass, boolean statement) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(56);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalPostconditionException(POSTCONDITION_IS_NOT_SATISFIED));
        }
    }

    public static void ensureAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull Supplier<Object> lazyMessage) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(57);
        }
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(58);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalPostconditionException(lazyMessage.get().toString()));
        }
    }

    public static void ensureAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull String message) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(59);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(60);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(new IllegalPostconditionException(message));
        }
    }

    public static void ensureAndLog(@NotNull Class<?> loggingClass, boolean statement, @NotNull String message, Attachment ... attachments) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(61);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(62);
        }
        if (attachments == null) {
            Checks.$$$reportNull$$$0(63);
        }
        if (!statement) {
            Logger.getInstance(loggingClass).error(message, (Throwable)new IllegalPostconditionException(message), attachments);
        }
    }

    public static void ensureAndLog(@NotNull Class<?> loggingClass, @NotNull String message, @NotNull BooleanSupplier statementSupplier) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(64);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(65);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(66);
        }
        if (!statementSupplier.getAsBoolean()) {
            Logger.getInstance(loggingClass).error(new IllegalPostconditionException(message));
        }
    }

    public static void ensureAndLog(@NotNull Class<?> loggingClass, @NotNull Supplier<Object> lazyMessage, @NotNull BooleanSupplier statementSupplier) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(67);
        }
        if (lazyMessage == null) {
            Checks.$$$reportNull$$$0(68);
        }
        if (statementSupplier == null) {
            Checks.$$$reportNull$$$0(69);
        }
        if (!statementSupplier.getAsBoolean()) {
            Logger.getInstance(loggingClass).error(new IllegalPostconditionException(lazyMessage.get().toString()));
        }
    }

    @Contract(value="_ -> fail")
    public static void fail(@NotNull Object message) {
        if (message == null) {
            Checks.$$$reportNull$$$0(70);
        }
        throw new IllegalStateException(message.toString());
    }

    @Contract(value="-> fail")
    public static void unreachable() {
        throw new IllegalStateException("Must be unreachable");
    }

    public static void logError(@NotNull Class<?> loggingClass, @NotNull Object message, Attachment ... attachments) {
        if (loggingClass == null) {
            Checks.$$$reportNull$$$0(71);
        }
        if (message == null) {
            Checks.$$$reportNull$$$0(72);
        }
        if (attachments == null) {
            Checks.$$$reportNull$$$0(73);
        }
        String s = message.toString();
        Logger.getInstance(loggingClass).error(s, (Throwable)new IllegalStateException(s), attachments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 48: 
            case 49: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyMessage";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 30: 
            case 32: 
            case 35: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 65: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 5: 
            case 16: 
            case 19: 
            case 23: 
            case 25: 
            case 36: 
            case 39: 
            case 53: 
            case 55: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementSupplier";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggingClass";
                break;
            }
            case 13: 
            case 33: 
            case 46: 
            case 63: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 40: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexDescription";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/Checks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/Checks";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "badElementIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "require";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requireAndLog";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkAndLog";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkIndex";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexAndLog";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "badElementIndex";
                break;
            }
            case 48: 
            case 49: {
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "ensure";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "ensureAndLog";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class IllegalPostconditionException
    extends RuntimeException {
        public IllegalPostconditionException() {
        }

        public IllegalPostconditionException(String message) {
            super(message);
        }

        public IllegalPostconditionException(String message, Throwable cause) {
            super(message, cause);
        }

        public IllegalPostconditionException(Throwable cause) {
            super(cause);
        }

        public IllegalPostconditionException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

