/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CountingInputStream
extends FilterInputStream {
    private long myBytesRead;
    private long myMark;

    public CountingInputStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            CountingInputStream.$$$reportNull$$$0(0);
        }
        super(inputStream);
        this.myBytesRead = 0L;
        this.myMark = -1L;
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.in.read();
        if (bytesRead != -1) {
            ++this.myBytesRead;
        }
        return bytesRead;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int bytesRead;
        if (b == null) {
            CountingInputStream.$$$reportNull$$$0(1);
        }
        if ((bytesRead = this.in.read(b, off, len)) != -1) {
            this.myBytesRead += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = this.in.skip(n);
        this.myBytesRead += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.myMark = this.myBytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.myMark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.myBytesRead = this.myMark;
    }

    public long getBytesRead() {
        return this.myBytesRead;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/CountingInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

