/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;

public class CDATA
extends Text {
    private static final long serialVersionUID = 200L;

    protected CDATA() {
        super(Content.CType.CDATA);
    }

    public CDATA(String string2) {
        super(Content.CType.CDATA);
        this.setText(string2);
    }

    @Override
    public CDATA setText(String str) {
        if (str == null || "".equals(str)) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCDATASection(str);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = str;
        return this;
    }

    @Override
    public void append(String str) {
        if (str == null || "".equals(str)) {
            return;
        }
        String tmpValue = this.value == "" ? str : this.value + str;
        String reason = Verifier.checkCDATASection(tmpValue);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value = tmpValue;
    }

    @Override
    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.append(text.getText());
    }

    @Override
    public String toString() {
        return new StringBuilder(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }

    @Override
    public CDATA clone() {
        return (CDATA)super.clone();
    }

    @Override
    public CDATA detach() {
        return (CDATA)super.detach();
    }

    @Override
    protected CDATA setParent(Parent parent) {
        return (CDATA)super.setParent(parent);
    }
}

