/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.indexing.shared.platform.hash.SharedIndexContentEnumerators;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorage;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorageImpl;
import com.intellij.indexing.shared.platform.hash.SharedIndexMainContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexMainContentHashEnumerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\b0\b*\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorages;", "", "()V", "STORAGE_VERSION", "", "createGeneratorStorage", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorage;", "sharedIndexRoot", "Ljava/nio/file/Path;", "hash", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "lifetime", "Lcom/intellij/openapi/Disposable;", "openHashEnumerator", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "getHashPath", "kotlin.jvm.PlatformType", "intellij.indexing.shared"})
public final class SharedIndexHashStorages {
    private final String STORAGE_VERSION;

    private final Path getHashPath(SharedIndexContentHash $this$getHashPath, Path sharedIndexRoot) {
        return sharedIndexRoot.resolve("hashes-" + $this$getHashPath.getProviderId() + '-' + $this$getHashPath.getVersion() + "-i" + this.STORAGE_VERSION);
    }

    @Nullable
    public final SharedIndexContentHashEnumerator openHashEnumerator(@NotNull Path sharedIndexRoot, @NotNull SharedIndexContentHash hash, @NotNull Disposable lifetime) {
        Path indexPath;
        Intrinsics.checkNotNullParameter((Object)sharedIndexRoot, (String)"sharedIndexRoot");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (hash instanceof SharedIndexMainContentHash) {
            return new SharedIndexMainContentHashEnumerator(lifetime, SharedIndexContentEnumerators.INSTANCE.openEnumeratorForAttachedSharedIndex(sharedIndexRoot));
        }
        Path path = indexPath = this.getHashPath(hash, sharedIndexRoot);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"indexPath");
        if (!PathKt.isFile((Path)path)) {
            return null;
        }
        return new SharedIndexHashStorageImpl(indexPath, hash, true, lifetime);
    }

    @Nullable
    public final SharedIndexHashStorage createGeneratorStorage(@NotNull Path sharedIndexRoot, @NotNull SharedIndexContentHash hash, @NotNull Disposable lifetime) {
        Path indexPath;
        Intrinsics.checkNotNullParameter((Object)sharedIndexRoot, (String)"sharedIndexRoot");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (hash instanceof SharedIndexMainContentHash) {
            return null;
        }
        Path path = indexPath = this.getHashPath(hash, sharedIndexRoot);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"indexPath");
        if (PathKt.isFile((Path)path)) {
            throw (Throwable)new IOException("Indexes hash file for " + hash.getProviderId() + " already exists at " + indexPath);
        }
        return new SharedIndexHashStorageImpl(indexPath, hash, false, lifetime);
    }

    public SharedIndexHashStorages() {
        this.STORAGE_VERSION = "1";
    }
}

