/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/util/CountingInputStream;", "Ljava/io/InputStream;", "inputStream", "(Ljava/io/InputStream;)V", "bytesRead", "", "getBytesRead", "()J", "setBytesRead", "(J)V", "hasher", "Lcom/google/common/hash/Hasher;", "kotlin.jvm.PlatformType", "getHasher", "()Lcom/google/common/hash/Hasher;", "Ljava/io/BufferedInputStream;", "getInputStream", "()Ljava/io/BufferedInputStream;", "close", "", "read", "", "b", "", "off", "len", "intellij.indexing.shared"})
final class CountingInputStream
extends InputStream {
    @NotNull
    private final BufferedInputStream inputStream;
    private final Hasher hasher;
    private long bytesRead;

    @NotNull
    public final BufferedInputStream getInputStream() {
        return this.inputStream;
    }

    public final Hasher getHasher() {
        return this.hasher;
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }

    public final void setBytesRead(long l) {
        this.bytesRead = l;
    }

    @Override
    public int read() {
        byte[] tmp = new byte[1];
        if (this.read(tmp, 0, 1) != 1) {
            return -1;
        }
        return tmp[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int sz = this.inputStream.read(b, off, len);
        if (sz > 0) {
            this.bytesRead += (long)sz;
            this.hasher.putBytes(b, off, sz);
        }
        return sz;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    public CountingInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        int n = 0x100000;
        boolean bl = false;
        this.inputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        this.hasher = Hashing.sha256().newHasher();
    }
}

