/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.LogEventDeserializer;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordSizeEstimator;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaperKt;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "recorder", "", "product", "device", "records", "", "Lcom/intellij/internal/statistic/eventLog/LogEventRecord;", "internal", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Z)V", "getDevice", "()Ljava/lang/String;", "getInternal", "()Z", "getProduct", "getRecorder", "getRecords", "()Ljava/util/List;", "equals", "other", "hashCode", "", "Companion", "intellij.platform.statistics.uploader"})
public final class LogEventRecordRequest {
    @NotNull
    private final String recorder;
    @NotNull
    private final String product;
    @NotNull
    private final String device;
    @NotNull
    private final List<LogEventRecord> records;
    private final boolean internal;
    private static final int RECORD_SIZE = 1000000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEventRecordRequest");
        }
        LogEventRecordRequest cfr_ignored_0 = (LogEventRecordRequest)object2;
        if (Intrinsics.areEqual((Object)this.recorder, (Object)((LogEventRecordRequest)other).recorder) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.product, (Object)((LogEventRecordRequest)other).product) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.device, (Object)((LogEventRecordRequest)other).device) ^ true) {
            return false;
        }
        if (this.internal != ((LogEventRecordRequest)other).internal) {
            return false;
        }
        return !(Intrinsics.areEqual(this.records, ((LogEventRecordRequest)other).records) ^ true);
    }

    public int hashCode() {
        int result = this.recorder.hashCode();
        result = 31 * result + this.product.hashCode();
        result = 31 * result + this.device.hashCode();
        result = 31 * result + Boolean.hashCode(this.internal);
        result = 31 * result + ((Object)this.records).hashCode();
        return result;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    @NotNull
    public final String getProduct() {
        return this.product;
    }

    @NotNull
    public final String getDevice() {
        return this.device;
    }

    @NotNull
    public final List<LogEventRecord> getRecords() {
        return this.records;
    }

    public final boolean getInternal() {
        return this.internal;
    }

    public LogEventRecordRequest(@NotNull String recorder, @NotNull String product, @NotNull String device, @NotNull List<LogEventRecord> records, boolean internal) {
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter(records, (String)"records");
        this.recorder = recorder;
        this.product = product;
        this.device = device;
        this.records = records;
        this.internal = internal;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014JP\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014JR\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest$Companion;", "", "()V", "RECORD_SIZE", "", "create", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "file", "Ljava/io/File;", "recorder", "", "product", "deviceId", "filter", "Lcom/intellij/internal/statistic/eventLog/filters/LogEventFilter;", "internal", "", "logger", "Lcom/intellij/internal/statistic/eventLog/DataCollectorDebugLogger;", "machineId", "Lcom/intellij/internal/statistic/eventLog/MachineId;", "user", "maxRecordSize", "fillMachineId", "", "event", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "fillNextBatch", "reader", "Ljava/io/BufferedReader;", "firstLine", "events", "", "deserializer", "Lcom/intellij/internal/statistic/eventLog/LogEventDeserializer;", "estimator", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordSizeEstimator;", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file, @NotNull String recorder, @NotNull String product, @NotNull String deviceId, @NotNull LogEventFilter filter, boolean internal, @NotNull DataCollectorDebugLogger logger2, @NotNull MachineId machineId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
            Intrinsics.checkNotNullParameter((Object)product, (String)"product");
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
            try {
                return this.create(file, recorder, product, deviceId, 1000000, filter, internal, logger2, machineId);
            }
            catch (Exception e) {
                logger2.warn("Failed reading event log file", e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file, @NotNull String recorder, @NotNull String product, @NotNull String user, int maxRecordSize, @NotNull LogEventFilter filter, boolean internal, @NotNull DataCollectorDebugLogger logger2, @NotNull MachineId machineId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
            Intrinsics.checkNotNullParameter((Object)product, (String)"product");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
            try {
                LogEventDeserializer deserializer = new LogEventDeserializer(logger2);
                ArrayList<LogEventRecord> records = new ArrayList<LogEventRecord>();
                Closeable closeable = new BufferedReader(new FileReader(file.getPath()));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl3 = false;
                    LogEventRecordSizeEstimator sizeEstimator = new LogEventRecordSizeEstimator(product, user);
                    ArrayList events = new ArrayList();
                    String line = Companion.fillNextBatch(reader, reader.readLine(), events, deserializer, sizeEstimator, maxRecordSize, filter, machineId);
                    while (!events.isEmpty()) {
                        records.add(new LogEventRecord(events));
                        events = new ArrayList();
                        line = Companion.fillNextBatch(reader, line, events, deserializer, sizeEstimator, maxRecordSize, filter, machineId);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return new LogEventRecordRequest(recorder, product, user, (List<LogEventRecord>)records, internal);
            }
            catch (JsonSyntaxException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                logger2.warn(string, e);
            }
            catch (IOException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                logger2.warn(string, e);
            }
            return null;
        }

        private final String fillNextBatch(BufferedReader reader, String firstLine, List<LogEvent> events, LogEventDeserializer deserializer, LogEventRecordSizeEstimator estimator, int maxRecordSize, LogEventFilter filter, MachineId machineId) {
            int recordSize = 0;
            String line = firstLine;
            while (line != null && recordSize + estimator.estimate(line) < maxRecordSize) {
                LogEvent event = deserializer.fromString(line);
                if (event != null && filter.accepts(event)) {
                    recordSize += estimator.estimate(line);
                    this.fillMachineId(event, machineId);
                    events.add(StatisticsEventEscaperKt.escape((LogEvent)event));
                }
                line = reader.readLine();
            }
            return line;
        }

        public final void fillMachineId(@NotNull LogEvent event, @NotNull MachineId machineId) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
            LogEventAction eventAction = event.getEvent();
            String machineIdValue = machineId.getId();
            int idRevision = machineId.getRevision();
            eventAction.getData().put("system_machine_id", machineIdValue);
            if (idRevision != 0 && Intrinsics.areEqual((Object)machineId, (Object)MachineId.UNKNOWN) ^ true && Intrinsics.areEqual((Object)machineId, (Object)MachineId.DISABLED) ^ true) {
                eventAction.getData().put("system_id_revision", idRevision);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

