/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogTestMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final Logger LOG = Logger.getInstance(EventLogTestMetadataPersistence.class);
    public static final String TEST_RULE = "{util#fus_test_mode}";
    private static final String DEPRECATED_TEST_EVENTS_SCHEME_FILE = "test-white-list.json";
    private static final String TEST_EVENTS_SCHEME_FILE = "test-events-scheme.json";
    @NotNull
    private final String myRecorderId;

    public EventLogTestMetadataPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            Path file = this.getEventsTestSchemeFile();
            return Files.readString(file);
        }
        catch (NoSuchFileException file) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public void cleanup() {
        try {
            Files.deleteIfExists(this.getEventsTestSchemeFile());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static EventGroupRemoteDescriptors.EventGroupRemoteDescriptor createGroupWithCustomRules(@NotNull String groupId, @NotNull String rules) {
        if (groupId == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(1);
        }
        if (rules == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(2);
        }
        String content = "{\"id\":\"" + groupId + "\",\"versions\":[ {\"from\" : \"1\"}],\"rules\":" + rules + "}";
        EventGroupRemoteDescriptors.EventGroupRemoteDescriptor eventGroupRemoteDescriptor = (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor)new GsonBuilder().create().fromJson(content, EventGroupRemoteDescriptors.EventGroupRemoteDescriptor.class);
        if (eventGroupRemoteDescriptor == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(3);
        }
        return eventGroupRemoteDescriptor;
    }

    public static void addTestGroup(@NotNull String recorderId, @NotNull GroupValidationTestRule group) throws IOException {
        if (recorderId == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(4);
        }
        if (group == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(5);
        }
        String groupId = group.getGroupId();
        EventGroupRemoteDescriptors.EventGroupRemoteDescriptor groupWithRules = group.getUseCustomRules() ? EventLogTestMetadataPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()) : EventLogTestMetadataPersistence.createTestGroup(groupId, Collections.emptySet());
        EventLogTestMetadataPersistence.addNewGroup(recorderId, groupWithRules);
    }

    private static void addNewGroup(@NotNull String recorderId, @NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group) throws IOException {
        if (recorderId == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(6);
        }
        if (group == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(7);
        }
        EventLogTestMetadataPersistence persistence = new EventLogTestMetadataPersistence(recorderId);
        EventGroupRemoteDescriptors approvedGroups = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(persistence);
        EventLogTestMetadataPersistence.saveNewGroup(group, approvedGroups, persistence.getEventsTestSchemeFile());
    }

    public static void saveNewGroup(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull EventGroupRemoteDescriptors approvedGroups, @NotNull Path file) throws IOException {
        if (group == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(8);
        }
        if (approvedGroups == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(9);
        }
        if (file == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(10);
        }
        ArrayList descriptors = approvedGroups.groups;
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor g : approvedGroups.groups) {
            if (!Objects.equals(g.id, group.id)) continue;
            descriptors.remove(g);
            break;
        }
        approvedGroups.groups.add(group);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            gson.toJson((Object)approvedGroups, EventGroupRemoteDescriptors.class, (Appendable)writer);
        }
    }

    @NotNull
    public static EventGroupRemoteDescriptors loadCachedEventGroupsSchemes(@NotNull BaseEventLogMetadataPersistence persistence) {
        String existing;
        if (persistence == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(11);
        }
        if (Strings.isNotEmpty((String)(existing = persistence.getCachedEventsScheme()))) {
            EventGroupRemoteDescriptors eventGroupRemoteDescriptors;
            try {
                eventGroupRemoteDescriptors = EventLogMetadataUtils.parseGroupRemoteDescriptors(existing);
            }
            catch (EventLogMetadataParseException e) {
                LOG.warn("Failed parsing test cached events scheme", (Throwable)e);
            }
            if (eventGroupRemoteDescriptors == null) {
                EventLogTestMetadataPersistence.$$$reportNull$$$0(12);
            }
            return eventGroupRemoteDescriptors;
        }
        return new EventGroupRemoteDescriptors();
    }

    @NotNull
    public static EventGroupRemoteDescriptors.EventGroupRemoteDescriptor createTestGroup(@NotNull String groupId, @NotNull Set<String> eventData) {
        if (groupId == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(13);
        }
        if (eventData == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(14);
        }
        EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group = new EventGroupRemoteDescriptors.EventGroupRemoteDescriptor();
        group.id = groupId;
        if (group.versions != null) {
            group.versions.add(new EventGroupRemoteDescriptors.GroupVersionRange("1", null));
        }
        EventGroupRemoteDescriptors.GroupRemoteRule rule = new EventGroupRemoteDescriptors.GroupRemoteRule();
        rule.event_id = new HashSet<String>(Collections.singletonList(TEST_RULE));
        HashMap<String, HashSet<String>> dataRules = new HashMap<String, HashSet<String>>();
        for (String datum : eventData) {
            dataRules.put(datum, new HashSet<String>(Collections.singletonList(TEST_RULE)));
        }
        rule.event_data = dataRules;
        group.rules = rule;
        EventGroupRemoteDescriptors.EventGroupRemoteDescriptor eventGroupRemoteDescriptor = group;
        if (eventGroupRemoteDescriptor == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(15);
        }
        return eventGroupRemoteDescriptor;
    }

    @NotNull
    public Path getEventsTestSchemeFile() throws IOException {
        Path path = EventLogTestMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, TEST_EVENTS_SCHEME_FILE, DEPRECATED_TEST_EVENTS_SCHEME_FILE);
        if (path == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(16);
        }
        return path;
    }

    public void updateTestGroups(@NotNull List<GroupValidationTestRule> groups) throws IOException {
        if (groups == null) {
            EventLogTestMetadataPersistence.$$$reportNull$$$0(17);
        }
        EventGroupRemoteDescriptors approvedGroups = new EventGroupRemoteDescriptors();
        for (GroupValidationTestRule group : groups) {
            String groupId = group.getGroupId();
            if (group.getUseCustomRules()) {
                approvedGroups.groups.add(EventLogTestMetadataPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()));
                continue;
            }
            approvedGroups.groups.add(EventLogTestMetadataPersistence.createTestGroup(groupId, Collections.emptySet()));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path file = this.getEventsTestSchemeFile();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            gson.toJson((Object)approvedGroups, EventGroupRemoteDescriptors.class, (Appendable)writer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogTestMetadataPersistence";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "approvedGroups";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogTestMetadataPersistence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupWithCustomRules";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCachedEventGroupsSchemes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestGroup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsTestSchemeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createGroupWithCustomRules";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewGroup";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveNewGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadCachedEventGroupsSchemes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTestGroup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateTestGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

