#!/usr/bin/env bash

echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!
echo THIS IS A DEBUG FILE!!!!!!


set -e -u -o pipefail


check_command() {
  local LOCAL_COMMAND_OUTPUT
  LOCAL_COMMAND_OUTPUT=$(command -v "$1")
  if [[ -z "$LOCAL_COMMAND_OUTPUT" ]]; then
    echo "A required tool is missing: $1" >&2
    exit 1
  fi
  echo "$LOCAL_COMMAND_OUTPUT"
}

TAR=$(check_command tar)
AWK=$(check_command awk)

function download() {
  if command -v curl >/dev/null 2>&1; then
    curl --progress-bar --fail --show-error --location --output "$1" "$2"
  elif command -v wget >/dev/null 2>&1; then
    wget --progress=bar -O "$1" "$2"
  else
    echo "ERROR: Please install wget or curl" >&2
    exit 1
  fi
}

DEBUG_LOCATION="s"

IJ_HOST_LINUX_URL="https://download.jetbrains.com/idea/code-with-me/idea-tmp-builds/ideaIU-212.2533.tar.gz"
IJ_HOST_LINUX_DIR_NAME="IU-212.2533"

IJ_PROJECTOR_ADDON_URL="https://download.jetbrains.com/idea/code-with-me/idea-tmp-builds/ideaIU-212.2058.prj.tar.gz"

LOCALAPPDATA_FOLDER="${XDG_CACHE_HOME-${HOME}/.cache}/JetBrains/CwmHost"
IJ_HOST_URL="$IJ_HOST_LINUX_URL"
IJ_HOST_DIR_NAME="$IJ_HOST_LINUX_DIR_NAME"

IJ_HOST_ROOT="${LOCALAPPDATA_FOLDER}"
IJ_HOST_DIR="${LOCALAPPDATA_FOLDER}/$IJ_HOST_DIR_NAME"
IJ_HOST_DONE_FLAG=${}"$IJ_HOST_DIR/.done"

IJ_HOST_CONFIG_DIR="$HOME/.CwmHost-IU-config"

if [ ! -f "$IJ_HOST_DONE_FLAG" ]; then
  TEMP_DIST="$IJ_HOST_DIR/.dist.data"
  TEMP_DIST_PRJ="$IJ_HOST_DIR/.dist.projector.data"

  if [ -z "$DEBUG_LOCATION" ]; then
    echo "*** Downloading $IJ_HOST_DIR_NAME from $IJ_HOST_URL"
    rm -rf "$IJ_HOST_DIR"
    mkdir -p "$IJ_HOST_DIR"

    download "$TEMP_DIST" "$IJ_HOST_URL"

    echo "*** Extracting $IJ_HOST_DIR_NAME to $IJ_HOST_DIR"

    set +o pipefail

    TAR_ROOT_DIR_NAME=$("$TAR" -ztf "$TEMP_DIST" | "$AWK" -F '/' 'BEGIN {getline; print $1}')

    set -o pipefail

    if [[ -z "$TAR_ROOT_DIR_NAME" ]]; then
      echo "Can't extract tar root dir name"
      exit 1
    fi

    "$TAR" -zxpC "$IJ_HOST_ROOT" -f "$TEMP_DIST"

    rm -f "$TEMP_DIST"

    if [[ "$TAR_ROOT_DIR_NAME" != "$IJ_HOST_DIR_NAME" ]]; then
      rm -rf "$IJ_HOST_DIR"
      mv "$IJ_HOST_ROOT/$TAR_ROOT_DIR_NAME" "$IJ_HOST_DIR"
    fi
  fi #  [ -z "$DEBUG_LOCATION" ]; then

  # set default config and system dirs
  # shellcheck disable=SC2016
  printf '\nidea.config.path=${user.home}/.CwmHost-IU-config\nidea.system.path=${user.home}/.CwmHost-IU-system\n' >> "$IJ_HOST_DIR/bin/idea.properties"
  printf '\njb.privacy.policy.text="<!--999.999-->"\njb.consents.confirmation.enabled=false\nidea.initially.ask.config=force-not\nide.show.tips.on.startup.default.value=false' >> "$IJ_HOST_DIR/bin/idea.properties"
  # can be deleted, i guess
  printf '\ncodeWithMe.voiceChat.enabled=false' >> "$IJ_HOST_DIR/bin/idea.properties"

  # prevent config import dialog
  if [[ ! -d "$IJ_HOST_CONFIG_DIR" ]]; then
    mkdir "$IJ_HOST_CONFIG_DIR"
  fi
  
  download "$TEMP_DIST_PRJ" "$IJ_PROJECTOR_ADDON_URL"
  
  "$TAR" -zxpC "$IJ_HOST_DIR" -f "$TEMP_DIST_PRJ"

  echo >"$IJ_HOST_DONE_FLAG"
fi

if [[ ! -f "$IJ_HOST_DIR/product-info.json" ]]; then
  LAUNCHER_FILE="bin/idea-projector.sh"
else
  LAUNCHER_FILE="$(awk -F ':' '$1 ~ /"launcherPath"/ { match($2, / "[^"]+/); print substr($2, RSTART+2, RLENGTH-5) }' "$IJ_HOST_DIR/product-info.json")-projector.sh"
fi

if [[ -z "$LAUNCHER_FILE" ]]; then
  echo "Can't parse launcher file"
  exit 1
fi

chmod +x "$IJ_HOST_DIR"/"$LAUNCHER_FILE"

if [[ -z "${1-}" ]]; then
  echo "Usage: $0 [idea commands]"
  echo "Examples:"
  echo "  $0 cwmHost /path/to/project"
  echo "  $0 cwmHostStatus"
  exit 1
fi

IJ_STORED_HOST_PASSWD="$IJ_HOST_CONFIG_DIR/cwm-passwd"

if [[ "$1" == "cwmHost" ]] && [[ ! -f "$IJ_STORED_HOST_PASSWD" ]] && [[ -z "${CWM_NO_PASSWORD-}" ]]; then
  echo "Enter a password that will be used to connect to the host"
  read -r -s CWM_HOST_PASSWORD
  export CWM_HOST_PASSWORD
  echo "Delete $IJ_STORED_HOST_PASSWD and re-run host to change it"
fi

echo "Starting $IJ_HOST_DIR_NAME with following arguments: $*"

"$IJ_HOST_DIR"/"$LAUNCHER_FILE" "$@"
