/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.AlertParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.AlertPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.AlertSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertHandler
extends ProtocolMessageHandler<AlertMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AlertHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public AlertParser getParser(byte[] message, int pointer) {
        return new AlertParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public AlertPreparator getPreparator(AlertMessage message) {
        return new AlertPreparator(this.tlsContext.getChooser(), message);
    }

    public AlertSerializer getSerializer(AlertMessage message) {
        return new AlertSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(AlertMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer() && AlertLevel.FATAL.getValue() == ((Byte)message.getLevel().getValue()).byteValue()) {
            LOGGER.debug("Setting received Fatal Alert in Context");
            this.tlsContext.setReceivedFatalAlert(true);
        }
    }
}

