/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher.cryptohelper;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.MD5Utils;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.crypto.SSLUtils;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyBlockParser;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeySetGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int AEAD_IV_LENGTH = 12;

    public static KeySet generateKeySet(TlsContext context, ProtocolVersion protocolVersion, Tls13KeySetType keySetType) throws NoSuchAlgorithmException, CryptoException {
        if (protocolVersion.isTLS13()) {
            return KeySetGenerator.getTls13KeySet(context, keySetType);
        }
        return KeySetGenerator.getTlsKeySet(context);
    }

    public static KeySet generateKeySet(TlsContext context) throws NoSuchAlgorithmException, CryptoException {
        return KeySetGenerator.generateKeySet(context, context.getChooser().getSelectedProtocolVersion(), context.getActiveKeySetTypeWrite());
    }

    private static KeySet getTls13KeySet(TlsContext context, Tls13KeySetType keySetType) throws CryptoException {
        CipherSuite cipherSuite = context.getChooser().getSelectedCipherSuite();
        byte[] clientSecret = new byte[]{};
        byte[] serverSecret = new byte[]{};
        if (null == keySetType) {
            throw new CryptoException("Unknown KeySetType:" + keySetType.name());
        }
        switch (keySetType) {
            case HANDSHAKE_TRAFFIC_SECRETS: {
                clientSecret = context.getChooser().getClientHandshakeTrafficSecret();
                serverSecret = context.getChooser().getServerHandshakeTrafficSecret();
                break;
            }
            case APPLICATION_TRAFFIC_SECRETS: {
                clientSecret = context.getChooser().getClientApplicationTrafficSecret();
                serverSecret = context.getChooser().getServerApplicationTrafficSecret();
                break;
            }
            case EARLY_TRAFFIC_SECRETS: {
                cipherSuite = context.getChooser().getEarlyDataCipherSuite();
                clientSecret = context.getChooser().getClientEarlyTrafficSecret();
                serverSecret = context.getChooser().getClientEarlyTrafficSecret();
                break;
            }
            case NONE: {
                LOGGER.warn("KeySet is NONE! , returning empty KeySet");
                return new KeySet(keySetType);
            }
            default: {
                throw new CryptoException("Unknown KeySetType:" + keySetType.name());
            }
        }
        LOGGER.debug("ActiveKeySetType is " + (Object)((Object)keySetType));
        CipherAlgorithm cipherAlg = AlgorithmResolver.getCipher(cipherSuite);
        KeySet keySet = new KeySet(keySetType);
        HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(cipherSuite);
        keySet.setClientWriteKey(HKDFunction.expandLabel(hkdfAlgortihm, clientSecret, "key", new byte[0], cipherAlg.getKeySize()));
        LOGGER.debug("Client write key: {}", (Object)ArrayConverter.bytesToHexString((byte[])keySet.getClientWriteKey()));
        keySet.setServerWriteKey(HKDFunction.expandLabel(hkdfAlgortihm, serverSecret, "key", new byte[0], cipherAlg.getKeySize()));
        LOGGER.debug("Server write key: {}", (Object)ArrayConverter.bytesToHexString((byte[])keySet.getServerWriteKey()));
        keySet.setClientWriteIv(HKDFunction.expandLabel(hkdfAlgortihm, clientSecret, "iv", new byte[0], 12));
        LOGGER.debug("Client write IV: {}", (Object)ArrayConverter.bytesToHexString((byte[])keySet.getClientWriteIv()));
        keySet.setServerWriteIv(HKDFunction.expandLabel(hkdfAlgortihm, serverSecret, "iv", new byte[0], 12));
        LOGGER.debug("Server write IV: {}", (Object)ArrayConverter.bytesToHexString((byte[])keySet.getServerWriteIv()));
        keySet.setServerWriteMacSecret(new byte[0]);
        keySet.setClientWriteMacSecret(new byte[0]);
        return keySet;
    }

    private static KeySet getTlsKeySet(TlsContext context) throws CryptoException {
        byte[] keyBlock;
        ProtocolVersion protocolVersion = context.getChooser().getSelectedProtocolVersion();
        CipherSuite cipherSuite = context.getChooser().getSelectedCipherSuite();
        byte[] masterSecret = context.getChooser().getMasterSecret();
        byte[] seed = ArrayConverter.concatenate((byte[][])new byte[][]{context.getChooser().getServerRandom(), context.getChooser().getClientRandom()});
        if (protocolVersion.isSSL()) {
            keyBlock = SSLUtils.calculateKeyBlockSSL3(masterSecret, seed, KeySetGenerator.getSecretSetSize(protocolVersion, cipherSuite));
        } else {
            PRFAlgorithm prfAlgorithm = AlgorithmResolver.getPRFAlgorithm(protocolVersion, cipherSuite);
            keyBlock = PseudoRandomFunction.compute(prfAlgorithm, masterSecret, "key expansion", seed, KeySetGenerator.getSecretSetSize(protocolVersion, cipherSuite));
        }
        LOGGER.debug("A new key block was generated: {}", (Object)ArrayConverter.bytesToHexString((byte[])keyBlock));
        KeyBlockParser parser = new KeyBlockParser(keyBlock, cipherSuite, protocolVersion);
        KeySet keySet = parser.parse();
        if (cipherSuite.isExportSymmetricCipher()) {
            KeySetGenerator.deriveExportKeys(keySet, context);
        }
        return keySet;
    }

    private static void deriveExportKeys(KeySet keySet, TlsContext context) throws CryptoException {
        ProtocolVersion protocolVersion = context.getChooser().getSelectedProtocolVersion();
        CipherSuite cipherSuite = context.getChooser().getSelectedCipherSuite();
        byte[] clientRandom = context.getChooser().getClientRandom();
        byte[] serverRandom = context.getChooser().getServerRandom();
        if (protocolVersion == ProtocolVersion.SSL3) {
            KeySetGenerator.deriveSSL3ExportKeys(cipherSuite, keySet, clientRandom, serverRandom);
            return;
        }
        byte[] clientAndServerRandom = ArrayConverter.concatenate((byte[][])new byte[][]{clientRandom, serverRandom});
        PRFAlgorithm prfAlgorithm = AlgorithmResolver.getPRFAlgorithm(protocolVersion, cipherSuite);
        int keySize = AlgorithmResolver.getCipher(cipherSuite).getKeySize();
        keySet.setClientWriteKey(PseudoRandomFunction.compute(prfAlgorithm, keySet.getClientWriteKey(), "client write key", clientAndServerRandom, keySize));
        keySet.setServerWriteKey(PseudoRandomFunction.compute(prfAlgorithm, keySet.getServerWriteKey(), "server write key", clientAndServerRandom, keySize));
        int blockSize = AlgorithmResolver.getCipher(cipherSuite).getBlocksize();
        byte[] emptySecret = new byte[]{};
        byte[] ivBlock = PseudoRandomFunction.compute(prfAlgorithm, emptySecret, "IV block", clientAndServerRandom, 2 * blockSize);
        keySet.setClientWriteIv(Arrays.copyOfRange(ivBlock, 0, blockSize));
        keySet.setServerWriteIv(Arrays.copyOfRange(ivBlock, blockSize, 2 * blockSize));
    }

    private static byte[] MD5firstNBytes(int numOfBytes, byte[] ... byteArrays) {
        byte[] md5 = MD5Utils.MD5(byteArrays);
        return Arrays.copyOfRange(md5, 0, numOfBytes);
    }

    private static void deriveSSL3ExportKeys(CipherSuite cipherSuite, KeySet keySet, byte[] clientRandom, byte[] serverRandom) {
        int keySize = AlgorithmResolver.getCipher(cipherSuite).getKeySize();
        keySet.setClientWriteKey(KeySetGenerator.MD5firstNBytes(keySize, keySet.getClientWriteKey(), clientRandom, serverRandom));
        keySet.setServerWriteKey(KeySetGenerator.MD5firstNBytes(keySize, keySet.getServerWriteKey(), serverRandom, clientRandom));
        int blockSize = AlgorithmResolver.getCipher(cipherSuite).getBlocksize();
        keySet.setClientWriteIv(KeySetGenerator.MD5firstNBytes(blockSize, clientRandom, serverRandom));
        keySet.setServerWriteIv(KeySetGenerator.MD5firstNBytes(blockSize, serverRandom, clientRandom));
    }

    private static int getSecretSetSize(ProtocolVersion protocolVersion, CipherSuite cipherSuite) throws CryptoException {
        switch (AlgorithmResolver.getCipherType(cipherSuite)) {
            case AEAD: {
                return KeySetGenerator.getAeadSecretSetSize(protocolVersion, cipherSuite);
            }
            case BLOCK: {
                return KeySetGenerator.getBlockSecretSetSize(protocolVersion, cipherSuite);
            }
            case STREAM: {
                return KeySetGenerator.getStreamSecretSetSize(protocolVersion, cipherSuite);
            }
        }
        throw new CryptoException("Unknown CipherType");
    }

    private static int getBlockSecretSetSize(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        CipherAlgorithm cipherAlg = AlgorithmResolver.getCipher(cipherSuite);
        int keySize = cipherAlg.getKeySize();
        MacAlgorithm macAlg = AlgorithmResolver.getMacAlgorithm(protocolVersion, cipherSuite);
        int secretSetSize = 2 * keySize + 2 * macAlg.getKeySize();
        if (!protocolVersion.usesExplicitIv()) {
            secretSetSize += 2 * cipherAlg.getNonceBytesFromHandshake();
        }
        return secretSetSize;
    }

    private static int getAeadSecretSetSize(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        CipherAlgorithm cipherAlg = AlgorithmResolver.getCipher(cipherSuite);
        int keySize = cipherAlg.getKeySize();
        int saltSize = 12 - cipherAlg.getNonceBytesFromRecord();
        int secretSetSize = 2 * keySize + 2 * saltSize;
        return secretSetSize;
    }

    private static int getStreamSecretSetSize(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        CipherAlgorithm cipherAlg = AlgorithmResolver.getCipher(cipherSuite);
        MacAlgorithm macAlg = AlgorithmResolver.getMacAlgorithm(protocolVersion, cipherSuite);
        int secretSetSize = 2 * cipherAlg.getKeySize() + 2 * macAlg.getKeySize();
        if (cipherSuite.isSteamCipherWithIV()) {
            secretSetSize += 2 * cipherAlg.getNonceBytesFromHandshake();
        }
        return secretSetSize;
    }

    private KeySetGenerator() {
    }
}

