/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BasePipelineFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.protocol.OrbcommProtocolPoller;

public class OrbcommProtocolDecoder
extends BaseProtocolDecoder {
    public OrbcommProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        OrbcommProtocolPoller poller;
        FullHttpResponse response = (FullHttpResponse)msg;
        String content = response.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        if (channel != null && (poller = BasePipelineFactory.getHandler(channel.pipeline(), OrbcommProtocolPoller.class)) != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            poller.setStartTime(dateFormat.parse(json.getString("NextStartUTC")));
        }
        return null;
    }
}

