/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.TechnologyTreePanel;

public class ContextTechnologyPanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("context.technology.title");
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelSession = null;
    private TechnologyTreePanel techPanel;

    public static String getPanelName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    public ContextTechnologyPanel(Context context) {
        super(context.getId());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextTechnologyPanel.getPanelName(this.getContextId()));
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new BorderLayout());
            this.panelSession.setName("SessionTech");
            this.panelSession.add((Component)this.getTechTree(), "Center");
        }
        return this.panelSession;
    }

    private TechnologyTreePanel getTechTree() {
        if (this.techPanel == null) {
            this.techPanel = new TechnologyTreePanel(Constant.messages.getString("context.technology.tree.root"));
        }
        return this.techPanel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context uiContext) {
        this.getTechTree().refresh();
        this.getTechTree().setTechSet(uiContext.getTechSet());
    }

    @Override
    public void validateContextData(Session session) throws Exception {
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        session.getContext(this.getContextId()).setTechSet(this.getTechTree().getTechSet());
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        uiSharedContext.setTechSet(this.getTechTree().getTechSet());
    }
}

