# vim: set fileencoding=utf-8 :

# ***********************IMPORTANT NMAP LICENSE TERMS************************
# *                                                                         *
# * The Nmap Security Scanner is (C) 1996-2020 Insecure.Com LLC ("The Nmap  *
# * Project"). Nmap is also a registered trademark of the Nmap Project.     *
# *                                                                         *
# * This program is distributed under the terms of the Nmap Public Source   *
# * License (NPSL). The exact license text applying to a particular Nmap    *
# * release or source code control revision is contained in the LICENSE     *
# * file distributed with that version of Nmap or source code control       *
# * revision. More Nmap copyright/legal information is available from       *
# * https://nmap.org/book/man-legal.html, and further information on the    *
# * NPSL license itself can be found at https://nmap.org/npsl. This header  *
# * summarizes some key points from the Nmap license, but is no substitute  *
# * for the actual license text.                                            *
# *                                                                         *
# * Nmap is generally free for end users to download and use themselves,    *
# * including commercial use. It is available from https://nmap.org.        *
# *                                                                         *
# * The Nmap license generally prohibits companies from using and           *
# * redistributing Nmap in commercial products, but we sell a special Nmap  *
# * OEM Edition with a more permissive license and special features for     *
# * this purpose. See https://nmap.org/oem                                  *
# *                                                                         *
# * If you have received a written Nmap license agreement or contract       *
# * stating terms other than these (such as an Nmap OEM license), you may   *
# * choose to use and redistribute Nmap under those terms instead.          *
# *                                                                         *
# * The official Nmap Windows builds include the Npcap software             *
# * (https://npcap.org) for packet capture and transmission. It is under    *
# * separate license terms which forbid redistribution without special      *
# * permission. So the official Nmap Windows builds may not be              *
# * redistributed without special permission (such as an Nmap OEM           *
# * license).                                                               *
# *                                                                         *
# * Source is provided to this software because we believe users have a     *
# * right to know exactly what a program is going to do before they run it. *
# * This also allows you to audit the software for security holes.          *
# *                                                                         *
# * Source code also allows you to port Nmap to new platforms, fix bugs,    *
# * and add new features.  You are highly encouraged to submit your         *
# * changes as a Github PR or by email to the dev@nmap.org mailing list     *
# * for possible incorporation into the main distribution. Unless you       *
# * specify otherwise, it is understood that you are offering us very       *
# * broad rights to use your submissions as described in the Nmap Public    *
# * Source License Contributor Agreement. This is important because we      *
# * fund the project by selling licenses with various terms, and also       *
# * because the inability to relicense code has caused devastating          *
# * problems for other Free Software projects (such as KDE and NASM).       *
# *                                                                         *
# * The free version of Nmap is distributed in the hope that it will be     *
# * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of  *
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. Warranties,        *
# * indemnification and commercial support are all available through the    *
# * Npcap OEM program--see https://nmap.org/oem.                            *
# *                                                                         *
# ***************************************************************************/

import gtk
import pango

import radialnet.util.drawing as drawing

from radialnet.bestwidgets.windows import BWWindow
from radialnet.bestwidgets.boxes import BWVBox, BWHBox
from radialnet.bestwidgets.labels import BWSectionLabel
from radialnet.gui.Image import Application
from radialnet.gui.NodeNotebook import NodeNotebook


DIMENSION_NORMAL = (600, 400)


class NodeWindow(BWWindow):
    """
    """
    def __init__(self, node, position):
        """
        """
        BWWindow.__init__(self, gtk.WINDOW_TOPLEVEL)
        self.move(position[0], position[1])
        self.set_default_size(DIMENSION_NORMAL[0], DIMENSION_NORMAL[1])

        self.__node = node

        self.__title_font = pango.FontDescription('Monospace Bold')

        self.__icon = Application()
        self.__create_widgets()

    def __create_widgets(self):
        """
        """
        self.__content = BWVBox()
        self.__head = BWHBox(spacing=2)

        self.__notebook = NodeNotebook(self.__node)

        # create head elements

        # icon with node's score color
        self.__color_box = gtk.EventBox()
        self.__color_image = gtk.Image()
        self.__color_image.set_from_file(self.__icon.get_icon('border'))
        self.__color_box.add(self.__color_image)
        self.__color_box.set_size_request(15, 15)
        r, g, b = drawing.cairo_to_gdk_color(
                self.__node.get_draw_info('color'))
        self.__color_box.modify_bg(gtk.STATE_NORMAL, gtk.gdk.Color(r, g, b))

        # title with the node ip and hostname
        self.__title = self.__node.get_host().get_hostname()

        self.set_title(self.__title)

        self.__title_label = BWSectionLabel(self.__title)
        self.__title_label.modify_font(self.__title_font)

        # packing head elements
        self.__head.bw_pack_start_noexpand_nofill(self.__color_box)
        self.__head.bw_pack_start_expand_fill(self.__title_label)

        # packing all to content
        self.__content.bw_pack_start_noexpand_nofill(self.__head)
        self.__content.bw_pack_start_expand_fill(self.__notebook)

        # add content to window
        self.add(self.__content)
