/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractImportCheck;
import com.puppycrawl.tools.checkstyle.checks.ClassResolver;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RedundantThrowsCheck
extends AbstractImportCheck {
    private boolean mAllowUnchecked = false;
    private boolean mAllowSubclasses = false;
    private FullIdent mPackageFullIdent = null;
    private Set mImports = new HashSet();
    private ClassResolver mClassResolver;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    public void setAllowUnchecked(boolean aAllowUnchecked) {
        this.mAllowUnchecked = aAllowUnchecked;
    }

    public void setAllowSubclasses(boolean aAllowSubclasses) {
        this.mAllowSubclasses = aAllowSubclasses;
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 30, 9, 8};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mPackageFullIdent = FullIdent.createFullIdent(null);
        this.mImports.clear();
        this.mClassResolver = null;
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            this.processPackage(aAST);
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else {
            this.processMethod(aAST);
        }
    }

    private void processPackage(DetailAST aAST) {
        DetailAST nameAST = (DetailAST)aAST.getFirstChild();
        this.mPackageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = this.getImportText(aAST);
        if (name != null) {
            this.mImports.add(name.getText());
        }
    }

    private void processMethod(DetailAST aAST) {
        LinkedList knownExcs = new LinkedList();
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            DetailAST child = (DetailAST)throwsAST.getFirstChild();
            while (child != null) {
                if (child.getType() == 58 || child.getType() == 59) {
                    FullIdent fi = FullIdent.createFullIdent(child);
                    this.checkException(fi, knownExcs);
                }
                child = (DetailAST)child.getNextSibling();
            }
        }
    }

    private void checkException(FullIdent aExc, List aKnownExcs) {
        if (!this.mAllowUnchecked && this.isUnchecked(aExc)) {
            this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.unchecked", (Object)aExc.getText());
        }
        boolean shouldAdd = true;
        Iterator known = aKnownExcs.iterator();
        while (known.hasNext()) {
            FullIdent fi = (FullIdent)known.next();
            if (this.isSameType(fi.getText(), aExc.getText())) {
                shouldAdd = false;
                this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.duplicate", (Object)aExc.getText());
                continue;
            }
            if (this.mAllowSubclasses) continue;
            if (this.isSubclass(fi, aExc)) {
                known.remove();
                this.log(fi.getLineNo(), fi.getColumnNo(), "redundant.throws.subclass", fi.getText(), aExc.getText());
                continue;
            }
            if (!this.isSubclass(aExc, fi)) continue;
            shouldAdd = false;
            this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.subclass", aExc.getText(), fi.getText());
        }
        if (shouldAdd) {
            aKnownExcs.add(aExc);
        }
    }

    private boolean isSubclass(FullIdent aChild, FullIdent aParent) {
        ClassResolver cr = this.getClassResolver();
        try {
            Class childClass = cr.resolve(aChild.getText());
            try {
                Class parentClass = cr.resolve(aParent.getText());
                return parentClass.isAssignableFrom(childClass);
            }
            catch (ClassNotFoundException e) {
                this.log(aChild.getLineNo(), aChild.getColumnNo(), "redundant.throws.classInfo", (Object)aParent.getText());
            }
        }
        catch (ClassNotFoundException e) {
            this.log(aChild.getLineNo(), aChild.getColumnNo(), "redundant.throws.classInfo", (Object)aChild.getText());
        }
        return true;
    }

    private boolean isUnchecked(FullIdent aException) {
        ClassResolver cr = this.getClassResolver();
        try {
            Class clazz = cr.resolve(aException.getText());
            return (class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = RedundantThrowsCheck.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).isAssignableFrom(clazz) || (class$java$lang$Error == null ? (class$java$lang$Error = RedundantThrowsCheck.class$("java.lang.Error")) : class$java$lang$Error).isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            this.log(aException.getLineNo(), aException.getColumnNo(), "redundant.throws.classInfo", (Object)aException.getText());
            return false;
        }
    }

    private boolean isSameType(String aFirst, String aSecond) {
        return aFirst.equals(aSecond) || this.isShortName(aFirst, aSecond) || this.isShortName(aSecond, aFirst);
    }

    private boolean isShortName(String aShortName, String aFullName) {
        if (aShortName.length() >= aFullName.length()) {
            return false;
        }
        String base = Utils.baseClassname(aFullName);
        if (aShortName.length() >= aFullName.length() || !base.equals(aShortName)) {
            return false;
        }
        if (this.mImports.contains(aFullName)) {
            return true;
        }
        int endIndex = aFullName.length() - base.length() - 1;
        String packageName = aFullName.substring(0, endIndex);
        String starImport = packageName + ".*";
        if (this.mImports.contains(starImport)) {
            return true;
        }
        return packageName.equals(this.mPackageFullIdent.getText());
    }

    private ClassResolver getClassResolver() {
        if (this.mClassResolver == null) {
            this.mClassResolver = new ClassResolver(this.getClassLoader(), this.mPackageFullIdent.getText(), this.mImports);
        }
        return this.mClassResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

