"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Registry = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _lodash = require("lodash");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var Registry = /*#__PURE__*/function () {
  function Registry() {
    var prop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'name';
    (0, _classCallCheck2.default)(this, Registry);
    if (typeof prop !== 'string') throw new Error('Registry property name must be a string');
    this._prop = prop;
    this._indexed = new Object();
  }

  (0, _createClass2.default)(Registry, [{
    key: "wrapper",
    value: function wrapper(obj) {
      return obj;
    }
  }, {
    key: "register",
    value: function register(fn) {
      var obj = typeof fn === 'function' ? fn() : fn;

      if (typeof obj !== 'object' || !obj[this._prop]) {
        throw new Error("Registered functions must return an object with a ".concat(this._prop, " property"));
      }

      this._indexed[obj[this._prop].toLowerCase()] = this.wrapper(obj);
    }
  }, {
    key: "toJS",
    value: function toJS() {
      var _this = this;

      return Object.keys(this._indexed).reduce(function (acc, key) {
        acc[key] = _this.get(key);
        return acc;
      }, {});
    }
  }, {
    key: "toArray",
    value: function toArray() {
      var _this2 = this;

      return Object.keys(this._indexed).map(function (key) {
        return _this2.get(key);
      });
    }
  }, {
    key: "get",
    value: function get(name) {
      if (name === undefined) return null;
      var lowerCaseName = name.toLowerCase();
      return this._indexed[lowerCaseName] ? (0, _lodash.clone)(this._indexed[lowerCaseName]) : null;
    }
  }, {
    key: "getProp",
    value: function getProp() {
      return this._prop;
    }
  }, {
    key: "reset",
    value: function reset() {
      this._indexed = new Object();
    }
  }]);
  return Registry;
}();

exports.Registry = Registry;