'''OpenGL extension ARB.ES3_1_compatibility

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.ES3_1_compatibility to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds support for features of OpenGL ES 3.1 that are
	missing from OpenGL 4.4. Enabling these features will ease the process
	of porting applications from OpenGL ES 3.1 to OpenGL.
	
	In particular this adds the following features:
	
	- a new MemoryBarrierByRegion API which is potentially more efficient
	for specific localized memory access patterns.
	
	- increases the minimum required size of SSBOs to 2^27 (128 MB).
	
	- support for GLSL ES version 310 (ie #version 310 es).
	
	- a new GLSL built-in function, imageAtomicExchange, which performs atomic
	exchanges on r32f floating point images.
	
	- a new GLSL built-in fragment shader input, gl_HelperInvocation, that
	identifies whether the current fragment shader input is a helper
	invocation.  Fragment shader code can use this variable to skip performing
	operations that are useless or potentially dangerous for helper
	invocations.
	
	- a new GLSL built-in constant for the maximum supported samples:
	gl_MaxSamples.
	
	- a number of new GLSL built-in constants mirroring the API limits for
	image uniforms: gl_Max*ImageUniforms, gl_MaxCombinedShaderOutputResources.
	
	- new GLSL built-in functions which extend mix() to select between int,
	uint, and bool components.
	
	- add the "coherent" qualifier to all memory variables taken by the GLSL
	built-in atomic* and imageAtomic* functions.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/ES3_1_compatibility.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.ES3_1_compatibility import *
from OpenGL.raw.GL.ARB.ES3_1_compatibility import _EXTENSION_NAME

def glInitEs31CompatibilityARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION