/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;

public class PNodeCache
extends PNode {
    private transient Image imageCache;
    private boolean validatingCache;

    public Image createImageCache(Dimension2D dimension2D) {
        return this.toImage();
    }

    public Image getImageCache() {
        if (this.imageCache == null) {
            PDimension pDimension = new PDimension();
            this.validatingCache = true;
            this.resetBounds();
            this.imageCache = this.createImageCache(pDimension);
            PBounds pBounds = this.getFullBoundsReference();
            this.setBounds(pBounds.getX() + pDimension.getWidth(), pBounds.getY() + pDimension.getHeight(), this.imageCache.getWidth(null), this.imageCache.getHeight(null));
            this.validatingCache = false;
        }
        return this.imageCache;
    }

    public void invalidateCache() {
        this.imageCache = null;
    }

    public void invalidatePaint() {
        if (!this.validatingCache) {
            super.invalidatePaint();
        }
    }

    public void repaintFrom(PBounds pBounds, PNode pNode) {
        if (!this.validatingCache) {
            super.repaintFrom(pBounds, pNode);
            this.invalidateCache();
        }
    }

    public void fullPaint(PPaintContext pPaintContext) {
        if (this.validatingCache) {
            super.fullPaint(pPaintContext);
        } else {
            Graphics2D graphics2D = pPaintContext.getGraphics();
            graphics2D.drawImage(this.getImageCache(), (int)this.getX(), (int)this.getY(), null);
        }
    }

    protected boolean pickAfterChildren(PPickPath pPickPath) {
        return false;
    }
}

