/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.FastMap;

public final class CachedMap
implements Map {
    private final FastMap _backingFastMap;
    private final Map _backingMap;
    private final FastMap _keysMap;
    private final int _mask;
    private final Object[] _keys;
    private final Object[] _values;

    public CachedMap() {
        this(256, new FastMap());
    }

    public CachedMap(int cacheSize) {
        this(cacheSize, new FastMap(cacheSize));
    }

    public CachedMap(int cacheSize, Map backingMap) {
        int actualCacheSize;
        for (actualCacheSize = 1; actualCacheSize < cacheSize; actualCacheSize <<= 1) {
        }
        this._keys = new Object[actualCacheSize];
        this._values = new Object[actualCacheSize];
        this._mask = actualCacheSize - 1;
        if (backingMap instanceof FastMap) {
            this._backingFastMap = (FastMap)backingMap;
            this._backingMap = this._backingFastMap;
            this._keysMap = null;
        } else {
            this._backingFastMap = null;
            this._backingMap = backingMap;
            this._keysMap = new FastMap(backingMap.size());
            for (Object key2 : backingMap.keySet()) {
                this._keysMap.put(key2, key2);
            }
        }
    }

    public int getCacheSize() {
        return this._keys.length;
    }

    public Map getBackingMap() {
        return this._backingFastMap != null ? this._backingFastMap : this._backingMap;
    }

    public void flush() {
        for (int i = 0; i < this._keys.length; ++i) {
            this._keys[i] = null;
            this._values[i] = null;
        }
        if (this._keysMap != null) {
            for (Object key2 : this._backingMap.keySet()) {
                this._keysMap.put(key2, key2);
            }
        }
    }

    public Object get(Object key2) {
        int index2 = key2.hashCode() & this._mask;
        return key2.equals(this._keys[index2]) ? this._values[index2] : this.getCacheMissed(key2, index2);
    }

    private Object getCacheMissed(Object key2, int index2) {
        if (this._backingFastMap != null) {
            Map.Entry entry = this._backingFastMap.getEntry(key2);
            if (entry != null) {
                this._keys[index2] = entry.getKey();
                Object value = entry.getValue();
                this._values[index2] = value;
                return value;
            }
            return null;
        }
        Object mapKey = this._keysMap.get(key2);
        if (mapKey != null) {
            this._keys[index2] = mapKey;
            Object value = this._backingMap.get(key2);
            this._values[index2] = value;
            return value;
        }
        return null;
    }

    public Object put(Object key2, Object value) {
        int index2 = key2.hashCode() & this._mask;
        if (key2.equals(this._keys[index2])) {
            this._values[index2] = value;
        } else if (this._keysMap != null) {
            this._keysMap.put(key2, key2);
        }
        return this._backingMap.put(key2, value);
    }

    public Object remove(Object key2) {
        int index2 = key2.hashCode() & this._mask;
        if (key2.equals(this._keys[index2])) {
            this._keys[index2] = null;
        }
        if (this._keysMap != null) {
            this._keysMap.remove(key2);
        }
        return this._backingMap.remove(key2);
    }

    @Override
    public boolean containsKey(Object key2) {
        int index2 = key2.hashCode() & this._mask;
        if (key2.equals(this._keys[index2])) {
            return true;
        }
        return this._backingMap.containsKey(key2);
    }

    @Override
    public int size() {
        return this._backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._backingMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this._backingMap.containsValue(value);
    }

    public void putAll(Map map2) {
        this._backingMap.putAll(map2);
        this.flush();
    }

    @Override
    public void clear() {
        this._backingMap.clear();
        this.flush();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this._backingMap.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this._backingMap.values());
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this._backingMap.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this._backingMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this._backingMap.hashCode();
    }
}

