/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptedDataProcessor
implements Processor {
    private byte[] symmKey;

    public String getId() {
        return null;
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        Element kiElem = (Element)WSSecurityUtil.findElement(elem, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        NodeList children = kiElem.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            QName el;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(el = new QName(child.getNamespaceURI(), child.getLocalName())).equals(WSSecurityEngine.ENCRYPTED_KEY)) continue;
            EncryptedKeyProcessor encrKeyProc = new EncryptedKeyProcessor();
            encrKeyProc.handleToken((Element)child, crypto, decCrypto, cb, wsDocInfo, returnResults, config);
            this.symmKey = encrKeyProc.getDecryptedBytes();
            break;
        }
        String encAlgo = X509Util.getEncAlgo(elem);
        SecretKey key = WSSecurityUtil.prepareSecretKey(encAlgo, this.symmKey);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)encAlgo);
            xmlCipher.init(2, (Key)key);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        Node previousSibling = elem.getPreviousSibling();
        try {
            xmlCipher.doFinal(elem.getOwnerDocument(), elem, false);
        }
        catch (Exception e) {
            throw new WSSecurityException(8, null, null, e);
        }
        Element decryptedElem = (Element)previousSibling.getNextSibling();
        QName el = new QName(decryptedElem.getNamespaceURI(), decryptedElem.getLocalName());
        Processor proc = config.getProcessor(el);
        proc.handleToken(decryptedElem, crypto, decCrypto, cb, wsDocInfo, returnResults, config);
        wsDocInfo.setProcessor(proc);
    }
}

