/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.util.GFileUtils;

public class CopyingClasspathFileTransformer
implements ClasspathFileTransformer {
    private final GlobalCacheLocations globalCacheLocations;

    public CopyingClasspathFileTransformer(GlobalCacheLocations globalCacheLocations) {
        this.globalCacheLocations = globalCacheLocations;
    }

    @Override
    public File transform(File source, CompleteFileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        if (sourceSnapshot.getType() != FileType.RegularFile) {
            return source;
        }
        if (this.globalCacheLocations.isInsideGlobalCache(source.getAbsolutePath())) {
            return source;
        }
        File cachedFile = new File(cacheDir, "o_" + sourceSnapshot.getHash().toString() + '/' + source.getName());
        if (!cachedFile.isFile()) {
            GFileUtils.copyFile((File)source, (File)cachedFile);
        }
        return cachedFile;
    }
}

