/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.tagger;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.solr.handler.tagger.TagClusterReducer;
import org.apache.solr.handler.tagger.TagLL;
import org.apache.solr.handler.tagger.TaggingAttribute;
import org.apache.solr.handler.tagger.TermPrefixCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tagger {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TokenStream tokenStream;
    private final TermToBytesRefAttribute byteRefAtt;
    private final PositionIncrementAttribute posIncAtt;
    private final OffsetAttribute offsetAtt;
    private final TaggingAttribute taggingAtt;
    private final TagClusterReducer tagClusterReducer;
    private final Terms terms;
    private final Bits liveDocs;
    private final boolean skipAltTokens;
    private final boolean ignoreStopWords;
    private Map<BytesRef, IntsRef> docIdsCache;
    private boolean loggedSkippedAltTokenWarning = false;

    public Tagger(Terms terms, Bits liveDocs, TokenStream tokenStream, TagClusterReducer tagClusterReducer, boolean skipAltTokens, boolean ignoreStopWords) throws IOException {
        this.terms = terms;
        this.liveDocs = liveDocs;
        this.tokenStream = tokenStream;
        this.skipAltTokens = skipAltTokens;
        this.ignoreStopWords = ignoreStopWords;
        this.byteRefAtt = (TermToBytesRefAttribute)tokenStream.addAttribute(TermToBytesRefAttribute.class);
        this.posIncAtt = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
        this.offsetAtt = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
        this.taggingAtt = (TaggingAttribute)tokenStream.addAttribute(TaggingAttribute.class);
        tokenStream.reset();
        this.tagClusterReducer = tagClusterReducer;
    }

    public void enableDocIdsCache(int initSize) {
        if (initSize > 0) {
            this.docIdsCache = new HashMap<BytesRef, IntsRef>(initSize);
        }
    }

    public void process() throws IOException {
        if (this.terms == null) {
            return;
        }
        TagLL[] head = new TagLL[1];
        TermPrefixCursor cursor = null;
        boolean skippedTokens = false;
        block0: while (this.tokenStream.incrementToken()) {
            BytesRef term;
            if (log.isTraceEnabled()) {
                log.trace("Token: {}, posInc: {},  offset: [{},{}]", new Object[]{this.byteRefAtt, this.posIncAtt.getPositionIncrement(), this.offsetAtt.startOffset(), this.offsetAtt.endOffset()});
            }
            if (this.posIncAtt.getPositionIncrement() < 1) {
                if (!this.skipAltTokens) {
                    throw new IllegalStateException("Query Analyzer generates alternate Tokens (posInc == 0). Please adapt your Analyzer configuration or enable 'skipAltTokens' to skip such tokens. NOTE: enabling 'skipAltTokens' might result in wrong tagging results if the index time analyzer is not configured accordingly. For detailed information see https://github.com/OpenSextant/SolrTextTagger/pull/11#issuecomment-24936225");
                }
                skippedTokens = true;
                log.trace("  ... ignored token");
                continue;
            }
            if (!this.ignoreStopWords && this.posIncAtt.getPositionIncrement() > 1) {
                log.trace("   - posInc > 1 ... mark cluster as done");
                this.advanceTagsAndProcessClusterIfDone(head, null);
            }
            if (this.taggingAtt.isTaggable() || head[0] != null) {
                term = this.byteRefAtt.getBytesRef();
                if (term.length == 0) {
                    throw new IllegalArgumentException("term: " + term.utf8ToString() + " analyzed to a zero-length token");
                }
            } else {
                term = null;
            }
            this.advanceTagsAndProcessClusterIfDone(head, term);
            if (!this.taggingAtt.isTaggable() || term == null) continue;
            if (cursor == null) {
                cursor = new TermPrefixCursor(this.terms.iterator(), this.liveDocs, this.docIdsCache);
            }
            if (!cursor.advance(term)) continue;
            TagLL newTail = new TagLL(head, cursor, this.offsetAtt.startOffset(), this.offsetAtt.endOffset(), null);
            cursor = null;
            if (head[0] == null) {
                head[0] = newTail;
                continue;
            }
            TagLL t = head[0];
            while (true) {
                if (t.nextTag == null) {
                    t.addAfterLL(newTail);
                    continue block0;
                }
                t = t.nextTag;
            }
        }
        this.advanceTagsAndProcessClusterIfDone(head, null);
        assert (head[0] == null);
        if (!this.loggedSkippedAltTokenWarning && skippedTokens) {
            this.loggedSkippedAltTokenWarning = true;
            log.warn("{}{}{}{}", new Object[]{"The Tagger skipped some alternate tokens (tokens with posInc == 0) ", "while processing text. This may cause problems with some Analyzer ", "configurations (e.g. query time synonym expansion). For details see ", "https://github.com/OpenSextant/SolrTextTagger/pull/11#issuecomment-24936225"});
        }
        this.tokenStream.end();
    }

    private void advanceTagsAndProcessClusterIfDone(TagLL[] head, BytesRef term) throws IOException {
        int endOffset = term != null ? this.offsetAtt.endOffset() : -1;
        boolean anyAdvance = false;
        TagLL t = head[0];
        while (t != null) {
            anyAdvance |= t.advance(term, endOffset);
            t = t.nextTag;
        }
        if (!anyAdvance && head[0] != null) {
            this.tagClusterReducer.reduce(head);
            t = head[0];
            while (t != null) {
                assert (t.value != null);
                this.tagCallback(t.startOffset, t.endOffset, t.value);
                t = t.nextTag;
            }
            head[0] = null;
        }
    }

    protected abstract void tagCallback(int var1, int var2, Object var3);

    protected IntsRef lookupDocIds(Object docIdsKey) {
        return (IntsRef)docIdsKey;
    }
}

