/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.join.BlockJoinFacetComponentSupport;
import org.apache.solr.search.join.BlockJoinFieldFacetAccumulator;

class BlockJoinFacetAccsHolder {
    private BlockJoinFieldFacetAccumulator[] blockJoinFieldFacetAccumulators;
    private boolean firstSegment = true;

    BlockJoinFacetAccsHolder(SolrQueryRequest req) throws IOException {
        String[] facetFieldNames = BlockJoinFacetComponentSupport.getChildFacetFields(req);
        assert (facetFieldNames != null);
        this.blockJoinFieldFacetAccumulators = new BlockJoinFieldFacetAccumulator[facetFieldNames.length];
        for (int i = 0; i < facetFieldNames.length; ++i) {
            this.blockJoinFieldFacetAccumulators[i] = new BlockJoinFieldFacetAccumulator(facetFieldNames[i], req.getSearcher());
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        for (BlockJoinFieldFacetAccumulator blockJoinFieldFacetAccumulator : this.blockJoinFieldFacetAccumulators) {
            if (!this.firstSegment) {
                blockJoinFieldFacetAccumulator.migrateGlobal();
            }
            blockJoinFieldFacetAccumulator.setNextReader(context);
        }
        this.firstSegment = false;
    }

    public void finish() throws IOException {
        for (BlockJoinFieldFacetAccumulator blockJoinFieldFacetAccumulator : this.blockJoinFieldFacetAccumulators) {
            blockJoinFieldFacetAccumulator.migrateGlobal();
        }
    }

    protected void countFacets(BlockJoinFieldFacetAccumulator.AggregatableDocIter iter) throws IOException {
        for (BlockJoinFieldFacetAccumulator blockJoinFieldFacetAccumulator : this.blockJoinFieldFacetAccumulators) {
            blockJoinFieldFacetAccumulator.updateCountsWithMatchedBlock(iter);
        }
    }

    NamedList getFacets() throws IOException {
        NamedList facets = new NamedList(this.blockJoinFieldFacetAccumulators.length);
        for (BlockJoinFieldFacetAccumulator state : this.blockJoinFieldFacetAccumulators) {
            facets.add(state.getFieldName(), state.getFacetValue());
        }
        return facets;
    }
}

