/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.IPThrottler;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

class PeerTestManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _packetBuilder;
    private final PacketBuilder2 _packetBuilder2;
    private final Map<Long, PeerTestState> _activeTests;
    private PeerTestState _currentTest;
    private boolean _currentTestComplete;
    private final Queue<Long> _recentTests;
    private final IPThrottler _throttle;
    private static final int MAX_RELAYED_PER_TEST_ALICE = 9;
    private static final int MAX_RELAYED_PER_TEST_BOB = 6;
    private static final int MAX_RELAYED_PER_TEST_CHARLIE = 6;
    private static final int MAX_CHARLIE_LIFETIME = 15000;
    private static final int MAX_ACTIVE_TESTS = 20;
    private static final int MAX_RECENT_TESTS = 40;
    private static final int MAX_PER_IP = 12;
    private static final long THROTTLE_CLEAN_TIME = 600000L;
    private static final int RESEND_TIMEOUT = 4000;
    private static final int MAX_TEST_TIME = 30000;
    private static final long MAX_SKEW = 120000L;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final long CHARLIE_RECENT_PERIOD = 600000L;

    public PeerTestManager(RouterContext context, UDPTransport transport) {
        this._context = context;
        this._transport = transport;
        this._log = context.logManager().getLog(PeerTestManager.class);
        this._activeTests = new ConcurrentHashMap<Long, PeerTestState>();
        this._recentTests = new LinkedBlockingQueue<Long>();
        this._packetBuilder = transport.getBuilder();
        this._packetBuilder2 = transport.getBuilder2();
        this._throttle = new IPThrottler(12, 600000L);
        this._context.statManager().createRateStat("udp.statusKnownCharlie", "How often the bob we pick passes us to a charlie we already have a session with?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveTestReply", "How often we get a reply to our peer test?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveTest", "How often we get a packet requesting us to participate in a peer test?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.testBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
    }

    public synchronized void runTest(PeerState bob) {
        if (this._currentTest != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("We are already running a test: " + this._currentTest + ", aborting test with bob = " + bob);
            }
            return;
        }
        InetAddress bobIP = bob.getRemoteIPAddress();
        if (this._transport.isTooClose(bobIP.getAddress())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not running test with Bob too close to us " + bobIP);
            }
            return;
        }
        PeerTestState test = new PeerTestState(PeerTestState.Role.ALICE, bob, bobIP instanceof Inet6Address, this._context.random().nextLong(0xFFFFFFFFL), this._context.clock().now());
        if (bob.getVersion() == 2) {
            PeerState2 b2 = (PeerState2)bob;
            try {
                InetAddress addr = InetAddress.getByAddress(b2.getOurIP());
                test.setAlice(addr, b2.getOurPort(), this._context.routerHash());
            }
            catch (UnknownHostException uhe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Unable to get our IP", uhe);
                }
                return;
            }
        }
        this._currentTest = test;
        this._currentTestComplete = false;
        if (this._log.shouldLog(10)) {
            this._log.debug("Start new test: " + test);
        }
        while (this._recentTests.size() > 40) {
            this._recentTests.poll();
        }
        this._recentTests.offer(test.getNonce());
        test.incrementPacketsRelayed();
        this.sendTestToBob();
        this._context.simpleTimer2().addEvent(new ContinueTest(test.getNonce()), 4000L);
    }

    private boolean expired() {
        PeerTestState state = this._currentTest;
        if (state != null) {
            return state.getBeginTime() + 30000L < this._context.clock().now();
        }
        return true;
    }

    private void sendTestToBob() {
        PeerTestState test = this._currentTest;
        if (!this.expired()) {
            UDPPacket packet;
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending test to Bob: " + test);
            }
            if (test.getBob().getVersion() == 1) {
                packet = this._packetBuilder.buildPeerTestFromAlice(test.getBobIP(), test.getBobPort(), test.getBobCipherKey(), test.getBobMACKey(), test.getNonce(), this._transport.getIntroKey());
            } else {
                SigningPrivateKey spk = this._context.keyManager().getSigningPrivateKey();
                PeerState2 bob = (PeerState2)test.getBob();
                byte[] data = SSU2Util.createPeerTestData(this._context, bob.getRemotePeer(), this._context.routerHash(), PeerTestState.Role.ALICE, test.getNonce(), bob.getOurIP(), bob.getOurPort(), spk);
                if (data == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("sig fail");
                    }
                    this.testComplete();
                    return;
                }
                packet = this._packetBuilder2.buildPeerTestFromAlice(data, bob);
            }
            this._transport.send(packet);
            test.setLastSendTime(this._context.clock().now());
        } else {
            this._currentTest = null;
        }
    }

    private void sendTestToCharlie() {
        PeerTestState test = this._currentTest;
        if (test == null) {
            return;
        }
        if (!this.expired()) {
            UDPPacket packet;
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending msg 6 to Charlie: " + test);
            }
            test.setLastSendTime(this._context.clock().now());
            if (test.getBob().getVersion() == 1) {
                packet = this._packetBuilder.buildPeerTestFromAlice(test.getCharlieIP(), test.getCharliePort(), test.getCharlieIntroKey(), test.getNonce(), this._transport.getIntroKey());
            } else {
                long nonce = test.getNonce();
                long sendId = nonce << 32 | nonce;
                long rcvId = sendId ^ 0xFFFFFFFFFFFFFFFFL;
                InetAddress addr = test.getAliceIP();
                int alicePort = test.getAlicePort();
                byte[] aliceIP = addr.getAddress();
                int iplen = aliceIP.length;
                byte[] data = new byte[13 + iplen];
                data[0] = 1;
                data[1] = 2;
                DataHelper.toLong(data, 2, 4, nonce);
                DataHelper.toLong(data, 6, 4, this._context.clock().now() / 1000L);
                data[10] = (byte)(iplen + 2);
                DataHelper.toLong(data, 11, 2, alicePort);
                System.arraycopy(aliceIP, 0, data, 13, iplen);
                packet = this._packetBuilder2.buildPeerTestFromAlice(test.getCharlieIP(), test.getCharliePort(), test.getCharlieIntroKey(), sendId, rcvId, data);
            }
            this._transport.send(packet);
        } else {
            this._currentTest = null;
        }
    }

    private synchronized void receiveTestReply(RemoteHostId from, PeerState fromPeer, boolean inSession, UDPPacketReader.PeerTestReader testInfo) {
        this._context.statManager().addRateData("udp.receiveTestReply", 1L);
        PeerTestState test = this._currentTest;
        if (this.expired()) {
            return;
        }
        if (this._currentTestComplete) {
            return;
        }
        if (DataHelper.eq(from.getIP(), test.getBobIP().getAddress()) && from.getPort() == test.getBobPort()) {
            if (!inSession) {
                fromPeer = test.getBob();
                Hash bob = fromPeer.getRemotePeer();
                RouterInfo bobRI = this._context.netDb().lookupRouterInfoLocally(bob);
                if (bobRI == null || VersionComparator.comp(bobRI.getVersion(), "0.9.52") >= 0) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Bob replied to us (Alice) with intro key " + fromPeer);
                    }
                    test.setAlicePortFromCharlie(0);
                    test.setReceiveCharlieTime(0L);
                    test.setReceiveBobTime(0L);
                    this.testComplete();
                    return;
                }
            }
            int ipSize = testInfo.readIPSize();
            boolean expectV6 = test.isIPv6();
            if (!expectV6 && ipSize != 4 || expectV6 && ipSize != 16) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bad IP length " + ipSize + " from bob's reply: " + from);
                }
                test.setAlicePortFromCharlie(0);
                test.setReceiveCharlieTime(0L);
                test.setReceiveBobTime(0L);
                this.testComplete();
                return;
            }
            byte[] ip = new byte[ipSize];
            testInfo.readIP(ip, 0);
            try {
                if (test.getReceiveBobTime() <= 0L) {
                    InetAddress addr = InetAddress.getByAddress(ip);
                    int testPort = testInfo.readPort();
                    if (testPort == 0) {
                        throw new UnknownHostException("port 0");
                    }
                    test.setAlice(addr, testPort, null);
                }
                test.setReceiveBobTime(this._context.clock().now());
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive test reply from Bob: " + test);
                }
                if (test.getAlicePortFromCharlie() > 0) {
                    this.testComplete();
                }
            }
            catch (UnknownHostException uhe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to get our IP (length " + ipSize + ") from bob's reply: " + from, uhe);
                }
                this._context.statManager().addRateData("udp.testBadIP", 1L);
            }
        } else {
            PeerState charlieSession = this._transport.getPeerState(from);
            long recentBegin = this._context.clock().now() - 600000L;
            if (charlieSession != null && (charlieSession.getLastACKSend() > recentBegin || charlieSession.getLastSendTime() > recentBegin)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bob chose a charlie we already have a session to, cancelling the test and rerunning (bob: " + this._currentTest + ", charlie: " + from + ")");
                }
                this._currentTestComplete = true;
                this._context.statManager().addRateData("udp.statusKnownCharlie", 1L);
                this.honorStatus(CommSystemFacade.Status.UNKNOWN, test.isIPv6());
                this._currentTest = null;
                return;
            }
            if (test.getReceiveCharlieTime() > 0L) {
                try {
                    int testPort = testInfo.readPort();
                    if (testPort == 0) {
                        throw new UnknownHostException("port 0");
                    }
                    test.setAlicePortFromCharlie(testPort);
                    byte[] ip = new byte[testInfo.readIPSize()];
                    int ipSize = ip.length;
                    boolean expectV6 = test.isIPv6();
                    if (!expectV6 && ipSize != 4 || expectV6 && ipSize != 16) {
                        throw new UnknownHostException("bad sz - expect v6? " + expectV6 + " act sz: " + ipSize);
                    }
                    testInfo.readIP(ip, 0);
                    InetAddress addr = InetAddress.getByAddress(ip);
                    test.setAliceIPFromCharlie(addr);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Receive test reply from Charlie: " + test);
                    }
                    if (test.getReceiveBobTime() > 0L) {
                        this.testComplete();
                    }
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie @ " + from + " said we were an invalid IP address: " + uhe.getMessage(), uhe);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
            } else {
                if (test.incrementPacketsRelayed() > 9) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Sent too many packets on the test: " + test);
                    }
                    if (!this._currentTestComplete) {
                        this.testComplete();
                    }
                    return;
                }
                if (this._log.shouldLog(20) && charlieSession != null) {
                    this._log.info("Bob chose a charlie we last acked " + DataHelper.formatDuration(this._context.clock().now() - charlieSession.getLastACKSend()) + " last sent " + DataHelper.formatDuration(this._context.clock().now() - charlieSession.getLastSendTime()) + " (bob: " + this._currentTest + ", charlie: " + from + ")");
                }
                test.setReceiveCharlieTime(this._context.clock().now());
                SessionKey charlieIntroKey = new SessionKey(new byte[32]);
                testInfo.readIntroKey(charlieIntroKey.getData(), 0);
                test.setCharlieIntroKey(charlieIntroKey);
                try {
                    test.setCharlie(InetAddress.getByAddress(from.getIP()), from.getPort(), null);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Receive test from Charlie: " + test);
                    }
                    this.sendTestToCharlie();
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Charlie's IP is b0rked: " + from);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
            }
        }
    }

    private void testComplete() {
        this._currentTestComplete = true;
        PeerTestState test = this._currentTest;
        boolean isIPv6 = test.isIPv6();
        CommSystemFacade.Status status = test.getAlicePortFromCharlie() > 0 ? (test.getAlicePort() == test.getAlicePortFromCharlie() && test.getAliceIP() != null && test.getAliceIPFromCharlie() != null && test.getAliceIP().equals(test.getAliceIPFromCharlie()) ? (isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK : CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN) : (isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED : CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN)) : (test.getReceiveCharlieTime() > 0L ? CommSystemFacade.Status.UNKNOWN : (test.getReceiveBobTime() > 0L ? (isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED : CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN) : CommSystemFacade.Status.UNKNOWN));
        if (this._log.shouldLog(20)) {
            this._log.info("Test complete: " + test);
        }
        this.honorStatus(status, isIPv6);
        this._currentTest = null;
    }

    private void honorStatus(CommSystemFacade.Status status, boolean isIPv6) {
        if (this._log.shouldLog(20)) {
            this._log.info("Test results (IPv6? " + isIPv6 + "): status = " + (Object)((Object)status));
        }
        this._transport.setReachabilityStatus(status, isIPv6);
    }

    public void receiveTest(RemoteHostId from, PeerState fromPeer, boolean inSession, UDPPacketReader reader) {
        this._context.statManager().addRateData("udp.receiveTest", 1L);
        byte[] fromIP = from.getIP();
        int fromPort = from.getPort();
        if (!(inSession && fromPeer != null || TransportUtil.isValidPort(fromPort) && this._transport.isValid(fromIP) && !this._transport.isTooClose(fromIP) && !this._context.blocklist().isBlocklisted(fromIP))) {
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid PeerTest address: " + Addresses.toString(fromIP, fromPort));
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
            return;
        }
        UDPPacketReader.PeerTestReader testInfo = reader.getPeerTestReader();
        byte[] testIP = null;
        int testPort = testInfo.readPort();
        if (testInfo.readIPSize() > 0) {
            testIP = new byte[testInfo.readIPSize()];
            testInfo.readIP(testIP, 0);
        }
        if (testPort > 0 && !TransportUtil.isValidPort(testPort) || testIP != null && (!this._transport.isValid(testIP) || testIP.length != 4 && testIP.length != 16 || this._context.blocklist().isBlocklisted(testIP))) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address in PeerTest: " + Addresses.toString(testIP, testPort));
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
            return;
        }
        long nonce = testInfo.readNonce();
        PeerTestState test = this._currentTest;
        if (test != null && test.getNonce() == nonce) {
            this.receiveTestReply(from, fromPeer, inSession, testInfo);
            return;
        }
        if (this._throttle.shouldThrottle(fromIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("PeerTest throttle from " + Addresses.toString(fromIP, fromPort));
            }
            return;
        }
        if (testIP != null && this._throttle.shouldThrottle(testIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("PeerTest throttle to " + Addresses.toString(testIP, testPort));
            }
            return;
        }
        Long lNonce = nonce;
        PeerTestState state = this._activeTests.get(lNonce);
        if (testIP != null && this._transport.isTooClose(testIP)) {
            if (this._recentTests.contains(lNonce)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Got delayed reply on nonce " + nonce + " from: " + Addresses.toString(fromIP, fromPort));
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Nearby address in PeerTest: " + Addresses.toString(testIP, testPort) + " from: " + Addresses.toString(fromIP, fromPort) + " state? " + state);
                }
                this._context.statManager().addRateData("udp.testBadIP", 1L);
            }
            return;
        }
        if (state == null) {
            if (testIP == null || testPort <= 0) {
                if (this._activeTests.size() >= 20) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Too many active tests, droppping from Alice " + Addresses.toString(fromIP, fromPort));
                    }
                    return;
                }
                if (!inSession || fromPeer == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No session, dropping new test from Alice " + Addresses.toString(fromIP, fromPort));
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("test IP/port are blank coming from " + from + ", assuming we are Bob and they are alice");
                }
                this.receiveFromAliceAsBob(from, fromPeer, testInfo, nonce, null);
            } else if (!this._recentTests.contains(lNonce)) {
                if (this._activeTests.size() >= 20) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Too many active tests, droppping from Bob " + Addresses.toString(fromIP, fromPort));
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("We are charlie, as the testIP/port is " + Addresses.toString(testIP, testPort) + " and the state is unknown for " + nonce);
                }
                this.receiveFromBobAsCharlie(from, fromPeer, inSession, testInfo, nonce, null);
            }
        } else if (state.getOurRole() == PeerTestState.Role.BOB) {
            if (DataHelper.eq(fromIP, state.getAliceIP().getAddress()) && fromPort == state.getAlicePort()) {
                if (!inSession || fromPeer == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("No session, dropping test from Alice " + Addresses.toString(fromIP, fromPort));
                    }
                    return;
                }
                this.receiveFromAliceAsBob(from, fromPeer, testInfo, nonce, state);
            } else if (DataHelper.eq(fromIP, state.getCharlieIP().getAddress()) && fromPort == state.getCharliePort()) {
                this.receiveFromCharlieAsBob(from, fromPeer, inSession, state);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Received from a fourth party as bob!  alice: " + state.getAliceIP() + ", charlie: " + state.getCharlieIP() + ", dave: " + from);
            }
        } else if (state.getOurRole() == PeerTestState.Role.CHARLIE) {
            if (testIP == null || testPort <= 0) {
                this.receiveFromAliceAsCharlie(from, testInfo, nonce, state);
            } else {
                this.receiveFromBobAsCharlie(from, fromPeer, inSession, testInfo, nonce, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveTest(RemoteHostId from, UDPPacket packet) {
        DatagramPacket pkt = packet.getPacket();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rcvConnID = DataHelper.fromLong8(data, off);
        long sendConnID = DataHelper.fromLong8(data, off + 16);
        int type = data[off + 12] & 0xFF;
        if (type != 7) {
            return;
        }
        byte[] introKey = this._transport.getSSU2StaticIntroKey();
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(introKey, 0);
        long n = DataHelper.fromLong(data, off + 8, 4);
        chacha.setNonce(n);
        try {
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            int payloadLen = len - 48;
            PTCallback cb = new PTCallback(from);
            SSU2Payload.processPayload(this._context, cb, data, off + 32, payloadLen, false);
        }
        catch (Exception e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad PeerTest packet:\n" + HexDump.dump(data, off, len), e);
            }
        }
        finally {
            chacha.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void receiveTest(RemoteHostId from, PeerState2 fromPeer, int msg, int status, Hash h, byte[] data) {
        if (data[0] == 1) {
            role = PeerTestState.Role.ALICE;
        } else if (data[0] == 3) {
            role = PeerTestState.Role.CHARLIE;
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad role " + (data[0] & 255) + " from " + from + ' ' + fromPeer);
            }
            return;
        }
        if (data[1] != 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad version " + (data[1] & 255) + " from " + from + ' ' + fromPeer);
            }
            return;
        }
        nonce = DataHelper.fromLong(data, 2, 4);
        time = DataHelper.fromLong(data, 6, 4) * 1000L;
        iplen = data[10] & 255;
        if (iplen != 0 && iplen != 6 && iplen != 18) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad IP length " + iplen);
            }
            return;
        }
        v0 = isIPv6 = iplen == 18;
        if (iplen != 0) {
            testPort = (int)DataHelper.fromLong(data, 11, 2);
            testIP = new byte[iplen - 2];
            System.arraycopy(data, 13, testIP, 0, iplen - 2);
        } else {
            testPort = 0;
            testIP = null;
            if (status == 0) {
                status = 999;
            }
        }
        lNonce = nonce;
        state = msg == 4 || msg == 5 || msg == 7 ? this._currentTest : this._activeTests.get(lNonce);
        if (this._log.shouldDebug()) {
            this._log.debug("Got peer test msg: " + msg + " status: " + status + " hash: " + h + " role: " + (Object)role + " nonce: " + nonce + " time: " + DataHelper.formatTime(time) + " ip/port: " + Addresses.toString(testIP, testPort) + " from " + fromPeer + " state: " + state);
        }
        fromIP = from.getIP();
        fromPort = from.getPort();
        if (fromPeer == null && (!TransportUtil.isValidPort(fromPort) || !this._transport.isValid(fromIP) || this._transport.isTooClose(fromIP) || this._context.blocklist().isBlocklisted(fromIP))) {
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid PeerTest address: " + Addresses.toString(fromIP, fromPort));
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
            return;
        }
        if (this._throttle.shouldThrottle(fromIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("PeerTest throttle from " + Addresses.toString(fromIP, fromPort));
            }
            return;
        }
        if (this._throttle.shouldThrottle(testIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("PeerTest throttle to " + Addresses.toString(testIP, testPort));
            }
            return;
        }
        if (msg >= 1 && msg <= 4) {
            if (fromPeer == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad msg " + msg + " out-of-session from " + from);
                }
                return;
            }
        } else if (fromPeer != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad msg " + msg + " in-session from " + fromPeer);
            }
            return;
        }
        if (msg < 3) {
            if (state != null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dup msg " + msg + " from " + fromPeer);
                }
                return;
            }
            if (this._activeTests.size() >= 20) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Too many active tests, droppping from " + Addresses.toString(fromIP, fromPort));
                }
                packet = msg == 1 ? this._packetBuilder2.buildPeerTestToAlice(3, Hash.FAKE_HASH, data, fromPeer) : this._packetBuilder2.buildPeerTestToBob(66, data, fromPeer);
                this._transport.send(packet);
                return;
            }
        } else if (state == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No state found for msg " + msg + " from " + fromPeer);
            }
            return;
        }
        if ((skew = time - (now = this._context.clock().now())) > 120000L || skew < -120000L) {
            if (this._log.shouldWarn()) {
                this._log.warn("Too skewed for msg " + msg + " from " + fromPeer);
            }
            return;
        }
        switch (msg) {
            case 1: {
                if (status != 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Msg 1 status " + status);
                    }
                    return;
                }
                charlie = this._transport.pickTestPeer(PeerTestState.Role.CHARLIE, fromPeer.getVersion(), isIPv6, from);
                if (charlie == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Unable to pick a charlie (no peer), IPv6? " + isIPv6);
                    }
                    packet = this._packetBuilder2.buildPeerTestToAlice(2, Hash.FAKE_HASH, data, fromPeer);
                    this._transport.send(packet);
                    return;
                }
                alice = fromPeer.getRemotePeer();
                aliceRI = this._context.netDb().lookupRouterInfoLocally(alice);
                if (aliceRI == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No alice RI");
                    }
                    packet = this._packetBuilder2.buildPeerTestToAlice(1, Hash.FAKE_HASH, data, fromPeer);
                    this._transport.send(packet);
                    return;
                }
                aliceIP = fromPeer.getRemoteIPAddress();
                alicePort = fromPeer.getRemotePort();
                state = new PeerTestState(PeerTestState.Role.BOB, null, isIPv6, nonce, now);
                state.setAlice(fromPeer);
                state.setAlice(aliceIP, alicePort, alice);
                state.setCharlie(charlie.getRemoteIPAddress(), charlie.getRemotePort(), charlie.getRemotePeer());
                state.setReceiveAliceTime(now);
                state.setLastSendTime(now);
                this._activeTests.put(lNonce, state);
                if (this._log.shouldDebug()) {
                    this._log.debug("Send Alice RI and msg 2 to charlie on " + state);
                }
                dbsm = new DatabaseStoreMessage(this._context);
                dbsm.setEntry(aliceRI);
                dbsm.setMessageExpiration(now + 10000L);
                this._transport.send(dbsm, charlie);
                packet = this._packetBuilder2.buildPeerTestToCharlie(alice, data, (PeerState2)charlie);
                this._transport.send(packet);
                break;
            }
            case 2: {
                if (status != 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Msg 2 status " + status);
                    }
                    return;
                }
                try {
                    aliceIP = InetAddress.getByAddress(testIP);
                }
                catch (UnknownHostException uhe) {
                    return;
                }
                aliceRI = null;
                aliceIntroKey = null;
                aps = this._transport.getPeerState(h);
                if (aps != null && aps.isIPv6() == isIPv6) {
                    rcode = 68;
                } else if (this._transport.getEstablisher().getInboundState(from) != null || this._transport.getEstablisher().getOutboundState(from) != null) {
                    rcode = 68;
                } else if (this._context.banlist().isBanlisted(h)) {
                    rcode = 69;
                } else if (!TransportUtil.isValidPort(testPort) || !this._transport.isValid(testIP) || this._transport.isTooClose(testIP) || this._context.blocklist().isBlocklisted(testIP)) {
                    rcode = 65;
                } else {
                    aliceRI = this._context.netDb().lookupRouterInfoLocally(h);
                    if (aliceRI != null) {
                        spk /* !! */  = aliceRI.getIdentity().getSigningPublicKey();
                        if (SSU2Util.validateSig(this._context, SSU2Util.PEER_TEST_PROLOGUE, fromPeer.getRemotePeer(), h, data, (SigningPublicKey)spk /* !! */ )) {
                            aliceIntroKey = PeerTestManager.getIntroKey(this.getAddress(aliceRI, isIPv6));
                            rcode = aliceIntroKey != null ? 0 : 65;
                        } else {
                            if (this._log.shouldWarn()) {
                                this._log.warn("Signature failed msg 2\n" + aliceRI);
                            }
                            rcode = 67;
                        }
                    } else {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Alice RI not found " + h);
                        }
                        rcode = 70;
                    }
                }
                if (rcode == 0) {
                    state = new PeerTestState(PeerTestState.Role.CHARLIE, fromPeer, isIPv6, nonce, now);
                    state.setAlice(aliceIP, testPort, h);
                    state.setAliceIntroKey(aliceIntroKey);
                    state.setReceiveBobTime(now);
                    state.setLastSendTime(now);
                    this._activeTests.put(lNonce, state);
                }
                spk /* !! */  = this._context.keyManager().getSigningPrivateKey();
                data = SSU2Util.createPeerTestData(this._context, fromPeer.getRemotePeer(), h, PeerTestState.Role.CHARLIE, nonce, testIP, testPort, spk /* !! */ );
                if (data == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("sig fail");
                    }
                    if (rcode == 0) {
                        this._activeTests.remove(lNonce);
                    }
                    return;
                }
                packet = this._packetBuilder2.buildPeerTestToBob(rcode, data, fromPeer);
                if (this._log.shouldDebug()) {
                    this._log.debug("Send msg 3 response " + rcode + " nonce " + lNonce + " to " + fromPeer);
                }
                this._transport.send(packet);
                if (rcode != 0) break;
                if (this._log.shouldDebug()) {
                    this._log.debug("Send msg 5 to " + Addresses.toString(testIP, testPort) + " on " + state);
                }
                rcvId = nonce << 32 | nonce;
                sendId = rcvId ^ -1L;
                packet = this._packetBuilder2.buildPeerTestToAlice(aliceIP, testPort, aliceIntroKey, true, sendId, rcvId, data);
                this._transport.send(packet);
                break;
            }
            case 3: {
                state.setReceiveCharlieTime(now);
                state.setLastSendTime(now);
                alice = state.getAlice();
                charlie = fromPeer.getRemotePeer();
                charlieRI = this._context.netDb().lookupRouterInfoLocally(charlie);
                if (charlieRI != null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Send Charlie RI to alice on " + state);
                    }
                    dbsm = new DatabaseStoreMessage(this._context);
                    dbsm.setEntry(charlieRI);
                    dbsm.setMessageExpiration(now + 10000L);
                    this._transport.send(dbsm, (PeerState)alice);
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("No charlie RI");
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Send msg 4 to alice on " + state);
                }
                packet = this._packetBuilder2.buildPeerTestToAlice(status, charlie, data, alice);
                this._transport.send(packet);
                this._activeTests.remove(lNonce);
                break;
            }
            case 4: {
                test = this._currentTest;
                if (test == null || test.getNonce() != nonce) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test nonce mismatch? " + nonce);
                    }
                    return;
                }
                test.setReceiveBobTime(now);
                test.setLastSendTime(now);
                fail = false;
                charlieRI = null;
                charlieIntroKey = null;
                charlieIP = null;
                charliePort = 0;
                cps = this._transport.getPeerState(h);
                if (status == 0) ** GOTO lbl229
                if (this._log.shouldInfo()) {
                    this._log.info("Msg 4 status " + status + ' ' + test);
                }
                ** GOTO lbl277
lbl229:
                // 1 sources

                if (cps == null || cps.isIPv6() != isIPv6) ** GOTO lbl233
                if (this._log.shouldInfo()) {
                    this._log.info("Charlie is connected " + test);
                }
                ** GOTO lbl277
lbl233:
                // 1 sources

                if (this._transport.getEstablisher().getInboundState(from) == null && this._transport.getEstablisher().getOutboundState(from) == null) ** GOTO lbl237
                if (this._log.shouldInfo()) {
                    this._log.info("Charlie is connecting " + test);
                }
                ** GOTO lbl277
lbl237:
                // 1 sources

                if (!this._context.banlist().isBanlisted(h)) ** GOTO lbl241
                if (this._log.shouldInfo()) {
                    this._log.info("Test fail ban " + h);
                }
                ** GOTO lbl277
lbl241:
                // 1 sources

                charlieRI = this._context.netDb().lookupRouterInfoLocally(h);
                if (charlieRI == null) ** GOTO lbl275
                spk = charlieRI.getIdentity().getSigningPublicKey();
                if (!SSU2Util.validateSig(this._context, SSU2Util.PEER_TEST_PROLOGUE, fromPeer.getRemotePeer(), this._context.routerHash(), data, (SigningPublicKey)spk)) ** GOTO lbl272
                ra = this.getAddress(charlieRI, isIPv6);
                if (ra == null) ** GOTO lbl269
                charlieIntroKey = PeerTestManager.getIntroKey(ra);
                if (charlieIntroKey == null && this._log.shouldWarn()) {
                    this._log.warn("Charlie intro key not found: " + test + '\n' + charlieRI);
                }
                if ((ip = ra.getIP()) == null) ** GOTO lbl262
                if (this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip)) ** GOTO lbl255
                if (this._log.shouldInfo()) {
                    this._log.info("Test fail ban/ip " + Addresses.toString(ip));
                }
                ** GOTO lbl264
lbl255:
                // 1 sources

                try {
                    charlieIP = InetAddress.getByAddress(ip);
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie IP not found: " + test + '\n' + ra, uhe);
                    }
                    ** GOTO lbl264
                }
lbl262:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Charlie IP not found: " + test + '\n' + ra);
                }
lbl264:
                // 6 sources

                if (!TransportUtil.isValidPort(charliePort = ra.getPort())) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie port bad: " + test + '\n' + ra);
                    }
                    charliePort = 0;
                }
                ** GOTO lbl277
lbl269:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Charlie address not found" + test + '\n' + charlieRI);
                }
                ** GOTO lbl277
lbl272:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Signature failed msg 4 " + test + '\n' + charlieRI);
                }
                ** GOTO lbl277
lbl275:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Charlie RI not found" + test + ' ' + h);
                }
lbl277:
                // 10 sources

                if (charlieIntroKey == null || charlieIP == null || charliePort <= 0) {
                    test.setAlicePortFromCharlie(0);
                    test.setReceiveCharlieTime(0L);
                    test.setReceiveBobTime(0L);
                    this.testComplete();
                    return;
                }
                test.setCharlie(charlieIP, charliePort, h);
                test.setCharlieIntroKey(charlieIntroKey);
                if (test.getReceiveCharlieTime() > 0L) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Send msg 6 to charlie on " + test);
                    }
                    spk = this;
                    synchronized (spk) {
                        this.sendTestToCharlie();
                        break;
                    }
                }
                if (!this._log.shouldDebug()) break;
                this._log.debug("Got msg 4 before msg 5 on " + test);
                break;
            }
            case 5: {
                test = this._currentTest;
                if (test == null || test.getNonce() != nonce) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test nonce mismatch? " + nonce);
                    }
                    return;
                }
                test.setReceiveCharlieTime(now);
                test.setAlicePortFromCharlie(testPort);
                try {
                    addr = InetAddress.getByAddress(testIP);
                    test.setAliceIPFromCharlie(addr);
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie @ " + from + " said we were an invalid IP address: " + uhe.getMessage(), uhe);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
                if (test.getCharlieIntroKey() != null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Send msg 6 to charlie on " + test);
                    }
                    uhe = this;
                    synchronized (uhe) {
                        this.sendTestToCharlie();
                        break;
                    }
                }
                if (!this._log.shouldDebug()) break;
                this._log.debug("Got msg 5 before msg 4 on " + test);
                break;
            }
            case 6: {
                state.setReceiveAliceTime(now);
                state.setLastSendTime(now);
                rcvId = nonce << 32 | nonce;
                sendId = rcvId ^ -1L;
                addr = state.getAliceIP();
                alicePort = state.getAlicePort();
                aliceIP = addr.getAddress();
                iplen = aliceIP.length;
                data = new byte[13 + iplen];
                data[0] = 3;
                data[1] = 2;
                DataHelper.toLong(data, 2, 4, nonce);
                DataHelper.toLong(data, 6, 4, now / 1000L);
                data[10] = (byte)(iplen + 2);
                DataHelper.toLong(data, 11, 2, alicePort);
                System.arraycopy(aliceIP, 0, data, 13, iplen);
                if (this._log.shouldDebug()) {
                    this._log.debug("Send msg 7 to alice on " + state);
                }
                packet = this._packetBuilder2.buildPeerTestToAlice(addr, alicePort, state.getAliceIntroKey(), false, sendId, rcvId, data);
                this._transport.send(packet);
                break;
            }
            case 7: {
                test = this._currentTest;
                if (test == null || test.getNonce() != nonce) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test nonce mismatch? " + nonce);
                    }
                    return;
                }
                if (test.getReceiveCharlieTime() <= 0L) {
                    // empty if block
                }
                test.setReceiveCharlieTime(now);
                test.setAlicePortFromCharlie(testPort);
                try {
                    addr = InetAddress.getByAddress(testIP);
                    test.setAliceIPFromCharlie(addr);
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie @ " + from + " said we were an invalid IP address: " + uhe.getMessage(), uhe);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
                if (test.getReceiveBobTime() <= 0L) break;
                this.testComplete();
                break;
            }
            default: {
                return;
            }
        }
    }

    private RouterAddress getAddress(RouterInfo ri, boolean isIPv6) {
        List<RouterAddress> addrs = this._transport.getTargetAddresses(ri);
        RouterAddress ra = null;
        for (RouterAddress addr : addrs) {
            String caps;
            if (addrs.size() > 1 && addr.getTransportStyle().equals("SSU") && addr.getOption("s") == null) continue;
            String host = addr.getHost();
            if (host == null) {
                host = "";
            }
            if ((caps = addr.getOption("caps")) == null) {
                caps = "";
            }
            if (isIPv6 ? !host.contains(":") && !caps.contains("6") : !host.contains(".") && !caps.contains("4")) continue;
            ra = addr;
            break;
        }
        return ra;
    }

    private static SessionKey getIntroKey(RouterAddress ra) {
        if (ra == null) {
            return null;
        }
        String siv = ra.getOption("i");
        if (siv == null) {
            return null;
        }
        byte[] ik = Base64.decode(siv);
        if (ik == null) {
            return null;
        }
        return new SessionKey(ik);
    }

    private void receiveFromBobAsCharlie(RemoteHostId from, PeerState bob, boolean inSession, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        if (!inSession || bob == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received from bob (" + from + ") as charlie w/o session");
            }
            return;
        }
        long now = this._context.clock().now();
        int sz = testInfo.readIPSize();
        boolean isNew = false;
        if (state == null) {
            isNew = true;
            state = new PeerTestState(PeerTestState.Role.CHARLIE, bob, sz == 16, nonce, now);
        } else if (state.getReceiveBobTime() > now - 2000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too soon, not retransmitting: " + state);
            }
            return;
        }
        byte[] aliceIPData = new byte[sz];
        try {
            testInfo.readIP(aliceIPData, 0);
            boolean expectV6 = state.isIPv6();
            if (!expectV6 && sz != 4 || expectV6 && sz != 16) {
                throw new UnknownHostException("bad sz - expect v6? " + expectV6 + " act sz: " + sz);
            }
            int alicePort = testInfo.readPort();
            if (alicePort == 0) {
                throw new UnknownHostException("port 0");
            }
            InetAddress aliceIP = InetAddress.getByAddress(aliceIPData);
            InetAddress bobIP = InetAddress.getByAddress(from.getIP());
            SessionKey aliceIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(aliceIntroKey.getData(), 0);
            state.setAlice(aliceIP, alicePort, null);
            state.setAliceIntroKey(aliceIntroKey);
            state.setReceiveBobTime(now);
            if (state.incrementPacketsRelayed() > 6) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Too many, not retransmitting: " + state);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive from Bob: " + state);
            }
            if (isNew) {
                this._activeTests.put(nonce, state);
                this._context.simpleTimer2().addEvent(new RemoveTest(nonce), 15000L);
            }
            state.setLastSendTime(now);
            UDPPacket packet = this._packetBuilder.buildPeerTestToBob(bobIP, from.getPort(), aliceIP, alicePort, aliceIntroKey, nonce, state.getBobCipherKey(), state.getBobMACKey());
            this._transport.send(packet);
            packet = this._packetBuilder.buildPeerTestToAlice(aliceIP, alicePort, aliceIntroKey, this._transport.getIntroKey(), nonce);
            this._transport.send(packet);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to build the aliceIP from " + from + ", ip size: " + sz + " ip val: " + Base64.encode(aliceIPData), uhe);
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
        }
    }

    private void receiveFromAliceAsBob(RemoteHostId from, PeerState alice, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        RouterInfo charlieInfo = null;
        int sz = from.getIP().length;
        boolean isIPv6 = sz == 16;
        PeerState charlie = state == null ? this._transport.pickTestPeer(PeerTestState.Role.CHARLIE, alice.getVersion(), isIPv6, from) : this._transport.getPeerState(new RemoteHostId(state.getCharlieIP().getAddress(), state.getCharliePort()));
        if (charlie == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to pick a charlie (no peer), IPv6? " + isIPv6);
            }
            return;
        }
        charlieInfo = this._context.netDb().lookupRouterInfoLocally(charlie.getRemotePeer());
        if (charlieInfo == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to pick a charlie (no RI), IPv6? " + isIPv6);
            }
            return;
        }
        InetAddress aliceIP = null;
        SessionKey aliceIntroKey = null;
        try {
            aliceIP = InetAddress.getByAddress(from.getIP());
            aliceIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(aliceIntroKey.getData(), 0);
            RouterAddress raddr = this._transport.getTargetAddress(charlieInfo);
            if (raddr == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to pick a charlie (no addr), IPv6? " + isIPv6);
                }
                return;
            }
            UDPAddress addr = new UDPAddress(raddr);
            byte[] ikey = addr.getIntroKey();
            if (ikey == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to pick a charlie (no ikey), IPv6? " + isIPv6);
                }
                return;
            }
            SessionKey charlieIntroKey = new SessionKey(ikey);
            long now = this._context.clock().now();
            boolean isNew = false;
            if (state == null) {
                isNew = true;
                state = new PeerTestState(PeerTestState.Role.BOB, null, isIPv6, nonce, now);
            } else if (state.getReceiveAliceTime() > now - 2000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Too soon, not retransmitting: " + state);
                }
                return;
            }
            state.setAlice(aliceIP, from.getPort(), null);
            state.setAliceIntroKey(aliceIntroKey);
            state.setAliceKeys(alice.getCurrentCipherKey(), alice.getCurrentMACKey());
            state.setCharlie(charlie.getRemoteIPAddress(), charlie.getRemotePort(), null);
            state.setCharlieIntroKey(charlieIntroKey);
            state.setReceiveAliceTime(now);
            if (state.incrementPacketsRelayed() > 6) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Too many, not retransmitting: " + state);
                }
                return;
            }
            if (isNew) {
                this._activeTests.put(nonce, state);
                this._context.simpleTimer2().addEvent(new RemoveTest(nonce), 15000L);
            }
            state.setLastSendTime(now);
            UDPPacket packet = this._packetBuilder.buildPeerTestToCharlie(aliceIP, from.getPort(), aliceIntroKey, nonce, charlie.getRemoteIPAddress(), charlie.getRemotePort(), charlie.getCurrentCipherKey(), charlie.getCurrentMACKey());
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive from Alice: " + state);
            }
            this._transport.send(packet);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to build the aliceIP from " + from, uhe);
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
        }
    }

    private void receiveFromCharlieAsBob(RemoteHostId from, PeerState charlie, boolean inSession, PeerTestState state) {
        if (!inSession || charlie == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received from charlie (" + from + ") as bob w/o session");
            }
            return;
        }
        long now = this._context.clock().now();
        if (state.getReceiveCharlieTime() > now - 2000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too soon, not retransmitting: " + state);
            }
            return;
        }
        if (state.incrementPacketsRelayed() > 6) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many, not retransmitting: " + state);
            }
            return;
        }
        state.setReceiveCharlieTime(now);
        state.setLastSendTime(now);
        UDPPacket packet = this._packetBuilder.buildPeerTestToAlice(state.getAliceIP(), state.getAlicePort(), state.getAliceCipherKey(), state.getAliceMACKey(), state.getCharlieIntroKey(), state.getNonce());
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive from Charlie, sending Alice back the OK: " + state);
        }
        this._transport.send(packet);
    }

    private void receiveFromAliceAsCharlie(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        long now = this._context.clock().now();
        if (state.getReceiveAliceTime() > now - 2000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too soon, not retransmitting: " + state);
            }
            return;
        }
        if (state.incrementPacketsRelayed() > 6) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many, not retransmitting: " + state);
            }
            return;
        }
        state.setReceiveAliceTime(now);
        state.setLastSendTime(now);
        try {
            InetAddress aliceIP = InetAddress.getByAddress(from.getIP());
            SessionKey aliceIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(aliceIntroKey.getData(), 0);
            UDPPacket packet = this._packetBuilder.buildPeerTestToAlice(aliceIP, from.getPort(), aliceIntroKey, this._transport.getIntroKey(), nonce);
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive from Alice: " + state);
            }
            this._transport.send(packet);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to build the aliceIP from " + from, uhe);
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
        }
    }

    private class PTCallback
    implements SSU2Payload.PayloadCallback {
        private final RemoteHostId _from;
        public long _timeReceived;
        public byte[] _aliceIP;
        public int _alicePort;

        public PTCallback(RemoteHostId from) {
            this._from = from;
        }

        @Override
        public void gotDateTime(long time) {
            this._timeReceived = time;
        }

        @Override
        public void gotOptions(byte[] options, boolean isHandshake) {
        }

        @Override
        public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) {
            block3: {
                try {
                    Hash h = ri.getHash();
                    if (h.equals(PeerTestManager.this._context.routerHash())) {
                        return;
                    }
                    PeerTestManager.this._context.netDb().store(h, ri);
                }
                catch (IllegalArgumentException iae) {
                    if (!PeerTestManager.this._log.shouldWarn()) break block3;
                    PeerTestManager.this._log.warn("RI store fail: " + ri, iae);
                }
            }
        }

        @Override
        public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotAddress(byte[] ip, int port) {
            this._aliceIP = ip;
            this._alicePort = port;
        }

        @Override
        public void gotRelayTagRequest() {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayTag(long tag) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayRequest(byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayResponse(int status, byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayIntro(Hash aliceHash, byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
            PeerTestManager.this.receiveTest(this._from, null, msg, status, h, data);
        }

        @Override
        public void gotToken(long token, long expires) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotI2NP(I2NPMessage msg) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotACK(long ackThru, int acks, byte[] ranges) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotTermination(int reason, long count) {
            throw new IllegalStateException("Bad block in PT");
        }
    }

    private class RemoveTest
    implements SimpleTimer.TimedEvent {
        private final long _nonce;

        public RemoveTest(long nonce) {
            this._nonce = nonce;
        }

        @Override
        public void timeReached() {
            PeerTestManager.this._activeTests.remove(this._nonce);
        }
    }

    private class ContinueTest
    implements SimpleTimer.TimedEvent {
        private final long _nonce;

        public ContinueTest(long nonce) {
            this._nonce = nonce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            PeerTestManager peerTestManager = PeerTestManager.this;
            synchronized (peerTestManager) {
                PeerTestState state = PeerTestManager.this._currentTest;
                if (state == null || state.getNonce() != this._nonce) {
                    return;
                }
                if (PeerTestManager.this.expired()) {
                    if (!PeerTestManager.this._currentTestComplete) {
                        PeerTestManager.this.testComplete();
                    }
                    return;
                }
                long timeSinceSend = PeerTestManager.this._context.clock().now() - state.getLastSendTime();
                if (timeSinceSend >= 4000L) {
                    int sent = state.incrementPacketsRelayed();
                    if (sent > 9) {
                        if (PeerTestManager.this._log.shouldLog(30)) {
                            PeerTestManager.this._log.warn("Sent too many packets: " + state);
                        }
                        if (!PeerTestManager.this._currentTestComplete) {
                            PeerTestManager.this.testComplete();
                        }
                        return;
                    }
                    if (state.getReceiveBobTime() <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else if (state.getReceiveCharlieTime() <= 0L) {
                        if (state.getBob().getVersion() == 1) {
                            PeerTestManager.this.sendTestToBob();
                        }
                    } else {
                        PeerTestManager.this.sendTestToCharlie();
                    }
                    PeerTestManager.this._context.simpleTimer2().addEvent(this, 4000 + sent * 1000);
                } else {
                    PeerTestManager.this._context.simpleTimer2().addEvent(this, 4000L - timeSinceSend);
                }
            }
        }
    }
}

