/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.animator;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Widget;

public final class ColorAnimator
extends Animator {
    private HashMap<Widget, Color> sourceBackgroundColors = new HashMap();
    private HashMap<Widget, Color> targetBackgroundColors = new HashMap();
    private HashMap<Widget, Color> sourceForegroundColors = new HashMap();
    private HashMap<Widget, Color> targetForegroundColors = new HashMap();

    public ColorAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setBackgroundColor(Widget widget, Color color) {
        assert (widget != null);
        assert (color != null);
        this.sourceBackgroundColors.clear();
        this.targetBackgroundColors.put(widget, color);
        this.start();
    }

    public void setForegroundColor(Widget widget, Color color) {
        assert (widget != null);
        assert (color != null);
        this.sourceForegroundColors.clear();
        this.targetForegroundColors.put(widget, color);
        this.start();
    }

    protected void tick(double d) {
        Paint paint;
        Paint paint2;
        Color color;
        Widget widget;
        for (Map.Entry<Widget, Color> entry : this.targetBackgroundColors.entrySet()) {
            widget = entry.getKey();
            color = this.sourceBackgroundColors.get(widget);
            if (color == null) {
                paint2 = widget.getBackground();
                color = paint2 instanceof Color ? (Color)paint2 : Color.WHITE;
                this.sourceBackgroundColors.put(widget, color);
            }
            paint2 = entry.getValue();
            paint = d >= 1.0 ? paint2 : new Color((int)((double)color.getRed() + d * (double)(((Color)paint2).getRed() - color.getRed())), (int)((double)color.getGreen() + d * (double)(((Color)paint2).getGreen() - color.getGreen())), (int)((double)color.getBlue() + d * (double)(((Color)paint2).getBlue() - color.getBlue())));
            widget.setBackground(paint);
        }
        for (Map.Entry<Widget, Color> entry : this.targetForegroundColors.entrySet()) {
            widget = entry.getKey();
            color = this.sourceForegroundColors.get(widget);
            if (color == null) {
                color = widget.getForeground();
                this.sourceForegroundColors.put(widget, color);
            }
            paint2 = entry.getValue();
            paint = d >= 1.0 ? paint2 : new Color((int)((double)color.getRed() + d * (double)(((Color)paint2).getRed() - color.getRed())), (int)((double)color.getGreen() + d * (double)(((Color)paint2).getGreen() - color.getGreen())), (int)((double)color.getBlue() + d * (double)(((Color)paint2).getBlue() - color.getBlue())));
            widget.setForeground((Color)paint);
        }
        if (d >= 1.0) {
            this.sourceBackgroundColors.clear();
            this.targetBackgroundColors.clear();
            this.sourceForegroundColors.clear();
            this.targetForegroundColors.clear();
        }
    }
}

