/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.sort;

import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableComparators;
import java.util.Comparator;
import java.util.Objects;

public class RowToColumnComparator<T>
implements Comparator<T> {
    protected RowObjectTableModel<T> model;
    protected int sortColumn;
    protected Comparator<Object> columnComparator;
    protected Comparator<T> backupRowComparator = TableComparators.getNoSortComparator();

    public RowToColumnComparator(RowObjectTableModel<T> model, int sortColumn, Comparator<Object> comparator) {
        this.model = model;
        this.sortColumn = sortColumn;
        this.columnComparator = Objects.requireNonNull(comparator);
    }

    public RowToColumnComparator(RowObjectTableModel<T> model, int sortColumn, Comparator<Object> comparator, Comparator<T> backupRowComparator) {
        this.model = model;
        this.sortColumn = sortColumn;
        this.columnComparator = Objects.requireNonNull(comparator);
        this.backupRowComparator = Objects.requireNonNull(backupRowComparator);
    }

    @Override
    public int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        Object value1 = this.getColumnValue(t1);
        Object value2 = this.getColumnValue(t2);
        if (value1 == null || value2 == null) {
            return TableComparators.compareWithNullValues(value1, value2);
        }
        int result = this.columnComparator.compare(value1, value2);
        if (result != 0) {
            return result;
        }
        return this.backupRowComparator.compare(t1, t2);
    }

    protected Object getColumnValue(T t) {
        return this.model.getColumnValueForRow(t, this.sortColumn);
    }
}

