/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.util.SignednessFormatMode;

public class IntegerSignednessFormattingModeSettingsDefinition
implements EnumSettingsDefinition {
    private static final String[] choices = new String[]{"Default", "Unsigned", "Signed"};
    protected static final String SIGN_FORMAT = "signedness-mode";
    public static final IntegerSignednessFormattingModeSettingsDefinition DEF = new IntegerSignednessFormattingModeSettingsDefinition(SignednessFormatMode.DEFAULT);
    public static final IntegerSignednessFormattingModeSettingsDefinition DEF_SIGNED = new IntegerSignednessFormattingModeSettingsDefinition(SignednessFormatMode.SIGNED);
    public static final IntegerSignednessFormattingModeSettingsDefinition DEF_UNSIGNED = new IntegerSignednessFormattingModeSettingsDefinition(SignednessFormatMode.UNSIGNED);
    private final SignednessFormatMode defaultFormat;

    private IntegerSignednessFormattingModeSettingsDefinition(SignednessFormatMode defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public SignednessFormatMode getFormatMode(Settings settings) {
        if (settings == null) {
            return this.defaultFormat;
        }
        Long value = settings.getLong(SIGN_FORMAT);
        if (value == null) {
            return this.defaultFormat;
        }
        int format = (int)value.longValue();
        SignednessFormatMode mode = SignednessFormatMode.DEFAULT;
        try {
            mode = SignednessFormatMode.parse((int)format);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return mode;
    }

    @Override
    public int getChoice(Settings settings) {
        return this.getFormatMode(settings).ordinal();
    }

    public void setFormatMode(Settings settings, SignednessFormatMode mode) {
        if (mode == null) {
            settings.clearSetting(SIGN_FORMAT);
            return;
        }
        settings.setLong(SIGN_FORMAT, mode.ordinal());
    }

    @Override
    public void setChoice(Settings settings, int value) {
        try {
            SignednessFormatMode mode = SignednessFormatMode.parse((int)value);
            settings.setLong(SIGN_FORMAT, mode.ordinal());
        }
        catch (IllegalArgumentException iae) {
            settings.clearSetting(SIGN_FORMAT);
        }
    }

    @Override
    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    @Override
    public String getName() {
        return "Signedness Mode";
    }

    @Override
    public String getDescription() {
        return "Selects the display mode for signed values";
    }

    @Override
    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    @Override
    public void clear(Settings settings) {
        settings.clearSetting(SIGN_FORMAT);
    }

    @Override
    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(SIGN_FORMAT);
        if (l == null) {
            destSettings.clearSetting(SIGN_FORMAT);
        } else {
            destSettings.setLong(SIGN_FORMAT, l);
        }
    }

    @Override
    public boolean hasValue(Settings setting) {
        return setting.getValue(SIGN_FORMAT) != null;
    }

    public String getDisplayChoice(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setDisplayChoice(Settings settings, String choice) {
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(choice)) continue;
            this.setChoice(settings, i);
            break;
        }
    }
}

