/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4DirEntry
implements StructConverter {
    private int inode;
    private short rec_len;
    private short name_len;
    private String name;
    private byte[] extra;

    public Ext4DirEntry(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4DirEntry(BinaryReader reader) throws IOException {
        this.inode = reader.readNextInt();
        this.rec_len = reader.readNextShort();
        this.name_len = reader.readNextShort();
        this.name = reader.readNextAsciiString((int)this.name_len);
        int extraSize = this.rec_len - (8 + this.name_len);
        if (extraSize > 0) {
            this.extra = reader.readNextByteArray(extraSize);
        }
    }

    public int getInode() {
        return this.inode;
    }

    public short getRec_len() {
        return this.rec_len;
    }

    public short getName_len() {
        return this.name_len;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_dir_entry", 0);
        structure.add(DWORD, "inode", null);
        structure.add(WORD, "rec_len", null);
        structure.add(WORD, "name_len", null);
        structure.add(STRING, (int)this.name_len, "name", null);
        if (this.extra != null) {
            structure.add((DataType)new ArrayDataType(BYTE, this.extra.length, BYTE.getLength()), "extra", null);
        }
        return structure;
    }
}

