/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh.vector;

import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class WeightFactory {
    private double[] idfweight = new double[512];
    private double[] tfweight = new double[64];
    private double weightnorm;
    private double probflip0;
    private double probflip1;
    private double probdiff0;
    private double probdiff1;
    private double scale;
    private double addend;
    private double probflip0_norm;
    private double probflip1_norm;
    private double probdiff0_norm;
    private double probdiff1_norm;

    private void updateNorms() {
        this.probflip0_norm = this.probflip0 * this.scale;
        this.probflip1_norm = this.probflip1 * this.scale;
        this.probdiff0_norm = this.probdiff0 * this.scale;
        this.probdiff1_norm = this.probdiff1 * this.scale;
    }

    public final int getIDFSize() {
        return this.idfweight.length;
    }

    public final int getTFSize() {
        return this.tfweight.length;
    }

    public final int getSize() {
        return this.idfweight.length + this.tfweight.length + 7;
    }

    public final double getIDFWeight(short val) {
        return this.idfweight[val];
    }

    public final double getTFWeight(short val) {
        return this.tfweight[val];
    }

    public final double getCoeff(short i, short t) {
        return this.idfweight[i] * this.tfweight[t];
    }

    public final double getWeightNorm() {
        return this.weightnorm;
    }

    public final double getFlipNorm0() {
        return this.probflip0_norm;
    }

    public final double getDiffNorm0() {
        return this.probdiff0_norm;
    }

    public final double getFlipNorm1() {
        return this.probflip1_norm;
    }

    public final double getDiffNorm1() {
        return this.probdiff1_norm;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double getAddend() {
        return this.addend;
    }

    public void setLogarithmicTFWeights() {
        double log2 = Math.log(2.0);
        for (int i = 0; i < this.tfweight.length; ++i) {
            this.tfweight[i] = Math.sqrt(1.0 + Math.log(i + 1) / log2);
        }
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<weightfactory scale=\"");
        fwrite.append(Double.toString(this.scale));
        fwrite.append("\" addend=\"");
        fwrite.append(Double.toString(this.addend));
        fwrite.append("\">\n");
        double scale_sqrt = Math.sqrt(this.scale);
        for (double element : this.idfweight) {
            fwrite.append(" <idf>");
            fwrite.append(Double.toString(element / scale_sqrt));
            fwrite.append("</idf>\n");
        }
        for (double element : this.tfweight) {
            fwrite.append(" <tf>");
            fwrite.append(Double.toString(element));
            fwrite.append("</tf>\n");
        }
        fwrite.append(" <weightnorm>").append(Double.toString(this.weightnorm * this.scale)).append("</weightnorm>\n");
        fwrite.append(" <probflip0>").append(Double.toString(this.probflip0)).append("</probflip0>\n");
        fwrite.append(" <probflip1>").append(Double.toString(this.probflip1)).append("</probflip1>\n");
        fwrite.append(" <probdiff0>").append(Double.toString(this.probdiff0)).append("</probdiff0>\n");
        fwrite.append(" <probdiff1>").append(Double.toString(this.probdiff1)).append("</probdiff1>\n");
        fwrite.append("<weightfactory>\n");
    }

    public double[] toArray() {
        int i;
        int numrows = this.getSize();
        double[] res = new double[numrows];
        double scaleSqrt = Math.sqrt(this.scale);
        for (i = 0; i < this.idfweight.length; ++i) {
            res[i] = this.idfweight[i] / scaleSqrt;
        }
        for (i = 0; i < this.tfweight.length; ++i) {
            res[i + this.idfweight.length] = this.tfweight[i];
        }
        res[numrows - 7] = this.weightnorm * this.scale;
        res[numrows - 6] = this.probflip0;
        res[numrows - 5] = this.probflip1;
        res[numrows - 4] = this.probdiff0;
        res[numrows - 3] = this.probdiff1;
        res[numrows - 2] = this.scale;
        res[numrows - 1] = this.addend;
        return res;
    }

    public void set(double[] weightArray) {
        int i;
        int numrows = weightArray.length;
        if (numrows != this.getSize()) {
            throw new NumberFormatException("Not enough values in double array");
        }
        this.scale = weightArray[numrows - 2];
        this.addend = weightArray[numrows - 1];
        this.weightnorm = weightArray[numrows - 7] / this.scale;
        this.probflip0 = weightArray[numrows - 6];
        this.probflip1 = weightArray[numrows - 5];
        this.probdiff0 = weightArray[numrows - 4];
        this.probdiff1 = weightArray[numrows - 3];
        double sqrtScale = Math.sqrt(this.scale);
        for (i = 0; i < this.idfweight.length; ++i) {
            this.idfweight[i] = weightArray[i] * sqrtScale;
        }
        for (i = 0; i < this.tfweight.length; ++i) {
            this.tfweight[i] = weightArray[i + this.idfweight.length];
        }
        this.updateNorms();
    }

    public void restoreXml(XmlPullParser parser) {
        double val;
        int i;
        XmlElement el = parser.start(new String[]{"weightfactory"});
        this.scale = Double.parseDouble(el.getAttribute("scale"));
        this.addend = Double.parseDouble(el.getAttribute("addend"));
        double scale_sqrt = Math.sqrt(this.scale);
        for (i = 0; i < this.idfweight.length; ++i) {
            parser.start(new String[]{"idf"});
            val = Double.parseDouble(parser.end().getText());
            this.idfweight[i] = val * scale_sqrt;
        }
        for (i = 0; i < this.tfweight.length; ++i) {
            parser.start(new String[]{"tf"});
            this.tfweight[i] = val = Double.parseDouble(parser.end().getText());
        }
        parser.start(new String[]{"weightnorm"});
        this.weightnorm = Double.parseDouble(parser.end().getText());
        this.weightnorm /= this.scale;
        parser.start(new String[]{"probflip0"});
        this.probflip0 = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"probflip1"});
        this.probflip1 = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"probdiff0"});
        this.probdiff0 = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"probdiff1"});
        this.probdiff1 = Double.parseDouble(parser.end().getText());
        parser.end(el);
        this.updateNorms();
    }
}

