/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.util.Msg;
import ghidra.util.exception.AssertException;

public class MessageLog {
    public static final int MAX_COUNT = 500;
    private StringBuffer buffer = new StringBuffer();
    private int maxSize;
    private int count;
    private int pos = -1;
    private String statusMsg;

    public MessageLog() {
        this(500);
    }

    public MessageLog(int maxSize) {
        this.maxSize = maxSize;
        this.clearStatus();
    }

    public void copyFrom(MessageLog log) {
        this.buffer = new StringBuffer(log.buffer);
        this.maxSize = log.maxSize;
        this.count = log.count;
        this.pos = log.pos;
    }

    public void appendMsg(String msg) {
        this.msg(msg);
    }

    public void appendMsg(String originator, String msg) {
        if (originator == null) {
            this.msg(msg);
        } else {
            this.msg(originator + "> " + msg);
        }
    }

    public void appendMsg(int lineNum, String msg) {
        this.msg("Line #" + lineNum + " - " + msg);
    }

    public void appendException(Throwable t) {
        if (t instanceof NullPointerException || t instanceof AssertException) {
            Msg.error((Object)this, (Object)"Exception appended to MessageLog", (Throwable)t);
        } else {
            Msg.debug((Object)this, (Object)"Exception appended to MessageLog", (Throwable)t);
        }
        String msg = t.toString();
        this.msg(msg);
    }

    public int getMsgCount() {
        return this.count;
    }

    public void clear() {
        this.buffer = new StringBuffer();
        this.count = 0;
        this.pos = -1;
    }

    public void setStatus(String status) {
        this.statusMsg = status;
    }

    public void clearStatus() {
        this.statusMsg = "";
    }

    public String getStatus() {
        return this.statusMsg;
    }

    public String toString() {
        if (this.count > this.maxSize) {
            if (this.pos > -1) {
                this.buffer.delete(this.pos, this.buffer.length());
            }
            this.pos = this.buffer.length();
            this.buffer.append("\n \n");
            this.buffer.append("There were too many messages to display.\n");
            this.buffer.append(this.count - this.maxSize + " messages have been truncated.");
            this.buffer.append("\n \n");
        }
        return this.buffer.toString();
    }

    private void msg(String msg) {
        if (msg == null || msg.length() == 0) {
            return;
        }
        if (this.count++ < this.maxSize) {
            this.buffer.append(msg);
            this.buffer.append("\n");
        }
    }

    public void error(String originator, String message) {
        this.appendMsg(originator, message);
    }
}

