/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.LongObjectHashtable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class SoftCacheLongKeyMap {
    private int cacheSize;
    private ReferenceQueue<Object> refQueue;
    private Entry head;
    private LongObjectHashtable<Object> map;

    public SoftCacheLongKeyMap(int cacheSize) {
        this.cacheSize = Math.max(cacheSize, 10);
        this.map = new LongObjectHashtable();
        this.head.nextEntry = this.head = new Entry(0L, null);
        this.head.prevEntry = this.head;
        this.refQueue = new ReferenceQueue();
    }

    public Object put(long key, Object value) {
        this.processQueue();
        if (this.map.size() == this.cacheSize) {
            this.remove(this.head.nextEntry.key);
        }
        Object obj = this.map.remove(key);
        Entry entry = new Entry(key, value);
        this.head.addBefore(entry);
        this.map.put(key, entry);
        return obj;
    }

    public Object get(long key) {
        this.processQueue();
        Entry entry = (Entry)this.map.get(key);
        if (entry != null) {
            entry.delete();
            this.head.addBefore(entry);
            return entry.get();
        }
        return null;
    }

    public int size() {
        this.processQueue();
        return this.map.size();
    }

    public void clear() {
        this.map.removeAll();
        this.refQueue = new ReferenceQueue();
    }

    public boolean isEmpty() {
        this.processQueue();
        return this.map.size() == 0;
    }

    public boolean containsKey(long key) {
        this.processQueue();
        return this.map.contains(key);
    }

    public Object remove(long key) {
        Entry entry = (Entry)this.map.remove(key);
        if (entry != null) {
            entry.delete();
            return entry.get();
        }
        return null;
    }

    public long[] getKeys() {
        this.processQueue();
        return this.map.getKeys();
    }

    private void processQueue() {
        Entry entry;
        while ((entry = (Entry)this.refQueue.poll()) != null) {
            this.remove(entry.key);
        }
    }

    class Entry
    extends SoftReference<Object> {
        long key;
        Entry nextEntry;
        Entry prevEntry;

        Entry(long key, Object value) {
            super(value, SoftCacheLongKeyMap.this.refQueue);
            this.key = key;
        }

        void addBefore(Entry entry) {
            entry.nextEntry = this;
            entry.prevEntry = this.prevEntry;
            this.prevEntry.nextEntry = entry;
            this.prevEntry = entry;
        }

        void delete() {
            this.prevEntry.nextEntry = this.nextEntry;
            this.nextEntry.prevEntry = this.prevEntry;
        }
    }
}

