/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.Project;
import ghidra.util.exception.AssertException;

public class AppInfo {
    private static FrontEndTool tool;
    private static Project activeProject;

    static void setFrontEndTool(FrontEndTool t) {
        tool = t;
    }

    static void setActiveProject(Project p) {
        activeProject = p;
    }

    public static FrontEndTool getFrontEndTool() {
        AppInfo.assertFrontEndRunning();
        return tool;
    }

    public static Project getActiveProject() {
        return activeProject;
    }

    public static void exitGhidra() {
        AppInfo.assertFrontEndRunning();
        tool.exit();
    }

    private static void assertFrontEndRunning() {
        if (tool == null) {
            throw new AssertException("Cannot use " + AppInfo.class.getSimpleName() + " without a Front End running");
        }
    }
}

