/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.io.ReadableRandomAccessSubstream;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccess;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccessStream;
import org.catacombae.hfsexplorer.types.resff.ReferenceListEntry;
import org.catacombae.hfsexplorer.types.resff.ResourceHeader;
import org.catacombae.hfsexplorer.types.resff.ResourceMap;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;

public class ResourceForkReader {
    private final SynchronizedReadableRandomAccessStream trueForkStream;
    private final SynchronizedReadableRandomAccess forkStream;

    public ResourceForkReader(ReadableRandomAccessStream forkStream) {
        this.trueForkStream = new SynchronizedReadableRandomAccessStream(forkStream);
        this.forkStream = this.trueForkStream;
    }

    public void close() {
        this.trueForkStream.close();
    }

    public ResourceHeader getHeader() {
        byte[] headerData = new byte[ResourceHeader.length()];
        this.forkStream.readFullyFrom(0L, headerData);
        return new ResourceHeader(headerData, 0);
    }

    public ResourceMap getResourceMap() {
        ResourceHeader header = this.getHeader();
        return new ResourceMap(this.forkStream, Util.unsign((int)header.getMapOffset()));
    }

    public long getDataLength(ReferenceListEntry entry) {
        long dataPos = this.getDataPos(entry);
        return this.getDataLength(dataPos);
    }

    private long getDataPos(ReferenceListEntry entry) {
        ResourceHeader header = this.getHeader();
        return Util.unsign((int)header.getDataOffset()) + (long)entry.getResourceDataOffset();
    }

    private long getDataLength(long dataPos) {
        byte[] dataLengthBytes = new byte[4];
        this.forkStream.readFrom(dataPos, dataLengthBytes);
        return Util.unsign((int)Util.readIntBE((byte[])dataLengthBytes));
    }

    public ReadableRandomAccessStream getResourceStream(ReferenceListEntry entry) {
        long dataPos = this.getDataPos(entry);
        long dataLength = this.getDataLength(dataPos);
        return new ReadableConcatenatedStream((ReadableRandomAccessStream)new ReadableRandomAccessSubstream(this.forkStream), dataPos + 4L, dataLength);
    }
}

