/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.demangler.DemangledAddressTable;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledFunctionType;
import ghidra.app.util.demangler.DemangledMethod;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledString;
import ghidra.app.util.demangler.DemangledTemplate;
import ghidra.app.util.demangler.DemangledThunk;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.DemanglerParser;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.app.util.demangler.gnu.GnuDemanglerNativeProcess;
import ghidra.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GnuDemanglerParser
implements DemanglerParser {
    private static final String CONSTRUCTION_VTABLE_FOR = "construction vtable for ";
    private static final String VTT_FOR = "VTT for ";
    private static final String VTABLE_FOR = "vtable for ";
    private static final String TYPEINFO_NAME_FOR = "typeinfo name for ";
    private static final String TYPEINFO_FN_FOR = "typeinfo fn for ";
    private static final String TYPEINFO_FOR = "typeinfo for ";
    private static final String REFERENCE_TEMPORARY_FOR = "reference temporary for ";
    private static final String GUARD_VARIABLE_FOR = "guard variable for ";
    private static final String COVARIANT_RETURN_THUNK = "covariant return thunk";
    private static final String VIRTUAL_THUNK = "virtual thunk";
    private static final String NONVIRTUAL_THUNK = "non-virtual thunk";
    private static final String NAMESPACE_DELIMITER = "::";
    private static final Pattern CONST_FUNCTION_PATTERN = Pattern.compile("const\\((.*)\\)");
    private static final Pattern UNNECESSARY_PARENS_PATTERN = Pattern.compile("\\s*\\((.*)\\)\\s*");
    private static final Pattern ARRAY_POINTER_REFERENCE_PATTERN = Pattern.compile("([\\w:]+)\\*?\\s(.*)\\(([&*])\\)\\s*((?:\\[.*?\\])+)");
    private static final Pattern ARRAY_POINTER_REFERENCE_PIECE_PATTERN = Pattern.compile("\\(([&*])\\)\\s*\\[.*?\\]");
    private static final Pattern CAST_PATTERN = Pattern.compile("\\((?:\\w+\\s)*\\w+(?:::\\w+)*\\)\\s*-*\\w+");
    private static final Pattern CONVERSION_OPERATOR_PATTERN = Pattern.compile("(.*operator) (.*)\\(\\).*");
    private static final Pattern NEW_DELETE_OPERATOR_PATTERN = Pattern.compile("(.*operator) (new|delete)(\\[\\])?\\((.*)\\).*");
    private static final Pattern ENDS_WITH_DIGITS_PATTERN = Pattern.compile("(.*?)\\d+");
    private static final String VAR_ARGS = "...";
    private static final String CONST_KEYWORD = " const";
    private static final String ANONYMOUS_NAMESPACE = "\\(anonymous namespace\\)";
    private static final String ANONYMOUS_NAMESPACE_FIXUP = "anonymous_namespace";
    private GnuDemanglerNativeProcess process;

    public GnuDemanglerParser(GnuDemanglerNativeProcess process) {
        this.process = process;
    }

    public DemangledObject parse(String mangled, String demangled) {
        try {
            return this.doParse(mangled, demangled);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected problem parsing " + demangled + " from mangled string: " + mangled, e);
        }
    }

    public DemangledObject doParse(String mangled, String demangled) throws IOException {
        char ch;
        int sqBracketStartPos;
        int pos;
        if (demangled.trim().equals("c")) {
            return null;
        }
        demangled = demangled.replaceAll(ANONYMOUS_NAMESPACE, ANONYMOUS_NAMESPACE_FIXUP);
        if (mangled != null && mangled.startsWith("_ZZ")) {
            return this.parseGuardVariableOrReferenceTemporary(demangled, "");
        }
        if (demangled.startsWith(GUARD_VARIABLE_FOR)) {
            return this.parseGuardVariableOrReferenceTemporary(demangled, GUARD_VARIABLE_FOR);
        }
        if (demangled.startsWith(REFERENCE_TEMPORARY_FOR)) {
            return this.parseGuardVariableOrReferenceTemporary(demangled, REFERENCE_TEMPORARY_FOR);
        }
        if (demangled.startsWith(TYPEINFO_NAME_FOR)) {
            return this.parseTypeInfoName(demangled);
        }
        if (demangled.startsWith(TYPEINFO_FOR)) {
            return this.parseAddressTable(demangled, TYPEINFO_FOR);
        }
        if (demangled.startsWith(TYPEINFO_FN_FOR)) {
            return this.parseAddressTable(demangled, TYPEINFO_FN_FOR);
        }
        if (demangled.startsWith(VTABLE_FOR)) {
            return this.parseAddressTable(demangled, VTABLE_FOR);
        }
        if (demangled.startsWith(VTT_FOR)) {
            return this.parseAddressTable(demangled, VTT_FOR);
        }
        if (demangled.startsWith(CONSTRUCTION_VTABLE_FOR)) {
            Matcher matcher = ENDS_WITH_DIGITS_PATTERN.matcher(demangled);
            if (!matcher.matches()) {
                return this.parseAddressTable(demangled, CONSTRUCTION_VTABLE_FOR);
            }
            String textWithoutTrailingDigits = matcher.group(1);
            return this.parseAddressTable(textWithoutTrailingDigits, CONSTRUCTION_VTABLE_FOR);
        }
        if (demangled.startsWith(NONVIRTUAL_THUNK) || demangled.startsWith(VIRTUAL_THUNK) || demangled.startsWith(COVARIANT_RETURN_THUNK)) {
            String referencedDemangledName;
            String referencedMangledName;
            int index = mangled.indexOf(95, 1);
            if (index < 0) {
                return null;
            }
            if (demangled.startsWith(VIRTUAL_THUNK) || demangled.startsWith(COVARIANT_RETURN_THUNK)) {
                ++index;
                if ((index = mangled.indexOf(95, index)) < 0) {
                    return null;
                }
            }
            if ((referencedMangledName = "_Z" + mangled.substring(index + 1)).equals(referencedDemangledName = this.process.demangle(referencedMangledName)) || referencedDemangledName.length() == 0) {
                return null;
            }
            DemangledObject refObj = this.parse(referencedMangledName, referencedDemangledName);
            if (!(refObj instanceof DemangledFunction)) {
                return null;
            }
            refObj.setOriginalMangled(referencedMangledName);
            refObj.setSignature(referencedDemangledName);
            ((DemangledFunction)refObj).setCallingConvention("__thiscall");
            DemangledThunk thunkObj = new DemangledThunk((DemangledFunction)refObj);
            if (demangled.startsWith(COVARIANT_RETURN_THUNK)) {
                thunkObj.setCovariantReturnThunk();
            }
            if ((index = demangled.indexOf(" to ")) > 0) {
                thunkObj.setSignaturePrefix(demangled.substring(0, index + 4));
            }
            return thunkObj;
        }
        DemangledObject conversionOperator = this.parseConversionOperator(demangled);
        if (conversionOperator != null) {
            return conversionOperator;
        }
        DemangledObject newDeleteOperator = this.parseNewOrDeleteOperator(demangled);
        if (newDeleteOperator != null) {
            return newDeleteOperator;
        }
        ParameterLocator paramLocator = new ParameterLocator(demangled);
        if (!paramLocator.hasParameters()) {
            return this.parseVariable(demangled);
        }
        int paramStart = paramLocator.getParamStart();
        int paramEnd = paramLocator.getParamEnd();
        if (paramStart + 1 == demangled.indexOf(41) && (pos = paramStart - "operator".length()) >= 0 && demangled.indexOf("operator") == pos) {
            paramStart = demangled.indexOf(40, paramStart + 1);
            paramEnd = demangled.lastIndexOf(41);
        }
        String parameterString = demangled.substring(paramStart + 1, paramEnd).trim();
        List<DemangledDataType> parameters = this.parseParameters(parameterString);
        int prefixEndPos = paramStart;
        String chargeType = null;
        if (demangled.charAt(paramStart - 1) == ']' && (sqBracketStartPos = this.backIndexOf(demangled, paramStart - 1, '[')) != prefixEndPos - 2) {
            chargeType = demangled.substring(sqBracketStartPos, paramStart);
            prefixEndPos = sqBracketStartPos;
        }
        String prefix = demangled.substring(0, prefixEndPos).trim();
        int nameStartPos = this.backIndexOf(prefix = this.fixupTemplateSeparators(prefix), prefix.length() - 1, ' ');
        if (nameStartPos == -1) {
            throw new RuntimeException();
        }
        Object name = prefix.substring(nameStartPos, prefix.length());
        if (chargeType != null) {
            name = (String)name + chargeType;
        }
        DemangledMethod method = new DemangledMethod((String)null);
        method.setReturnType(new DemangledDataType("undefined"));
        for (DemangledDataType parameter : parameters) {
            method.addParameter(parameter);
        }
        this.setNameAndNamespace((DemangledObject)method, (String)name);
        if (method.getName().startsWith("operator") && !Character.isLetterOrDigit(ch = method.getName().charAt("operator".length()))) {
            method.setOverloadedOperator(true);
        }
        if (nameStartPos > 0) {
            String returnType = prefix.substring(0, nameStartPos);
            method.setReturnType(this.parseDataType(returnType));
        }
        return method;
    }

    private DemangledObject parseTypeInfoName(String demangled) {
        String classname = demangled.substring(TYPEINFO_NAME_FOR.length()).trim();
        DemangledString demangledString = new DemangledString("typeinfo_name", classname, -1, false);
        demangledString.setSpecialPrefix("typeinfo name");
        demangledString.setUtilDemangled(demangled);
        this.setNamespace((DemangledObject)demangledString, classname);
        return demangledString;
    }

    private DemangledObject parseConversionOperator(String demangled) {
        Matcher matcher = CONVERSION_OPERATOR_PATTERN.matcher(demangled);
        if (!matcher.matches()) {
            return null;
        }
        String fullName = matcher.group(1);
        String fullReturnType = matcher.group(2);
        boolean isConst = false;
        int index = fullReturnType.indexOf(CONST_KEYWORD);
        if (index != -1) {
            fullReturnType = fullReturnType.replace(CONST_KEYWORD, "");
            isConst = true;
        }
        DemangledMethod method = new DemangledMethod((String)null);
        DemangledDataType returnType = this.createDataType(fullReturnType);
        if (isConst) {
            returnType.setConst();
        }
        method.setReturnType(returnType);
        String templatelessName = this.stripOffTemplates(fullName);
        this.setNameAndNamespace((DemangledObject)method, templatelessName);
        String templatelessReturnType = this.stripOffTemplates(fullReturnType);
        List names = NamespaceUtils.splitNamespacePath((String)templatelessReturnType);
        String shortReturnTypeName = (String)names.get(names.size() - 1);
        method.setName("operator.cast.to." + shortReturnTypeName);
        method.setSignature(fullName + " " + fullReturnType);
        method.setOverloadedOperator(true);
        return method;
    }

    private DemangledObject parseNewOrDeleteOperator(String demangled) {
        Matcher matcher = NEW_DELETE_OPERATOR_PATTERN.matcher(demangled);
        if (!matcher.matches()) {
            return null;
        }
        String operatorText = matcher.group(1);
        String operatorName = matcher.group(2);
        String arrayBrackets = matcher.group(3);
        String parametersText = matcher.group(4);
        DemangledMethod method = new DemangledMethod((String)null);
        DemangledDataType returnType = new DemangledDataType("void");
        if (operatorName.startsWith("new")) {
            returnType.incrementPointerLevels();
        }
        method.setReturnType(returnType);
        this.setNameAndNamespace((DemangledObject)method, operatorText);
        List<DemangledDataType> parameters = this.parseParameters(parametersText);
        for (DemangledDataType parameter : parameters) {
            method.addParameter(parameter);
        }
        Object name = operatorName;
        if (arrayBrackets != null) {
            name = (String)name + "[]";
        }
        method.setName("operator." + (String)name);
        method.setSignature(operatorText + " " + operatorName);
        method.setOverloadedOperator(true);
        return method;
    }

    private DemangledDataType createDataType(String fullReturnType) {
        DemangledDataType parsedDataType = this.parseDataType(fullReturnType);
        return parsedDataType;
    }

    private String stripOffTemplates(String string) {
        int templateStart = string.indexOf("<");
        if (templateStart == -1) {
            return string;
        }
        int templateEnd = string.lastIndexOf(">");
        if (templateEnd == -1) {
            return string;
        }
        return string.substring(0, templateStart);
    }

    private DemangledObject parseGuardVariableOrReferenceTemporary(String demangled, String prefix) {
        String str = demangled.substring(prefix.length()).trim();
        int pos = str.lastIndexOf(NAMESPACE_DELIMITER);
        if (pos == -1) {
            throw new RuntimeException();
        }
        if (str.endsWith(")")) {
            throw new RuntimeException();
        }
        DemangledObject dobj = this.parse(null, str.substring(0, pos));
        if (dobj == null) {
            return null;
        }
        if (str.endsWith(CONST_KEYWORD)) {
            str = str.substring(0, str.length() - CONST_KEYWORD.length());
            dobj.setConst(true);
        }
        String name = str.substring(pos + 2);
        name = name.replaceAll(" ", "_");
        return this.dobjToNamespace(dobj, name);
    }

    private DemangledObject dobjToNamespace(DemangledObject parent, String name) {
        DemangledType namespace = null;
        if (parent instanceof DemangledFunction) {
            DemangledFunction dfun = (DemangledFunction)parent;
            namespace = new DemangledFunctionType(dfun.getName() + dfun.getParameterString(), dfun.getSignature(false));
        } else {
            namespace = new DemangledType(parent.getName());
        }
        namespace.setNamespace(parent.getNamespace());
        DemangledVariable variable = new DemangledVariable(name);
        variable.setNamespace(namespace);
        return variable;
    }

    private String fixupTemplateSeparators(String name) {
        StringBuffer buffer = new StringBuffer();
        int templateLevel = 0;
        char last = '\u0000';
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '<') {
                ++templateLevel;
            } else if (ch == '>' && templateLevel != 0) {
                --templateLevel;
            }
            if (templateLevel > 0 && ch == ' ') {
                char next;
                char c = next = i + 1 < name.length() ? name.charAt(i + 1) : (char)'\u0000';
                if (this.isSurroundedByCharacters(last, next)) {
                    buffer.append('_');
                }
            } else if (templateLevel > 0 && ch == ':') {
                buffer.append('-');
            } else {
                buffer.append(ch);
            }
            last = ch;
        }
        return buffer.toString().trim();
    }

    private boolean isSurroundedByCharacters(char last, char next) {
        if (last == '\u0000' || next == '\u0000') {
            return false;
        }
        return Character.isLetterOrDigit(last) && Character.isLetterOrDigit(next);
    }

    private int backIndexOf(String string, int index, char ch) {
        while (index >= 0) {
            if (string.charAt(index) == ch) {
                return index;
            }
            --index;
        }
        return 0;
    }

    private List<DemangledDataType> parseParameters(String parameterString) {
        List<String> parameterStrings = this.tokenizeParameters(parameterString);
        List<DemangledDataType> parameters = this.convertIntoParameters(parameterStrings);
        return parameters;
    }

    private List<String> tokenizeParameters(String parameterString) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (parameterString.length() == 0) {
            return parameters;
        }
        Matcher matcher = CONST_FUNCTION_PATTERN.matcher(parameterString);
        if (matcher.matches()) {
            parameterString = matcher.group(1);
        } else {
            matcher = UNNECESSARY_PARENS_PATTERN.matcher(parameterString);
            if (matcher.matches()) {
                parameterString = matcher.group(1);
            }
        }
        if (parameterString.trim().length() == 0) {
            return parameters;
        }
        int templateLevel = 0;
        boolean functionPointerLevel = false;
        int startIndex = 0;
        for (int i = 0; i < parameterString.length(); ++i) {
            int end;
            int start;
            char ch = parameterString.charAt(i);
            if (ch == ',' && templateLevel == 0 && !functionPointerLevel) {
                String ps = parameterString.substring(startIndex, i);
                parameters.add(ps.trim());
                startIndex = i + 1;
                continue;
            }
            if (ch == '<') {
                ++templateLevel;
                continue;
            }
            if (ch == '>') {
                --templateLevel;
                continue;
            }
            if (ch != '(') continue;
            matcher = ARRAY_POINTER_REFERENCE_PIECE_PATTERN.matcher(parameterString.substring(i));
            if (matcher.find() && (start = matcher.start()) == 0) {
                end = matcher.end() - 1;
                i += end;
                continue;
            }
            matcher = CAST_PATTERN.matcher(parameterString.substring(i));
            if (matcher.find() && (start = matcher.start()) == 0) {
                end = matcher.end() - 1;
                i += end;
                continue;
            }
            i = this.getFunctionPointerCloseParen(parameterString, i);
        }
        if (startIndex < parameterString.length()) {
            String ps = parameterString.substring(startIndex, parameterString.length());
            parameters.add(ps.trim());
        }
        return parameters;
    }

    private int getFunctionPointerCloseParen(String parameterString, int currentIndex) {
        int firstCloseParen = parameterString.indexOf(41, currentIndex);
        if (firstCloseParen == -1) {
            throw new RuntimeException("Unable to find closing paren for parameter string: " + parameterString);
        }
        boolean foundNextStart = false;
        int length = parameterString.length();
        for (int i = currentIndex; i < length; ++i) {
            char ch = parameterString.charAt(i);
            if (ch == ')') {
                return i;
            }
            if (ch == '(') {
                foundNextStart = true;
                continue;
            }
            if (ch != ',' || foundNextStart) continue;
            return firstCloseParen;
        }
        return firstCloseParen;
    }

    private List<DemangledDataType> convertIntoParameters(List<String> parameterStrings) {
        ArrayList<DemangledDataType> parameters = new ArrayList<DemangledDataType>();
        for (String parameter : parameterStrings) {
            DemangledDataType ddt = this.parseDataType(parameter);
            parameters.add(ddt);
        }
        return parameters;
    }

    private DemangledDataType parseDataType(String datatype) {
        DemangledDataType ddt = new DemangledDataType((String)null);
        this.setNameAndNamespace(ddt, datatype);
        boolean finishedName = false;
        for (int i = 0; i < datatype.length(); ++i) {
            Matcher matcher;
            char ch = datatype.charAt(i);
            if (!finishedName && this.isDataTypeNameCharacter(ch)) continue;
            if (!finishedName) {
                finishedName = true;
                if (VAR_ARGS.equals(datatype)) {
                    ddt.setVarArgs();
                } else {
                    matcher = CAST_PATTERN.matcher(datatype);
                    if (matcher.matches()) {
                        String value = matcher.group(0);
                        return new DemangledDataType(value);
                    }
                    String name = datatype.substring(0, i).trim();
                    this.setNameAndNamespace(ddt, name);
                }
            }
            if (ch == '<') {
                int contentStart = i + 1;
                int templateEnd = this.getTemplateEndIndex(datatype, contentStart);
                if (templateEnd == -1 || templateEnd > datatype.length()) {
                    throw new RuntimeException("Did not find ending to template");
                }
                String templateContent = datatype.substring(contentStart, templateEnd);
                DemangledTemplate template = this.parseTemplate(templateContent);
                ddt.setTemplate(template);
                i = templateEnd;
            } else if (ch == '(') {
                matcher = ARRAY_POINTER_REFERENCE_PATTERN.matcher(datatype);
                if (matcher.matches()) {
                    String name = matcher.group(1);
                    ddt = this.parseArrayPointerOrReference(datatype, name);
                    i = matcher.end();
                } else {
                    boolean hasPointerParens;
                    int startParenCount = StringUtilities.countOccurrences((String)datatype.substring(i), (char)'(');
                    boolean bl = hasPointerParens = startParenCount == 2;
                    if (hasPointerParens) {
                        ddt = this.parseFunctionPointer(datatype);
                        int firstParenEnd = datatype.indexOf(41, i + 1);
                        int secondParenEnd = datatype.indexOf(41, firstParenEnd + 1);
                        if (secondParenEnd == -1) {
                            throw new RuntimeException("Did not find ending to closure: " + datatype);
                        }
                        i = secondParenEnd + 1;
                    } else {
                        ddt = this.parseFunction(datatype, i);
                        int firstParenEnd = datatype.indexOf(41, i + 1);
                        if (firstParenEnd == -1) {
                            throw new RuntimeException("Did not find ending to closure: " + datatype);
                        }
                        i = firstParenEnd + 1;
                    }
                }
            } else if (ch == '*') {
                ddt.incrementPointerLevels();
            } else if (ch == '&') {
                if (!ddt.isReference()) {
                    ddt.setReference();
                } else {
                    ddt.incrementPointerLevels();
                }
            } else if (ch == '[') {
                ddt.setArray(ddt.getArrayDimensions() + 1);
            }
            String substr = datatype.substring(i);
            if (substr.startsWith("const")) {
                ddt.setConst();
                i += 4;
                continue;
            }
            if (substr.startsWith("struct")) {
                ddt.setStruct();
                i += 5;
                continue;
            }
            if (substr.startsWith("class")) {
                ddt.setClass();
                i += 4;
                continue;
            }
            if (substr.startsWith("enum")) {
                ddt.setEnum();
                i += 3;
                continue;
            }
            if (ddt.getName().equals("long")) {
                if (substr.startsWith("long")) {
                    ddt.setName("long long");
                    i += 3;
                    continue;
                }
                if (!substr.startsWith("double")) continue;
                ddt.setName("long double");
                i += 5;
                continue;
            }
            if (!ddt.getName().equals("unsigned")) continue;
            ddt.setUnsigned();
            if (substr.startsWith("long")) {
                ddt.setName("long");
                i += 3;
                continue;
            }
            if (substr.startsWith("int")) {
                ddt.setName("int");
                i += 2;
                continue;
            }
            if (substr.startsWith("short")) {
                ddt.setName("short");
                i += 4;
                continue;
            }
            if (!substr.startsWith("char")) continue;
            ddt.setName("char");
            i += 3;
        }
        return ddt;
    }

    private boolean isDataTypeNameCharacter(char ch) {
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == ':' || ch == '_' || ch == '$';
    }

    private int getTemplateEndIndex(String datatype, int start) {
        char tempCh;
        int endIndex;
        int depth = 1;
        for (endIndex = start; endIndex < datatype.length() && ((tempCh = datatype.charAt(endIndex)) != '>' || --depth != 0); ++endIndex) {
            if (tempCh != '<') continue;
            ++depth;
        }
        return endIndex;
    }

    private void setNameAndNamespace(DemangledDataType ddt, String name) {
        List names = NamespaceUtils.splitNamespacePath((String)name);
        DemangledType namespace = null;
        if (names.size() > 1) {
            namespace = DemanglerUtil.convertToNamespaces(names.subList(0, names.size() - 1));
        }
        String datatypeName = (String)names.get(names.size() - 1);
        ddt.setName(datatypeName);
        ddt.setNamespace(namespace);
    }

    private void setNameAndNamespace(DemangledObject object, String name) {
        List names = NamespaceUtils.splitNamespacePath((String)name);
        DemangledType namespace = null;
        if (names.size() > 1) {
            namespace = DemanglerUtil.convertToNamespaces(names.subList(0, names.size() - 1));
        }
        String objectName = (String)names.get(names.size() - 1);
        object.setName(objectName);
        object.setNamespace(namespace);
    }

    private void setNamespace(DemangledObject object, String name) {
        List names = NamespaceUtils.splitNamespacePath((String)name);
        object.setNamespace(DemanglerUtil.convertToNamespaces((List)names));
    }

    private DemangledTemplate parseTemplate(String templateStr) {
        List<DemangledDataType> parameters = this.parseParameters(templateStr);
        DemangledTemplate template = new DemangledTemplate();
        for (DemangledDataType parameter : parameters) {
            template.addParameter(parameter);
        }
        return template;
    }

    private DemangledDataType parseArrayPointerOrReference(String datatype, String name) {
        DemangledDataType ddt = new DemangledDataType(name);
        Matcher matcher = ARRAY_POINTER_REFERENCE_PATTERN.matcher(datatype);
        matcher.find();
        String type = matcher.group(3);
        if (type.equals("*")) {
            ddt.incrementPointerLevels();
        } else if (type.equals("&")) {
            ddt.setReference();
        } else {
            throw new RuntimeException("Unexpected charater inside of parens: " + type);
        }
        String arraySubscripts = matcher.group(4);
        int n = StringUtilities.countOccurrences((String)arraySubscripts, (char)'[');
        ddt.setArray(n);
        return ddt;
    }

    private DemangledDataType parseFunctionPointer(String functionPointerString) {
        int parenStart = functionPointerString.indexOf(40);
        int parenEnd = functionPointerString.indexOf(41);
        String returnType = functionPointerString.substring(0, parenStart).trim();
        int paramStart = functionPointerString.indexOf(40, parenEnd + 1);
        int paramEnd = functionPointerString.lastIndexOf(41);
        String parameterStr = functionPointerString.substring(paramStart + 1, paramEnd);
        List<DemangledDataType> parameters = this.parseParameters(parameterStr);
        DemangledFunctionPointer dfp = new DemangledFunctionPointer();
        dfp.setReturnType(this.parseDataType(returnType));
        for (DemangledDataType parameter : parameters) {
            dfp.addParameter(parameter);
        }
        return dfp;
    }

    private DemangledDataType parseFunction(String functionString, int offset) {
        int parenStart = functionString.indexOf(40, offset);
        int parenEnd = functionString.indexOf(41, parenStart + 1);
        String returnType = functionString.substring(0, parenStart).trim();
        int paramStart = parenStart;
        int paramEnd = parenEnd;
        String parameterStr = functionString.substring(paramStart + 1, paramEnd);
        List<DemangledDataType> parameters = this.parseParameters(parameterStr);
        DemangledFunctionPointer dfp = new DemangledFunctionPointer();
        dfp.setReturnType(this.parseDataType(returnType));
        for (DemangledDataType parameter : parameters) {
            dfp.addParameter(parameter);
        }
        dfp.setDisplayFunctionPointerParens(false);
        return dfp;
    }

    private DemangledObject parseVariable(String demangled) {
        if (demangled.startsWith(TYPEINFO_NAME_FOR)) {
            return this.parseTypeInfoName(demangled);
        }
        if (demangled.startsWith(TYPEINFO_FOR)) {
            return this.parseAddressTable(demangled, TYPEINFO_FOR);
        }
        if (demangled.startsWith(TYPEINFO_FN_FOR)) {
            return this.parseAddressTable(demangled, TYPEINFO_FN_FOR);
        }
        if (demangled.startsWith(VTABLE_FOR)) {
            return this.parseAddressTable(demangled, VTABLE_FOR);
        }
        if (demangled.startsWith(VTT_FOR)) {
            return this.parseAddressTable(demangled, VTT_FOR);
        }
        if (demangled.startsWith(CONSTRUCTION_VTABLE_FOR)) {
            int pos = this.backIndexOf(demangled, demangled.length() - 1, ' ');
            String str = demangled.substring(0, pos).trim();
            return this.parseAddressTable(str, CONSTRUCTION_VTABLE_FOR);
        }
        int nameStartPos = this.backIndexOf(demangled = this.fixupTemplateSeparators(demangled).trim(), demangled.length() - 1, ' ');
        if (nameStartPos == -1) {
            throw new RuntimeException();
        }
        String name = demangled.substring(nameStartPos, demangled.length());
        DemangledVariable variable = new DemangledVariable((String)null);
        this.setNameAndNamespace((DemangledObject)variable, name);
        return variable;
    }

    private DemangledObject parseAddressTable(String demangled, String prefix) {
        int pos = prefix.trim().lastIndexOf(32);
        String name = prefix.substring(0, pos).replace(' ', '-');
        String str = prefix.length() >= demangled.length() ? demangled.trim() : demangled.substring(prefix.length()).trim();
        DemangledObject parent = this.parse(null, str);
        if (parent == null) {
            return null;
        }
        DemangledType namespace = new DemangledType(parent.getName());
        namespace.setNamespace(parent.getNamespace());
        DemangledAddressTable addressTable = new DemangledAddressTable(name, -1);
        addressTable.setNamespace(namespace);
        return addressTable;
    }

    private class ParameterLocator {
        int paramStart = -1;
        int paramEnd = -1;

        ParameterLocator(String text) {
            this.paramEnd = text.lastIndexOf(41);
            if (this.paramEnd < 0) {
                return;
            }
            if (this.isContainedWithinNamespace(text)) {
                this.paramEnd = -1;
                return;
            }
            this.paramStart = this.findParameterStart(text, this.paramEnd);
            int templateEnd = this.findInitialTemplateEndPosition(text);
            int templateStart = -1;
            if (templateEnd != -1) {
                templateStart = this.findInitialTemplateStartPosition(text, templateEnd);
            }
            if (this.paramStart > templateStart && this.paramStart < templateEnd) {
                this.paramStart = -1;
                this.paramEnd = -1;
            }
        }

        private boolean isContainedWithinNamespace(String text) {
            return this.paramEnd < text.length() - 1 && ':' == text.charAt(this.paramEnd + 1);
        }

        int getParamStart() {
            return this.paramStart;
        }

        int getParamEnd() {
            return this.paramEnd;
        }

        boolean hasParameters() {
            return this.paramStart != -1 && this.paramEnd != -1;
        }

        private int findParameterStart(String demangled, int end) {
            int templateLevel = 0;
            int functionPointerLevel = 0;
            for (int i = end - 1; i >= 0; --i) {
                char ch = demangled.charAt(i);
                if (ch == '(' && templateLevel == 0 && functionPointerLevel == 0) {
                    return i;
                }
                if (ch == '>') {
                    ++templateLevel;
                    continue;
                }
                if (ch == '<') {
                    --templateLevel;
                    continue;
                }
                if (ch == ')') {
                    ++functionPointerLevel;
                    continue;
                }
                if (ch != '(') continue;
                --functionPointerLevel;
            }
            return -1;
        }

        private int findInitialTemplateEndPosition(String string) {
            boolean seenTemplate = false;
            int templateLevel = 0;
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '<': {
                        ++templateLevel;
                        seenTemplate = true;
                        break;
                    }
                    case '>': {
                        --templateLevel;
                    }
                }
                if (!seenTemplate || templateLevel != 0) continue;
                return i;
            }
            return -1;
        }

        private int findInitialTemplateStartPosition(String string, int templateEnd) {
            int templateLevel = 1;
            char[] chars = string.toCharArray();
            for (int i = templateEnd - 1; i >= 0; --i) {
                switch (chars[i]) {
                    case '<': {
                        --templateLevel;
                        break;
                    }
                    case '>': {
                        ++templateLevel;
                    }
                }
                if (templateLevel != 0) continue;
                return i;
            }
            return -1;
        }
    }
}

