/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.util.Msg;
import ghidra.util.exception.NoValueException;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class SizeAlignmentPanel
extends JPanel {
    GhidraTable table;
    DataOrganizationImpl dataOrganization;

    public SizeAlignmentPanel() {
        super(new BorderLayout());
        SizeAlignmentTableModel tableModel = new SizeAlignmentTableModel();
        this.table = new GhidraTable(tableModel);
        this.table.setAutoEditEnabled(true);
        JScrollPane sp = new JScrollPane((Component)((Object)this.table));
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 80));
        this.add((Component)sp, "Center");
    }

    public void setOrganization(DataOrganizationImpl dataOrganization) {
        this.dataOrganization = dataOrganization;
        ((SizeAlignmentTableModel)this.table.getModel()).fireTableDataChanged();
    }

    public void setStatusMessage(String message) {
        Msg.showError((Object)this, (Component)this, (String)"Invalid Input", (Object)message);
    }

    class SizeAlignmentTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Size", "Alignment"};
        private final int SIZE_COLUMN = 0;
        private final int ALIGNMENT_COLUMN = 1;

        SizeAlignmentTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Integer.class;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public int getRowCount() {
            return SizeAlignmentPanel.this.dataOrganization.getSizeAlignmentCount() + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int[] sizes = SizeAlignmentPanel.this.dataOrganization.getSizes();
            if (rowIndex < sizes.length) {
                int size = sizes[rowIndex];
                if (columnIndex == 0) {
                    return size;
                }
                if (columnIndex == 1) {
                    try {
                        return SizeAlignmentPanel.this.dataOrganization.getSizeAlignment(size);
                    }
                    catch (NoValueException e) {
                        return null;
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (rowIndex == SizeAlignmentPanel.this.dataOrganization.getSizeAlignmentCount()) {
                return columnIndex == 0;
            }
            return columnIndex == 1;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                return;
            }
            int[] sizes = SizeAlignmentPanel.this.dataOrganization.getSizes();
            if (rowIndex < sizes.length) {
                int alignment = (Integer)value;
                int size2 = sizes[rowIndex];
                SizeAlignmentPanel.this.dataOrganization.setSizeAlignment(size2, alignment);
            }
            if (rowIndex == sizes.length) {
                int size = (Integer)value;
                try {
                    SizeAlignmentPanel.this.dataOrganization.getSizeAlignment(size);
                    SizeAlignmentPanel.this.setStatusMessage("An alignment is already defined for a size of " + size + ".");
                    return;
                }
                catch (NoValueException size2) {
                    int alignment = size;
                    SizeAlignmentPanel.this.dataOrganization.setSizeAlignment(size, alignment);
                    this.fireTableDataChanged();
                }
            }
        }
    }
}

