/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableFieldLayout
extends CliAbstractTable {
    public CliTableFieldLayout(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliFieldLayoutRow(reader.readNextInt(), this.readTableIndex(reader, CliTypeTable.Field)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "FieldLayout Row", 0);
        rowDt.add(DWORD, "Offset", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Field), "Field", null);
        return rowDt;
    }

    public class CliFieldLayoutRow
    extends CliAbstractTableRow {
        public int offset;
        public int fieldIndex;

        public CliFieldLayoutRow(int offset, int fieldIndex) {
            this.offset = offset;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("Field %s Offset %d", CliTableFieldLayout.this.getRowRepresentationSafe(CliTypeTable.Field, this.fieldIndex), this.offset);
        }
    }
}

