/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.main;

import java.text.DecimalFormat;
import java.text.Format;

public class VTScore
implements Comparable<VTScore> {
    private static final ThreadLocal<Format> SCORE_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("0.000"));
    private double score;

    public VTScore(double score) {
        this.score = this.round(score);
    }

    private double round(double value) {
        return Double.parseDouble(SCORE_FORMAT.get().format(value));
    }

    public VTScore(String scoreAsString) {
        this.score = this.parseScore(scoreAsString);
    }

    private double parseScore(String scoreAsString) {
        return Double.parseDouble(scoreAsString);
    }

    public double getScore() {
        return this.score;
    }

    public double getLog10Score() {
        return Math.log10(this.score);
    }

    public String getFormattedScore() {
        return SCORE_FORMAT.get().format(this.score);
    }

    public String getFormattedLog10Score() {
        double log10Score = this.getLog10Score();
        if (Double.isNaN(log10Score)) {
            return "0.00";
        }
        if (Double.isInfinite(log10Score)) {
            return "N/A";
        }
        return SCORE_FORMAT.get().format(log10Score);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.score);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VTScore other = (VTScore)obj;
        return this.score == other.score;
    }

    public String toStorageString() {
        return Double.toString(this.score);
    }

    @Override
    public int compareTo(VTScore o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getFormattedScore();
    }
}

