set(Qt6_DEPENDENCIES_FOUND FALSE)

# note: _third_party_deps example: "ICU\\;FALSE\\;1.0\\;i18n uc data;ZLIB\\;FALSE\\;\\;"
set(__qt_third_party_deps "Threads\;FALSE\;\;\;")

if(NOT QT_NO_THREADS_PREFER_PTHREAD_FLAG)
    set(THREADS_PREFER_PTHREAD_FLAG TRUE)
endif()

foreach(__qt_target_dep ${__qt_third_party_deps})
    list(GET __qt_target_dep 0 __qt_pkg)
    list(GET __qt_target_dep 1 __qt_is_optional)
    list(GET __qt_target_dep 2 __qt_version)
    list(GET __qt_target_dep 3 __qt_components)
    list(GET __qt_target_dep 4 __qt_optional_components)
    set(__qt_find_package_args "${__qt_pkg}")
    if(__qt_version)
        list(APPEND __qt_find_package_args "${__qt_version}")
    endif()
    if(__qt_components)
        string(REPLACE " " ";" __qt_components "${__qt_components}")
        list(APPEND __qt_find_package_args COMPONENTS ${__qt_components})
    endif()
    if(__qt_optional_components)
        string(REPLACE " " ";" __qt_optional_components "${__qt_optional_components}")
        list(APPEND __qt_find_package_args OPTIONAL_COMPONENTS ${__qt_optional_components})
    endif()

    # Already build an error message, because find_dependency calls return() on failure.
    set(__qt_message "\nPackage: ${__qt_pkg}")
    if(__qt_version)
        string(APPEND __qt_message "\nVersion: ${__qt_version}")
    endif()
    if(__qt_components)
        string(APPEND __qt_message "\nComponents: ${__qt_components}")
    endif()
    if(__qt_optional_components)
        string(APPEND __qt_message "\nComponents: ${__qt_optional_components}")
    endif()
    set(Qt6_DEPENDENCY_NOT_FOUND_MESSAGE "${__qt_message}")

    if(__qt_is_optional)
        if(${CMAKE_FIND_PACKAGE_NAME}_FIND_QUIETLY)
            list(APPEND __qt_find_package_args QUIET)
        endif()
        find_package(${__qt_find_package_args})
    else()
        find_dependency(${__qt_find_package_args})
    endif()
endforeach()

set(Qt6_DEPENDENCIES_FOUND TRUE)
unset(Qt6_DEPENDENCY_NOT_FOUND_MESSAGE)
