/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats;

import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.ParsingFormatBase;
import org.jboss.galleon.util.formatparser.formats.CollectionParsingFormat;
import org.jboss.galleon.util.formatparser.formats.KeyValueParsingFormat;
import org.jboss.galleon.util.formatparser.formats.MapParsingFormat;
import org.jboss.galleon.util.formatparser.formats.StringParsingFormat;

public class WildcardParsingFormat
extends ParsingFormatBase {
    public static final String NAME = "?";
    protected List<ParsingFormat> formats = new ArrayList<ParsingFormat>(3);

    public static WildcardParsingFormat getInstance() {
        return new WildcardParsingFormat();
    }

    public static WildcardParsingFormat getInstance(MapParsingFormat mapFormat) {
        return new WildcardParsingFormat(mapFormat);
    }

    private WildcardParsingFormat() {
        super(NAME, true);
        this.formats.add(CollectionParsingFormat.list(this));
        this.formats.add(MapParsingFormat.getInstance(KeyValueParsingFormat.newInstance(this, this)));
    }

    private WildcardParsingFormat(MapParsingFormat mapFormat) {
        super(NAME, true);
        this.formats.add(CollectionParsingFormat.list(this));
        this.formats.add(mapFormat);
    }

    @Override
    public boolean isOpeningChar(char ch) {
        return true;
    }

    @Override
    public void pushed(ParsingContext ctx) throws FormatParsingException {
        this.deal(ctx);
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
        char ch = ctx.charNow();
        if (Character.isWhitespace(ch)) {
            return;
        }
        for (ParsingFormat format : this.formats) {
            if (!format.isOpeningChar(ch)) continue;
            ctx.pushFormat(format);
            return;
        }
        ctx.pushFormat(StringParsingFormat.getInstance());
    }
}

