/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import java.util.function.Consumer;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.properties.LifecycleAwareValue;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;

public class CachingTaskInputFileCollection
extends DefaultConfigurableFileCollection
implements LifecycleAwareValue {
    private boolean canCache;
    private FileCollectionInternal cachedValue;

    public CachingTaskInputFileCollection(PathToFileResolver fileResolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost) {
        super(null, fileResolver, taskDependencyFactory, patternSetFactory, propertyHost);
    }

    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        if (this.canCache) {
            if (this.cachedValue == null) {
                ImmutableSet.Builder files = ImmutableSet.builder();
                super.visitChildren(arg_0 -> ((ImmutableSet.Builder)files).addAll(arg_0));
                this.cachedValue = new FileCollectionAdapter((MinimalFileSet)new ListBackedFileSet(files.build()), this.patternSetFactory);
            }
            visitor.accept(this.cachedValue);
        } else {
            super.visitChildren(visitor);
        }
    }

    @Override
    public void prepareValue() {
        this.canCache = true;
    }

    @Override
    public void cleanupValue() {
        this.canCache = false;
        this.cachedValue = null;
    }
}

