/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.AbstractOpaqueFileCollection;
import org.gradle.api.internal.tasks.FailureCollectingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Specs;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class DependencyResolvingClasspath
extends AbstractOpaqueFileCollection {
    private final GlobalDependencyResolutionRules globalRules = GlobalDependencyResolutionRules.NO_OP;
    private final List<ResolutionAwareRepository> remoteRepositories;
    private final BinarySpecInternal binary;
    private final ArtifactDependencyResolver dependencyResolver;
    private final ResolveContext resolveContext;
    private final AttributesSchemaInternal attributesSchema;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildIdentifier thisBuild;
    private final String descriptor;
    private ResolveResult resolveResult;

    public DependencyResolvingClasspath(BinarySpecInternal binarySpec, String descriptor, ArtifactDependencyResolver dependencyResolver, List<ResolutionAwareRepository> remoteRepositories, ResolveContext resolveContext, AttributesSchemaInternal attributesSchema, BuildOperationExecutor buildOperationExecutor, BuildIdentifier thisBuild) {
        this.binary = binarySpec;
        this.descriptor = descriptor;
        this.dependencyResolver = dependencyResolver;
        this.remoteRepositories = remoteRepositories;
        this.resolveContext = resolveContext;
        this.attributesSchema = attributesSchema;
        this.buildOperationExecutor = buildOperationExecutor;
        this.thisBuild = thisBuild;
    }

    public String getDisplayName() {
        return "Classpath for " + this.descriptor;
    }

    protected Set<File> getIntrinsicFiles() {
        this.ensureResolved(true);
        final LinkedHashSet<File> result = new LinkedHashSet<File>();
        ParallelResolveArtifactSet artifacts = ParallelResolveArtifactSet.wrap((ResolvedArtifactSet)this.resolveResult.artifactsResults.getArtifacts(), (BuildOperationExecutor)this.buildOperationExecutor);
        artifacts.visit(new ArtifactVisitor(){

            public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
                result.add(artifact.getFile());
            }

            public void visitFailure(Throwable failure) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }

            public boolean requireArtifactFiles() {
                return true;
            }
        });
        return result;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.ensureResolved(false);
        FailureCollectingTaskDependencyResolveContext collectingContext = new FailureCollectingTaskDependencyResolveContext(context);
        this.resolveResult.artifactsResults.getArtifacts().visitDependencies((TaskDependencyResolveContext)collectingContext);
        if (!collectingContext.getFailures().isEmpty()) {
            throw new ResolveException(this.getDisplayName(), (Iterable)collectingContext.getFailures());
        }
    }

    private void ensureResolved(boolean failFast) {
        if (this.resolveResult == null) {
            this.resolveResult = this.resolve();
        }
        if (failFast) {
            this.failOnUnresolvedDependency(this.resolveResult.notFound);
        }
    }

    private ResolveResult resolve() {
        ResolveResult result = new ResolveResult();
        this.dependencyResolver.resolve(this.resolveContext, this.remoteRepositories, this.globalRules, Specs.satisfyAll(), (DependencyGraphVisitor)result, (DependencyArtifactsVisitor)result, this.attributesSchema, new ArtifactTypeRegistry(){

            public ImmutableAttributes mapAttributesFor(File file) {
                return ImmutableAttributes.EMPTY;
            }

            public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
                return attributes;
            }

            public ArtifactTypeContainer create() {
                throw new UnsupportedOperationException();
            }
        });
        return result;
    }

    private void failOnUnresolvedDependency(List<Throwable> notFound) {
        if (!notFound.isEmpty()) {
            throw new LibraryResolveException(String.format("Could not resolve all dependencies for '%s' %s", this.binary.getDisplayName(), this.descriptor), notFound);
        }
    }

    static /* synthetic */ BuildIdentifier access$000(DependencyResolvingClasspath x0) {
        return x0.thisBuild;
    }

    class ResolveResult
    implements DependencyGraphVisitor,
    DependencyArtifactsVisitor {
        public final List<Throwable> notFound = new LinkedList<Throwable>();
        public DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(DependencyResolvingClasspath.access$000(DependencyResolvingClasspath.this), true, ResolutionStrategy.SortOrder.DEFAULT);
        public SelectedArtifactResults artifactsResults;

        ResolveResult() {
        }

        public void start(RootGraphNode root) {
        }

        public void visitNode(DependencyGraphNode node) {
            for (DependencyGraphEdge dependency : node.getOutgoingEdges()) {
                ModuleVersionResolveException failure = dependency.getFailure();
                if (failure == null) continue;
                this.notFound.add((Throwable)failure);
            }
            this.artifactsBuilder.visitNode(node);
        }

        public void visitSelector(DependencyGraphSelector selector) {
        }

        public void visitEdges(DependencyGraphNode node) {
        }

        public void finish(DependencyGraphNode root) {
        }

        public void startArtifacts(RootGraphNode root) {
        }

        public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
            this.artifactsBuilder.visitArtifacts(from, fileDependency, artifactSetId, artifactSet);
        }

        public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
            this.artifactsBuilder.visitArtifacts(from, to, artifactSetId, artifacts);
        }

        public void finishArtifacts() {
            this.artifactsResults = this.artifactsBuilder.complete().select(Specs.satisfyAll(), (candidates, factory) -> ((ResolvedVariant)candidates.getVariants().iterator().next()).getArtifacts());
        }
    }
}

