/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodGroupsHelper {
    static void collectMethodsByGroup(ITestNGMethod[] methods, boolean forTests, List<ITestNGMethod> outIncludedMethods, List<ITestNGMethod> outExcludedMethods, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        for (ITestNGMethod tm : methods) {
            boolean in = false;
            Method m = tm.getMethod();
            if (forTests) {
                in = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(finder, m), runInfo, tm, forTests, unique, outIncludedMethods);
            } else {
                IConfigurationAnnotation annotation = AnnotationHelper.findConfiguration(finder, m);
                if (annotation.getAlwaysRun()) {
                    if (!unique || unique && !MethodGroupsHelper.isMethodAlreadyPresent(outIncludedMethods, tm)) {
                        in = true;
                    }
                } else {
                    in = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(finder, m), runInfo, tm, forTests, unique, outIncludedMethods);
                }
            }
            if (in) {
                outIncludedMethods.add(tm);
                continue;
            }
            outExcludedMethods.add(tm);
        }
    }

    private static boolean includeMethod(ITestOrConfiguration annotation, RunInfo runInfo, ITestNGMethod tm, boolean forTests, boolean unique, List<ITestNGMethod> outIncludedMethods) {
        boolean result = false;
        if (MethodHelper.isEnabled(annotation) && runInfo.includeMethod(tm, forTests)) {
            if (unique) {
                if (!MethodGroupsHelper.isMethodAlreadyPresent(outIncludedMethods, tm)) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private static boolean isMethodAlreadyPresent(List<ITestNGMethod> result, ITestNGMethod tm) {
        for (ITestNGMethod m : result) {
            Class<?> c2;
            Class<?> c1;
            Method jm1 = m.getMethod();
            Method jm2 = tm.getMethod();
            if (!jm1.getName().equals(jm2.getName()) || !(c1 = jm1.getDeclaringClass()).isAssignableFrom(c2 = jm2.getDeclaringClass()) && !c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, List<ITestNGMethod>> findGroupsMethods(Collection<ITestClass> classes, boolean before) {
        Map<String, List<ITestNGMethod>> result = Maps.newHashMap();
        for (ITestClass cls : classes) {
            ITestNGMethod[] methods;
            for (ITestNGMethod method : methods = before ? cls.getBeforeGroupsMethods() : cls.getAfterGroupsMethods()) {
                for (String group : before ? method.getBeforeGroups() : method.getAfterGroups()) {
                    List<ITestNGMethod> methodList = result.get(group);
                    if (methodList == null) {
                        methodList = Lists.newArrayList();
                        result.put(group, methodList);
                    }
                    if (methodList.contains(method)) continue;
                    methodList.add(method);
                }
            }
        }
        return result;
    }

    protected static void findGroupTransitiveClosure(XmlMethodSelector xms, List<ITestNGMethod> includedMethods, List<ITestNGMethod> allMethods, String[] includedGroups, Set<String> outGroups, Set<ITestNGMethod> outMethods) {
        Map<ITestNGMethod, ITestNGMethod> runningMethods = Maps.newHashMap();
        for (ITestNGMethod m : includedMethods) {
            runningMethods.put(m, m);
        }
        Map<String, String> runningGroups = Maps.newHashMap();
        for (String thisGroup : includedGroups) {
            runningGroups.put(thisGroup, thisGroup);
        }
        boolean keepGoing = true;
        Map<ITestNGMethod, ITestNGMethod> newMethods = Maps.newHashMap();
        while (keepGoing) {
            for (ITestNGMethod m : includedMethods) {
                String[] mdu;
                String[] ig;
                for (String g : ig = m.getGroupsDependedUpon()) {
                    ITestNGMethod[] im;
                    if (runningGroups.containsKey(g)) continue;
                    runningGroups.put(g, g);
                    for (ITestNGMethod thisMethod : im = MethodGroupsHelper.findMethodsThatBelongToGroup(m, allMethods.toArray(new ITestNGMethod[allMethods.size()]), g)) {
                        if (runningMethods.containsKey(thisMethod)) continue;
                        runningMethods.put(thisMethod, thisMethod);
                        newMethods.put(thisMethod, thisMethod);
                    }
                }
                for (String tm : mdu = m.getMethodsDependedUpon()) {
                    ITestNGMethod thisMethod = MethodGroupsHelper.findMethodNamed(tm, allMethods);
                    if (thisMethod == null || runningMethods.containsKey(thisMethod)) continue;
                    runningMethods.put(thisMethod, thisMethod);
                    newMethods.put(thisMethod, thisMethod);
                }
            }
            keepGoing = newMethods.size() > 0;
            includedMethods = Lists.newArrayList();
            includedMethods.addAll(newMethods.keySet());
            newMethods = Maps.newHashMap();
        }
        outMethods.addAll(runningMethods.keySet());
        outGroups.addAll(runningGroups.keySet());
    }

    private static ITestNGMethod findMethodNamed(String tm, List<ITestNGMethod> allMethods) {
        for (ITestNGMethod m : allMethods) {
            String methodName = m.getMethod().getDeclaringClass().getName() + "." + m.getMethodName();
            if (!methodName.equals(tm)) continue;
            return m;
        }
        return null;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, ITestNGMethod[] methods, String groupRegexp) {
        boolean foundGroup = false;
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            String[] groups;
            for (String group : groups = tm.getGroups()) {
                if (!Pattern.matches(groupRegexp, group)) continue;
                vResult.add(tm);
                foundGroup = true;
            }
        }
        if (!foundGroup) {
            method.setMissingGroup(groupRegexp);
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }
}

