/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;
import org.gradle.tooling.internal.adapter.CollectionMapper;
import org.gradle.tooling.internal.adapter.MethodInvocation;
import org.gradle.tooling.internal.adapter.MethodInvoker;
import org.gradle.tooling.internal.adapter.ObjectGraphAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.internal.adapter.TypeInspector;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

public class ProtocolToModelAdapter
implements ObjectGraphAdapter {
    private static final ViewDecoration NO_OP_MAPPER;
    private static final TargetTypeProvider IDENTITY_TYPE_PROVIDER;
    private static final Pattern UPPER_LOWER_PATTERN;
    private static final ReflectionMethodInvoker REFLECTION_METHOD_INVOKER;
    private static final TypeInspector TYPE_INSPECTOR;
    private static final CollectionMapper COLLECTION_MAPPER;
    private static final Object[] EMPTY;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private final TargetTypeProvider targetTypeProvider;

    public ProtocolToModelAdapter() {
        this(IDENTITY_TYPE_PROVIDER);
    }

    public ProtocolToModelAdapter(TargetTypeProvider targetTypeProvider) {
        this.targetTypeProvider = targetTypeProvider;
    }

    public ObjectGraphAdapter newGraph() {
        final ViewGraphDetails graphDetails = new ViewGraphDetails(this.targetTypeProvider);
        return new ObjectGraphAdapter(){

            @Override
            public <T> T adapt(Class<T> targetType, Object sourceObject) {
                return (T)ProtocolToModelAdapter.createView(targetType, sourceObject, NO_OP_MAPPER, graphDetails);
            }

            @Override
            public <T> ViewBuilder<T> builder(Class<T> viewType) {
                return new DefaultViewBuilder<T>(viewType, graphDetails);
            }
        };
    }

    @Override
    public <T> T adapt(Class<T> targetType, Object sourceObject) {
        if (sourceObject == null) {
            return null;
        }
        return ProtocolToModelAdapter.createView(targetType, sourceObject, NO_OP_MAPPER, new ViewGraphDetails(this.targetTypeProvider));
    }

    @Override
    public <T> ViewBuilder<T> builder(Class<T> viewType) {
        return new DefaultViewBuilder<T>(viewType);
    }

    private static <T> T createView(Class<T> targetType, Object sourceObject, ViewDecoration decoration, ViewGraphDetails graphDetails) {
        if (sourceObject == null) {
            return null;
        }
        Class<T> viewType = graphDetails.typeProvider.getTargetType(targetType, sourceObject);
        if (viewType.isInstance(sourceObject)) {
            return viewType.cast(sourceObject);
        }
        if (targetType.isEnum()) {
            return ProtocolToModelAdapter.adaptToEnum(targetType, sourceObject);
        }
        ViewDecoration decorationsForThisType = decoration.isNoOp() ? decoration : decoration.restrictTo(TYPE_INSPECTOR.getReachableTypes(targetType));
        ViewKey viewKey = new ViewKey(viewType, sourceObject, decorationsForThisType);
        Object view = graphDetails.views.get(viewKey);
        if (view != null) {
            return targetType.cast(view);
        }
        InvocationHandlerImpl handler = new InvocationHandlerImpl(targetType, sourceObject, decorationsForThisType, graphDetails);
        Object proxy = Proxy.newProxyInstance(viewType.getClassLoader(), new Class[]{viewType}, (InvocationHandler)handler);
        handler.attachProxy(proxy);
        return viewType.cast(proxy);
    }

    private static <T, S> T adaptToEnum(Class<T> targetType, S sourceObject) {
        String literal = sourceObject instanceof Enum ? ((Enum)sourceObject).name() : (sourceObject instanceof String ? (String)sourceObject : sourceObject.toString());
        T result = ProtocolToModelAdapter.toEnum(targetType, literal);
        return result;
    }

    public static <T extends Enum<T>> T toEnum(Class<? extends T> enumType, String literal) {
        T match = ProtocolToModelAdapter.findEnumValue(enumType, literal);
        if (match != null) {
            return match;
        }
        String alternativeLiteral = ProtocolToModelAdapter.toWords(literal, '_');
        match = ProtocolToModelAdapter.findEnumValue(enumType, alternativeLiteral);
        if (match != null) {
            return match;
        }
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (Enum ec : (Enum[])enumType.getEnumConstants()) {
            builder.append(sep);
            builder.append(ec.name());
            sep = ", ";
        }
        throw new IllegalArgumentException(String.format("Cannot convert string value '%s' to an enum value of type '%s' (valid case insensitive values: %s)", literal, enumType.getName(), builder.toString()));
    }

    private static <T extends Enum<T>> T findEnumValue(Class<? extends T> enumType, String literal) {
        for (Enum ec : (Enum[])enumType.getEnumConstants()) {
            if (!ec.name().equalsIgnoreCase(literal)) continue;
            return (T)ec;
        }
        return null;
    }

    public static String toWords(CharSequence string, char separator) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        Matcher matcher = UPPER_LOWER_PATTERN.matcher(string);
        while (pos < string.length()) {
            matcher.find(pos);
            if (matcher.end() == pos) {
                ++pos;
                continue;
            }
            if (builder.length() > 0) {
                builder.append(separator);
            }
            String group1 = matcher.group(1).toLowerCase();
            String group2 = matcher.group(2);
            if (group2.length() == 0) {
                builder.append(group1);
            } else {
                if (group1.length() > 1) {
                    builder.append(group1.substring(0, group1.length() - 1));
                    builder.append(separator);
                    builder.append(group1.substring(group1.length() - 1));
                } else {
                    builder.append(group1);
                }
                builder.append(group2);
            }
            pos = matcher.end();
        }
        return builder.toString();
    }

    private static Object convert(Type targetType, Object sourceObject, ViewDecoration decoration, ViewGraphDetails graphDetails) {
        ParameterizedType parameterizedTargetType;
        if (targetType instanceof ParameterizedType && (parameterizedTargetType = (ParameterizedType)targetType).getRawType() instanceof Class) {
            Class rawClass = (Class)parameterizedTargetType.getRawType();
            if (Iterable.class.isAssignableFrom(rawClass)) {
                Type targetElementType = ProtocolToModelAdapter.getElementType(parameterizedTargetType, 0);
                return ProtocolToModelAdapter.convertCollectionInternal(rawClass, targetElementType, (Iterable)sourceObject, decoration, graphDetails);
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                Type targetKeyType = ProtocolToModelAdapter.getElementType(parameterizedTargetType, 0);
                Type targetValueType = ProtocolToModelAdapter.getElementType(parameterizedTargetType, 1);
                return ProtocolToModelAdapter.convertMap(rawClass, targetKeyType, targetValueType, (Map)sourceObject, decoration, graphDetails);
            }
        }
        if (targetType instanceof Class) {
            Class targetClassType = (Class)Cast.uncheckedNonnullCast((Object)targetType);
            if (targetClassType.isPrimitive()) {
                return sourceObject;
            }
            return ProtocolToModelAdapter.createView(targetClassType, sourceObject, decoration, graphDetails);
        }
        throw new UnsupportedOperationException(String.format("Cannot convert object of %s to %s.", sourceObject.getClass(), targetType));
    }

    private static Map<Object, Object> convertMap(Class<?> mapClass, Type targetKeyType, Type targetValueType, Map<?, ?> sourceObject, ViewDecoration decoration, ViewGraphDetails graphDetails) {
        Map<Object, Object> convertedElements = COLLECTION_MAPPER.createEmptyMap(mapClass);
        for (Map.Entry<?, ?> entry : sourceObject.entrySet()) {
            convertedElements.put(ProtocolToModelAdapter.convert(targetKeyType, entry.getKey(), decoration, graphDetails), ProtocolToModelAdapter.convert(targetValueType, entry.getValue(), decoration, graphDetails));
        }
        return convertedElements;
    }

    private static Object convertCollectionInternal(Class<?> collectionClass, Type targetElementType, Iterable<?> sourceObject, ViewDecoration decoration, ViewGraphDetails graphDetails) {
        Collection<Object> convertedElements = COLLECTION_MAPPER.createEmptyCollection(collectionClass);
        ProtocolToModelAdapter.convertCollectionInternal(convertedElements, targetElementType, sourceObject, decoration, graphDetails);
        if (collectionClass.equals(DomainObjectSet.class)) {
            return new ImmutableDomainObjectSet<Object>(convertedElements);
        }
        return convertedElements;
    }

    private static void convertCollectionInternal(Collection<Object> targetCollection, Type targetElementType, Iterable<?> sourceObject, ViewDecoration viewDecoration, ViewGraphDetails graphDetails) {
        for (Object element : sourceObject) {
            targetCollection.add(ProtocolToModelAdapter.convert(targetElementType, element, viewDecoration, graphDetails));
        }
    }

    private static Type getElementType(ParameterizedType type, int index) {
        Type elementType = type.getActualTypeArguments()[index];
        if (elementType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)elementType;
            return wildcardType.getUpperBounds()[0];
        }
        return elementType;
    }

    public Object unpack(Object viewObject) {
        if (!Proxy.isProxyClass(viewObject.getClass()) || !(Proxy.getInvocationHandler(viewObject) instanceof InvocationHandlerImpl)) {
            throw new IllegalArgumentException("The given object is not a view object");
        }
        InvocationHandlerImpl handler = (InvocationHandlerImpl)Proxy.getInvocationHandler(viewObject);
        return handler.sourceObject;
    }

    static {
        Method hashCodeMethod;
        Method equalsMethod;
        NO_OP_MAPPER = new NoOpDecoration();
        IDENTITY_TYPE_PROVIDER = new TargetTypeProvider(){

            @Override
            public <T> Class<? extends T> getTargetType(Class<T> initialTargetType, Object protocolObject) {
                return initialTargetType;
            }
        };
        UPPER_LOWER_PATTERN = Pattern.compile("(?m)([A-Z]*)([a-z0-9]*)");
        REFLECTION_METHOD_INVOKER = new ReflectionMethodInvoker();
        TYPE_INSPECTOR = new TypeInspector();
        COLLECTION_MAPPER = new CollectionMapper();
        EMPTY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
        try {
            equalsMethod = Object.class.getMethod("equals", Object.class);
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        EQUALS_METHOD = equalsMethod;
        HASHCODE_METHOD = hashCodeMethod;
    }

    private class DefaultViewBuilder<T>
    implements ViewBuilder<T> {
        private final Class<T> viewType;
        @Nullable
        private final ViewGraphDetails graphDetails;
        List<ViewDecoration> viewDecorations = new ArrayList<ViewDecoration>();

        DefaultViewBuilder(Class<T> viewType) {
            this.viewType = viewType;
            this.graphDetails = null;
        }

        DefaultViewBuilder(@Nullable Class<T> viewType, ViewGraphDetails graphDetails) {
            this.viewType = viewType;
            this.graphDetails = graphDetails;
        }

        @Override
        public ViewBuilder<T> mixInTo(Class<?> targetType, Object mixIn) {
            this.viewDecorations.add(new MixInBeanMappingAction(targetType, mixIn));
            return this;
        }

        @Override
        public ViewBuilder<T> mixInTo(Class<?> targetType, Class<?> mixInType) {
            this.viewDecorations.add(new MixInTypeMappingAction(targetType, mixInType));
            return this;
        }

        @Override
        public T build(@Nullable Object sourceObject) {
            if (sourceObject == null) {
                return null;
            }
            ViewDecoration viewDecoration = MixInMappingAction.chain(this.viewDecorations);
            return (T)ProtocolToModelAdapter.createView(this.viewType, sourceObject, viewDecoration, this.graphDetails != null ? this.graphDetails : new ViewGraphDetails(ProtocolToModelAdapter.this.targetTypeProvider));
        }
    }

    private static class MixInTypeMappingAction
    extends TypeSpecificMappingAction {
        private final Class<?> mixInType;

        MixInTypeMappingAction(Class<?> targetType, Class<?> mixInType) {
            super(targetType);
            this.mixInType = mixInType;
        }

        public int hashCode() {
            return this.targetType.hashCode() ^ this.mixInType.hashCode();
        }

        public boolean equals(Object obj) {
            if (!obj.getClass().equals(MixInTypeMappingAction.class)) {
                return false;
            }
            MixInTypeMappingAction other = (MixInTypeMappingAction)obj;
            return this.targetType.equals(other.targetType) && this.mixInType.equals(other.mixInType);
        }

        @Override
        protected MethodInvoker createInvoker() {
            return new ClassMixInMethodInvoker(this.mixInType, REFLECTION_METHOD_INVOKER);
        }
    }

    private static class MixInBeanMappingAction
    extends TypeSpecificMappingAction {
        private final Object mixIn;

        MixInBeanMappingAction(Class<?> targetType, Object mixIn) {
            super(targetType);
            this.mixIn = mixIn;
        }

        public int hashCode() {
            return this.targetType.hashCode() ^ this.mixIn.hashCode();
        }

        public boolean equals(Object obj) {
            if (!obj.getClass().equals(MixInBeanMappingAction.class)) {
                return false;
            }
            MixInBeanMappingAction other = (MixInBeanMappingAction)obj;
            return this.targetType.equals(other.targetType) && this.mixIn.equals(other.mixIn);
        }

        @Override
        protected MethodInvoker createInvoker() {
            return new BeanMixInMethodInvoker(this.mixIn, REFLECTION_METHOD_INVOKER);
        }
    }

    private static abstract class TypeSpecificMappingAction
    implements ViewDecoration,
    Serializable {
        protected final Class<?> targetType;

        TypeSpecificMappingAction(Class<?> targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean isNoOp() {
            return false;
        }

        @Override
        public ViewDecoration restrictTo(Set<Class<?>> viewTypes) {
            if (viewTypes.contains(this.targetType)) {
                return this;
            }
            return NO_OP_MAPPER;
        }

        @Override
        public void collectInvokers(Object sourceObject, Class<?> viewType, List<MethodInvoker> invokers) {
            if (this.targetType.isAssignableFrom(viewType)) {
                invokers.add(this.createInvoker());
            }
        }

        protected abstract MethodInvoker createInvoker();
    }

    private static class MixInMappingAction
    implements ViewDecoration,
    Serializable {
        private final List<? extends ViewDecoration> decorations;

        private MixInMappingAction(List<? extends ViewDecoration> decorations) {
            assert (decorations.size() >= 2);
            this.decorations = decorations;
        }

        static ViewDecoration chain(List<? extends ViewDecoration> decorations) {
            if (decorations.isEmpty()) {
                return NO_OP_MAPPER;
            }
            if (decorations.size() == 1) {
                return decorations.get(0);
            }
            return new MixInMappingAction(decorations);
        }

        public int hashCode() {
            int v = 0;
            for (ViewDecoration viewDecoration : this.decorations) {
                v ^= viewDecoration.hashCode();
            }
            return v;
        }

        public boolean equals(Object obj) {
            if (!obj.getClass().equals(MixInMappingAction.class)) {
                return false;
            }
            MixInMappingAction other = (MixInMappingAction)obj;
            return this.decorations.equals(other.decorations);
        }

        @Override
        public boolean isNoOp() {
            for (ViewDecoration viewDecoration : this.decorations) {
                if (viewDecoration.isNoOp()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ViewDecoration restrictTo(Set<Class<?>> viewTypes) {
            ArrayList<ViewDecoration> filtered = new ArrayList<ViewDecoration>();
            for (ViewDecoration viewDecoration : this.decorations) {
                ViewDecoration filteredDecoration = viewDecoration.restrictTo(viewTypes);
                if (filteredDecoration.isNoOp()) continue;
                filtered.add(filteredDecoration);
            }
            if (filtered.size() == 0) {
                return NO_OP_MAPPER;
            }
            if (filtered.size() == 1) {
                return (ViewDecoration)filtered.get(0);
            }
            if (filtered.equals(this.decorations)) {
                return this;
            }
            return new MixInMappingAction(filtered);
        }

        @Override
        public void collectInvokers(Object sourceObject, Class<?> viewType, List<MethodInvoker> invokers) {
            for (ViewDecoration viewDecoration : this.decorations) {
                viewDecoration.collectInvokers(sourceObject, viewType, invokers);
            }
        }
    }

    private static class NoOpDecoration
    implements ViewDecoration,
    Serializable {
        private NoOpDecoration() {
        }

        @Override
        public void collectInvokers(Object sourceObject, Class<?> viewType, List<MethodInvoker> invokers) {
        }

        public boolean equals(Object obj) {
            return obj instanceof NoOpDecoration;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public boolean isNoOp() {
            return true;
        }

        @Override
        public ViewDecoration restrictTo(Set<Class<?>> viewTypes) {
            return this;
        }
    }

    private static interface ViewDecoration {
        public void collectInvokers(Object var1, Class<?> var2, List<MethodInvoker> var3);

        public boolean isNoOp();

        public ViewDecoration restrictTo(Set<Class<?>> var1);
    }

    private static class ClassMixInMethodInvoker
    implements MethodInvoker {
        private Object instance;
        private final Class<?> mixInClass;
        private final MethodInvoker next;
        private final ThreadLocal<MethodInvocation> current = new ThreadLocal();

        ClassMixInMethodInvoker(Class<?> mixInClass, MethodInvoker next) {
            this.mixInClass = mixInClass;
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            if (this.current.get() != null) {
                return;
            }
            if (this.instance == null) {
                this.instance = DirectInstantiator.INSTANCE.newInstance(this.mixInClass, new Object[]{invocation.getView()});
            }
            MethodInvocation beanInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), invocation.getParameterTypes(), invocation.getView(), invocation.getViewType(), this.instance, invocation.getParameters());
            this.current.set(beanInvocation);
            try {
                this.next.invoke(beanInvocation);
            }
            finally {
                this.current.set(null);
            }
            if (beanInvocation.found()) {
                invocation.setResult(beanInvocation.getResult());
            }
        }
    }

    private static class BeanMixInMethodInvoker
    implements MethodInvoker {
        private final Object instance;
        private final MethodInvoker next;

        BeanMixInMethodInvoker(Object instance, MethodInvoker next) {
            this.instance = instance;
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            MethodInvocation beanInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), invocation.getParameterTypes(), invocation.getView(), invocation.getViewType(), this.instance, invocation.getParameters());
            this.next.invoke(beanInvocation);
            if (beanInvocation.found()) {
                invocation.setResult(beanInvocation.getResult());
                return;
            }
            if (!invocation.isGetter()) {
                return;
            }
            beanInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), new Class[]{invocation.getViewType()}, invocation.getView(), invocation.getViewType(), this.instance, new Object[]{invocation.getView()});
            this.next.invoke(beanInvocation);
            if (beanInvocation.found()) {
                invocation.setResult(beanInvocation.getResult());
            }
        }
    }

    private static class SupportedPropertyInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SupportedPropertyInvoker(MethodInvoker next) {
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            boolean isSupportMethod;
            this.next.invoke(invocation);
            if (invocation.found()) {
                return;
            }
            String methodName = invocation.getName();
            boolean bl = isSupportMethod = methodName.length() > 11 && methodName.startsWith("is") && methodName.endsWith("Supported");
            if (!isSupportMethod) {
                return;
            }
            String getterName = "get" + methodName.substring(2, methodName.length() - 9);
            MethodInvocation getterInvocation = new MethodInvocation(getterName, invocation.getReturnType(), invocation.getGenericReturnType(), EMPTY_CLASS_ARRAY, invocation.getView(), invocation.getViewType(), invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            invocation.setResult(getterInvocation.found());
        }
    }

    private static class SafeMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SafeMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found() || invocation.getParameterTypes().length != 1 || !invocation.isIsOrGet()) {
                return;
            }
            MethodInvocation getterInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), EMPTY_CLASS_ARRAY, invocation.getView(), invocation.getViewType(), invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            if (getterInvocation.found() && getterInvocation.getResult() != null) {
                invocation.setResult(getterInvocation.getResult());
            } else {
                invocation.setResult(invocation.getParameters()[0]);
            }
        }
    }

    private static class PropertyCachingMethodInvoker
    implements MethodInvoker {
        private Map<String, Object> properties = Collections.emptyMap();
        private Set<String> unknown = Collections.emptySet();
        private final MethodInvoker next;

        private PropertyCachingMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation method) throws Throwable {
            if (method.isGetter()) {
                if (this.properties.containsKey(method.getName())) {
                    method.setResult(this.properties.get(method.getName()));
                    return;
                }
                if (this.unknown.contains(method.getName())) {
                    return;
                }
                this.next.invoke(method);
                if (!method.found()) {
                    this.markUnknown(method.getName());
                    return;
                }
                Object value = method.getResult();
                this.cachePropertyValue(method.getName(), value);
                return;
            }
            this.next.invoke(method);
        }

        private void markUnknown(String methodName) {
            if (this.unknown.isEmpty()) {
                this.unknown = new HashSet<String>();
            }
            this.unknown.add(methodName);
        }

        private void cachePropertyValue(String methodName, Object value) {
            if (this.properties.isEmpty()) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(methodName, value);
        }
    }

    private static class ReflectionMethodInvoker
    implements MethodInvoker {
        private final MethodInvocationCache lookupCache = new MethodInvocationCache();

        private ReflectionMethodInvoker() {
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            Object returnValue;
            Method targetMethod = this.locateMethod(invocation);
            if (targetMethod == null) {
                return;
            }
            try {
                returnValue = targetMethod.invoke(invocation.getDelegate(), invocation.getParameters());
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            invocation.setResult(returnValue);
        }

        private Method locateMethod(MethodInvocation invocation) {
            return this.lookupCache.get(invocation);
        }
    }

    private static class MethodInvocationCache {
        private final Map<MethodInvocationKey, Optional<Method>> store = new HashMap<MethodInvocationKey, Optional<Method>>();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private static final long MINIMAL_CLEANUP_INTERVAL = 30000L;
        private int cacheMiss;
        private int cacheHit;
        private int evict;
        private CountdownTimer cleanupTimer = Time.startCountdownTimer((long)30000L);

        private MethodInvocationCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Method get(MethodInvocation invocation) {
            Class<?> owner = invocation.getDelegate().getClass();
            String name = invocation.getName();
            Class[] parameterTypes = invocation.getParameterTypes();
            MethodInvocationKey key = new MethodInvocationKey(owner, name, parameterTypes);
            this.lock.readLock().lock();
            Optional<Method> cached = this.store.get(key);
            if (cached == null) {
                ++this.cacheMiss;
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    cached = this.store.get(key);
                    if (cached == null) {
                        cached = MethodInvocationCache.lookup(owner, name, parameterTypes);
                        if (this.cacheMiss % 10 == 0) {
                            this.removeDirtyEntries();
                        }
                        this.store.put(key, cached);
                    }
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                ++this.cacheHit;
            }
            try {
                Method method = (Method)cached.orNull();
                return method;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void removeDirtyEntries() {
            if (!this.cleanupTimer.hasExpired()) {
                return;
            }
            this.lock.writeLock().lock();
            try {
                for (MethodInvocationKey key : new LinkedList<MethodInvocationKey>(this.store.keySet())) {
                    if (!key.isDirty()) continue;
                    ++this.evict;
                    this.store.remove(key);
                }
            }
            finally {
                this.cleanupTimer.reset();
                this.lock.writeLock().unlock();
            }
        }

        private static Optional<Method> lookup(Class<?> sourceClass, String methodName, Class<?>[] parameterTypes) {
            Method match;
            try {
                match = sourceClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return Optional.absent();
            }
            LinkedList queue = new LinkedList();
            queue.add(sourceClass);
            while (!queue.isEmpty()) {
                Class c = (Class)queue.removeFirst();
                try {
                    match = c.getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                for (Class<?> interfaceType : c.getInterfaces()) {
                    queue.addFirst(interfaceType);
                }
                if (c.getSuperclass() == null) continue;
                queue.addFirst(c.getSuperclass());
            }
            match.setAccessible(true);
            return Optional.of((Object)match);
        }

        public String toString() {
            return "Cache size: " + this.store.size() + " Hits: " + this.cacheHit + " Miss: " + this.cacheMiss + " Evicted: " + this.evict;
        }

        private static class MethodInvocationKey {
            private final SoftReference<Class<?>> lookupClass;
            private final String methodName;
            private final SoftReference<Class<?>[]> parameterTypes;
            private final int hashCode;

            private MethodInvocationKey(Class<?> lookupClass, String methodName, Class<?>[] parameterTypes) {
                this.lookupClass = new SoftReference(lookupClass);
                this.methodName = methodName;
                this.parameterTypes = new SoftReference<Class<?>[]>(parameterTypes);
                int result = lookupClass != null ? lookupClass.hashCode() : 0;
                result = 31 * result + (methodName != null ? methodName.hashCode() : 0);
                this.hashCode = result = 31 * result + Arrays.hashCode(parameterTypes);
            }

            public boolean isDirty() {
                return this.lookupClass.get() == null || this.parameterTypes.get() == null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MethodInvocationKey that = (MethodInvocationKey)o;
                if (this.isDirty() && that.isDirty()) {
                    return true;
                }
                if (!MethodInvocationKey.eq(this.lookupClass, that.lookupClass)) {
                    return false;
                }
                if (!this.methodName.equals(that.methodName)) {
                    return false;
                }
                return MethodInvocationKey.eq(this.parameterTypes, that.parameterTypes);
            }

            private static boolean eq(SoftReference<?> aRef, SoftReference<?> bRef) {
                Object a = aRef.get();
                Object b = bRef.get();
                return MethodInvocationKey.eq(a, b);
            }

            private static boolean eq(Object a, Object b) {
                if (a == b) {
                    return true;
                }
                if (a == null) {
                    return false;
                }
                if (a.getClass().isArray()) {
                    return Arrays.equals((Object[])a, (Object[])b);
                }
                return a.equals(b);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }

    private static class AdaptingMethodInvoker
    implements MethodInvoker {
        private final ViewDecoration decoration;
        private final ViewGraphDetails graphDetails;
        private final MethodInvoker next;

        private AdaptingMethodInvoker(ViewDecoration decoration, ViewGraphDetails graphDetails, MethodInvoker next) {
            this.decoration = decoration;
            this.graphDetails = graphDetails;
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found() && invocation.getResult() != null) {
                invocation.setResult(ProtocolToModelAdapter.convert(invocation.getGenericReturnType(), invocation.getResult(), this.decoration, this.graphDetails));
            }
        }
    }

    private static class ChainedMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker[] invokers;

        private ChainedMethodInvoker(List<MethodInvoker> invokers) {
            this.invokers = invokers.toArray(new MethodInvoker[0]);
        }

        @Override
        public void invoke(MethodInvocation method) throws Throwable {
            for (int i = 0; !method.found() && i < this.invokers.length; ++i) {
                MethodInvoker invoker = this.invokers[i];
                invoker.invoke(method);
            }
        }
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler,
    Serializable {
        private final Class<?> targetType;
        private final Object sourceObject;
        private final ViewDecoration decoration;
        private final ViewGraphDetails graphDetails;
        private Object proxy;
        private transient MethodInvoker invoker;

        InvocationHandlerImpl(Class<?> targetType, Object sourceObject, ViewDecoration decoration, ViewGraphDetails graphDetails) {
            this.targetType = targetType;
            this.sourceObject = sourceObject;
            this.decoration = decoration;
            this.graphDetails = graphDetails;
            this.setup();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.setup();
            this.graphDetails.views.put(new ViewKey(this.targetType, this.sourceObject, this.decoration), this.proxy);
        }

        private void setup() {
            ArrayList<MethodInvoker> invokers = new ArrayList<MethodInvoker>();
            invokers.add(REFLECTION_METHOD_INVOKER);
            this.decoration.collectInvokers(this.sourceObject, this.targetType, invokers);
            MethodInvoker mixInMethodInvoker = invokers.size() == 1 ? (MethodInvoker)invokers.get(0) : new ChainedMethodInvoker(invokers);
            this.invoker = new SupportedPropertyInvoker(new SafeMethodInvoker(new PropertyCachingMethodInvoker(new AdaptingMethodInvoker(this.decoration, this.graphDetails, mixInMethodInvoker))));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            InvocationHandlerImpl other = (InvocationHandlerImpl)o;
            return this.sourceObject.equals(other.sourceObject);
        }

        public int hashCode() {
            return this.sourceObject.hashCode();
        }

        @Override
        public Object invoke(Object target, Method method, Object[] params) throws Throwable {
            if (EQUALS_METHOD.equals(method)) {
                Object param = params[0];
                if (param == null || !Proxy.isProxyClass(param.getClass())) {
                    return false;
                }
                InvocationHandler other = Proxy.getInvocationHandler(param);
                return this.equals(other);
            }
            if (HASHCODE_METHOD.equals(method)) {
                return this.hashCode();
            }
            MethodInvocation invocation = new MethodInvocation(method.getName(), method.getReturnType(), method.getGenericReturnType(), method.getParameterTypes(), target, this.targetType, this.sourceObject, params);
            this.invoker.invoke(invocation);
            if (!invocation.found()) {
                String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()";
                throw Exceptions.unsupportedMethod(methodName);
            }
            return invocation.getResult();
        }

        void attachProxy(Object proxy) {
            this.proxy = proxy;
            this.graphDetails.views.put(new ViewKey(this.targetType, this.sourceObject, this.decoration), proxy);
        }
    }

    private static class ViewKey
    implements Serializable {
        private final Class<?> type;
        private final Object source;
        private final ViewDecoration viewDecoration;

        ViewKey(Class<?> type, Object source, ViewDecoration viewDecoration) {
            this.type = type;
            this.source = source;
            this.viewDecoration = viewDecoration;
        }

        public boolean equals(Object obj) {
            ViewKey other = (ViewKey)obj;
            return other.source == this.source && other.type.equals(this.type) && other.viewDecoration.equals(this.viewDecoration);
        }

        public int hashCode() {
            return this.type.hashCode() ^ System.identityHashCode(this.source) ^ this.viewDecoration.hashCode();
        }
    }

    private static class ViewGraphDetails
    implements Serializable {
        private transient Map<ViewKey, Object> views = new HashMap<ViewKey, Object>();
        private final TargetTypeProvider typeProvider;

        ViewGraphDetails(TargetTypeProvider typeProvider) {
            this.typeProvider = typeProvider;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.views = new HashMap<ViewKey, Object>();
        }
    }
}

