/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirModifiableVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirPropertyAccessorImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirPropertyImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirValueParameterImpl;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirSimpleDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.impl.FirBinaryLogicExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirCallableReferenceAccessImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirComponentCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirExpressionStub;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirQualifiedAccessExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirReturnExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirTypeOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenBranchImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenSubjectExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWrappedDelegateExpressionImpl;
import org.jetbrains.kotlin.fir.impl.FirAbstractAnnotatedElement;
import org.jetbrains.kotlin.fir.references.impl.FirDelegateFieldReferenceImpl;
import org.jetbrains.kotlin.fir.references.impl.FirExplicitThisReference;
import org.jetbrains.kotlin.fir.references.impl.FirResolvedNamedReferenceImpl;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKPropertyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImpl;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u00b4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001af\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001d\u0010\u0019\u001a\u0019\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001a\u00a2\u0006\u0002\b\u001e2\u0019\u0010\u001f\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b\u001eH\u0000\u001a\u001c\u0010#\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0016\u001a,\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0010\u001a,\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0010\u001a\u0017\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010*\u001a0\u0010+\u001a\u00020\u001d*\u0006\u0012\u0002\b\u00030,2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u00010\u0010\u001a.\u00100\u001a\u000201*\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00182\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107\u001a$\u00108\u001a\u000209*\u00020\u00102\u0006\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00182\b\u0010<\u001a\u0004\u0018\u00010\r\u001a,\u0010=\u001a\u00020>*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\r\u001a\u0011\u0010@\u001a\u0004\u0018\u00010\u0006*\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\f\u0010A\u001a\u0004\u0018\u00010\u0001*\u00020B\u001a\n\u0010C\u001a\u00020D*\u00020B\u001ae\u0010E\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020G0F2\b\u0010<\u001a\u0004\u0018\u00010\r2\u0006\u0010H\u001a\u00020I2\u001f\u0010J\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u001a\u00a2\u0006\u0002\b\u001e2\u0019\u0010K\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b\u001eH\u0000\u00a2\u0006\u0002\u0010L\u001aP\u0010E\u001a\u00020\u0010*\u00020G2\u0006\u0010H\u001a\u00020I2\u001f\u0010J\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u001a\u00a2\u0006\u0002\b\u001e2\u0019\u0010K\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b\u001eH\u0000\u001a\f\u0010M\u001a\u0004\u0018\u00010\u0001*\u00020B\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"DELEGATED_SETTER_PARAM", "Lorg/jetbrains/kotlin/name/Name;", "GET_VALUE", "PROVIDE_DELEGATE", "SET_VALUE", "escapedStringToCharacter", "", "text", "", "(Ljava/lang/String;)Ljava/lang/Character;", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "name", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "extractAnnotationsTo", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "Lorg/jetbrains/kotlin/fir/impl/FirAbstractAnnotatedElement;", "", "Lkotlin/ExtensionFunctionType;", "toFirOrImplicitTypeRef", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "generateResolvedAccessExpression", "variable", "generateTemporaryVariable", "specialName", "initializer", "translateEscape", "c", "(C)Ljava/lang/Character;", "generateAccessorsByDelegate", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirModifiableVariable;", "member", "stubMode", "receiver", "generateContainsOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "argument", "inverted", "base", "Lorg/jetbrains/kotlin/psi/KtExpression;", "operationReference", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "baseSource", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "caseId", "parseCharacter", "toBinaryName", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toFirWhenCondition", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "subject", "Lorg/jetbrains/kotlin/fir/FirWhenSubject;", "convert", "toFirOrErrorTypeRef", "([Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/FirWhenSubject;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toUnaryName", "psi2fir"})
public final class ConversionUtilsKt {
    private static final Name GET_VALUE;
    private static final Name SET_VALUE;
    private static final Name PROVIDE_DELEGATE;
    private static final Name DELEGATED_SETTER_PARAM;

    @Nullable
    public static final Character parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseCharacter, (String)"$this$parseCharacter");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return null;
        }
        CharSequence charSequence = $this$parseCharacter;
        int n = 1;
        int n2 = $this$parseCharacter.length() - 1;
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text2 = string2;
        charSequence = text2;
        n = 0;
        if (charSequence.length() == 0) {
            return null;
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? Character.valueOf(text2.charAt(0)) : null) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @Nullable
    public static final Character escapedStringToCharacter(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0 && text2.charAt(0) == '\\';
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Only escaped sequences must be passed to this routine: " + text2;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        String string3 = text2;
        int n = 1;
        int n2 = 0;
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String escape = string4;
        switch (escape.length()) {
            case 0: {
                return null;
            }
            case 1: {
                Character c = ConversionUtilsKt.translateEscape(escape.charAt(0));
                if (c == null) {
                    return null;
                }
                return Character.valueOf(c.charValue());
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    String string5 = escape;
                    n2 = 1;
                    boolean bl4 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer intValue = Integer.valueOf(string7, 16);
                    return Character.valueOf((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Character translateEscape(char c) {
        Character c2;
        switch (c) {
            case 't': {
                c2 = Character.valueOf('\t');
                break;
            }
            case 'b': {
                c2 = Character.valueOf('\b');
                break;
            }
            case 'n': {
                c2 = Character.valueOf('\n');
                break;
            }
            case 'r': {
                c2 = Character.valueOf('\r');
                break;
            }
            case '\'': {
                c2 = Character.valueOf('\'');
                break;
            }
            case '\"': {
                c2 = Character.valueOf('\"');
                break;
            }
            case '\\': {
                c2 = Character.valueOf('\\');
                break;
            }
            case '$': {
                c2 = Character.valueOf('$');
                break;
            }
            default: {
                c2 = null;
            }
        }
        return c2;
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toBinaryName, (String)"$this$toBinaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.BINARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toUnaryName, (String)"$this$toUnaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.UNARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirOperation, (String)"$this$toFirOperation");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ)) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_KEYWORD)) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_SAFE)) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)$this$toFirOperation.toString()));
        }
        return firOperation;
    }

    @NotNull
    public static final FirWhenExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirSession session, @NotNull FirExpression other, @NotNull String caseId, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateNotNullOrOther, (String)"$this$generateNotNullOrOther");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)caseId, (String)"caseId");
        Name name = Name.special('<' + caseId + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$caseId>\")");
        Name subjectName = name;
        FirVariable<?> subjectVariable = ConversionUtilsKt.generateTemporaryVariable(session, baseSource, subjectName, $this$generateNotNullOrOther);
        FirWhenSubject subject = new FirWhenSubject();
        FirWhenSubjectExpressionImpl subjectExpression = new FirWhenSubjectExpressionImpl(baseSource, subject);
        FirWhenExpressionImpl firWhenExpressionImpl = new FirWhenExpressionImpl(baseSource, $this$generateNotNullOrOther, subjectVariable);
        boolean bl = false;
        boolean bl2 = false;
        FirWhenExpressionImpl $this$apply = firWhenExpressionImpl;
        boolean bl3 = false;
        subject.bind($this$apply);
        Collection collection = $this$apply.getBranches();
        FirPureAbstractElement firPureAbstractElement = new FirOperatorCallImpl(baseSource, FirOperation.EQ);
        FirSourceElement firSourceElement = baseSource;
        boolean bl4 = false;
        boolean bl5 = false;
        FirOperatorCallImpl $this$apply2 = firPureAbstractElement;
        boolean bl6 = false;
        Collection collection2 = $this$apply2.getArguments();
        FirPureAbstractElement firPureAbstractElement2 = subjectExpression;
        boolean bl7 = false;
        collection2.add(firPureAbstractElement2);
        collection2 = $this$apply2.getArguments();
        firPureAbstractElement2 = new FirConstExpressionImpl<Object>(baseSource, FirConstKind.Null.INSTANCE, null);
        bl7 = false;
        collection2.add(firPureAbstractElement2);
        FirOperatorCallImpl firOperatorCallImpl = firPureAbstractElement;
        FirBlock firBlock = new FirSingleExpressionBlock(other);
        FirExpression firExpression2 = firOperatorCallImpl;
        FirSourceElement firSourceElement2 = firSourceElement;
        firPureAbstractElement = new FirWhenBranchImpl(firSourceElement2, firExpression2, firBlock);
        bl4 = false;
        collection.add(firPureAbstractElement);
        collection = $this$apply.getBranches();
        firPureAbstractElement = new FirWhenBranchImpl(other.getSource(), new FirElseIfTrueCondition(baseSource), new FirSingleExpressionBlock(ConversionUtilsKt.generateResolvedAccessExpression(baseSource, subjectVariable)));
        bl4 = false;
        collection.add(firPureAbstractElement);
        return firWhenExpressionImpl;
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateLazyLogicalOperation, (String)"$this$generateLazyLogicalOperation");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        LogicOperationKind kind = isAnd ? LogicOperationKind.AND : LogicOperationKind.OR;
        return new FirBinaryLogicExpressionImpl(baseSource, $this$generateLazyLogicalOperation, other, kind);
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition $this$toFirWhenCondition, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        FirElement firElement;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirWhenCondition, (String)"$this$toFirWhenCondition");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        Intrinsics.checkParameterIsNotNull(toFirOrErrorTypeRef, (String)"toFirOrErrorTypeRef");
        PsiElement $this$toFirSourceElement$iv = $this$toFirWhenCondition;
        boolean $i$f$toFirSourceElement = false;
        FirPsiSourceElement firPsiSourceElement = new FirPsiSourceElement($this$toFirSourceElement$iv);
        FirWhenSubject firWhenSubject = subject;
        FirSourceElement firSourceElement = firPsiSourceElement;
        FirWhenSubjectExpressionImpl firSubjectExpression = new FirWhenSubjectExpressionImpl(firSourceElement, firWhenSubject);
        KtWhenCondition ktWhenCondition = $this$toFirWhenCondition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            FirPsiSourceElement firPsiSourceElement2;
            boolean $i$f$toFirSourceElement2;
            KtExpression ktExpression = ((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression();
            if (ktExpression != null) {
                PsiElement $this$toFirSourceElement$iv2 = ktExpression;
                $i$f$toFirSourceElement2 = false;
                firPsiSourceElement2 = firPsiSourceElement = new FirPsiSourceElement($this$toFirSourceElement$iv2);
            } else {
                firPsiSourceElement2 = null;
            }
            FirOperation firOperation = FirOperation.EQ;
            FirSourceElement firSourceElement2 = firPsiSourceElement2;
            FirOperatorCallImpl $this$toFirSourceElement$iv2 = new FirOperatorCallImpl(firSourceElement2, firOperation);
            $i$f$toFirSourceElement2 = false;
            boolean bl = false;
            FirOperatorCallImpl $this$apply = $this$toFirSourceElement$iv2;
            boolean bl2 = false;
            Collection collection = $this$apply.getArguments();
            Object object = firSubjectExpression;
            boolean bl3 = false;
            collection.add(object);
            collection = $this$apply.getArguments();
            object = convert.invoke((Object)((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression(), (Object)"No expression in condition with expression");
            bl3 = false;
            collection.add(object);
            firElement = $this$toFirSourceElement$iv2;
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            FirExpression firRange = (FirExpression)convert.invoke((Object)((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression(), (Object)"No range in condition with range");
            firElement = ConversionUtilsKt.generateContainsOperation(firRange, firSubjectExpression, ((KtWhenConditionInRange)$this$toFirWhenCondition).isNegated(), ((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression(), ((KtWhenConditionInRange)$this$toFirWhenCondition).getOperationReference());
        } else if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            FirPsiSourceElement firPsiSourceElement3;
            boolean $i$f$toFirSourceElement3;
            KtTypeReference ktTypeReference = ((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference();
            if (ktTypeReference != null) {
                PsiElement $this$toFirSourceElement$iv3 = ktTypeReference;
                $i$f$toFirSourceElement3 = false;
                firPsiSourceElement3 = firPsiSourceElement = new FirPsiSourceElement($this$toFirSourceElement$iv3);
            } else {
                firPsiSourceElement3 = null;
            }
            FirTypeRef firTypeRef = (FirTypeRef)toFirOrErrorTypeRef.invoke((Object)((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference());
            FirOperation firOperation = ((KtWhenConditionIsPattern)$this$toFirWhenCondition).isNegated() ? FirOperation.NOT_IS : FirOperation.IS;
            FirSourceElement firSourceElement3 = firPsiSourceElement3;
            FirTypeOperatorCallImpl $this$toFirSourceElement$iv3 = new FirTypeOperatorCallImpl(firSourceElement3, firOperation, firTypeRef);
            $i$f$toFirSourceElement3 = false;
            boolean bl = false;
            FirTypeOperatorCallImpl $this$apply = $this$toFirSourceElement$iv3;
            boolean bl4 = false;
            Collection collection = $this$apply.getArguments();
            FirWhenSubjectExpressionImpl firWhenSubjectExpressionImpl = firSubjectExpression;
            boolean bl5 = false;
            collection.add(firWhenSubjectExpressionImpl);
            firElement = $this$toFirSourceElement$iv3;
        } else {
            PsiElement $this$toFirSourceElement$iv4 = $this$toFirWhenCondition;
            boolean $i$f$toFirSourceElement4 = false;
            firPsiSourceElement = new FirPsiSourceElement($this$toFirSourceElement$iv4);
            FirDiagnostic firDiagnostic = new FirSimpleDiagnostic("Unsupported when condition: " + $this$toFirWhenCondition.getClass(), DiagnosticKind.Syntax);
            FirSourceElement firSourceElement4 = firPsiSourceElement;
            firElement = new FirErrorExpressionImpl(firSourceElement4, firDiagnostic);
        }
        return (FirExpression)firElement;
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition[] $this$toFirWhenCondition, @Nullable FirSourceElement baseSource, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirWhenCondition, (String)"$this$toFirWhenCondition");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        Intrinsics.checkParameterIsNotNull(toFirOrErrorTypeRef, (String)"toFirOrErrorTypeRef");
        FirExpression firCondition = null;
        for (KtWhenCondition condition : $this$toFirWhenCondition) {
            FirExpression firConditionElement = ConversionUtilsKt.toFirWhenCondition(condition, subject, convert, toFirOrErrorTypeRef);
            FirExpression firExpression2 = firCondition;
            firCondition = firExpression2 == null ? firConditionElement : (FirExpression)ConversionUtilsKt.generateLazyLogicalOperation(firCondition, firConditionElement, false, baseSource);
        }
        FirExpression firExpression3 = firCondition;
        if (firExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return firExpression3;
    }

    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument, boolean inverted, @Nullable KtExpression base, @Nullable KtOperationReferenceExpression operationReference) {
        FirPsiSourceElement firPsiSourceElement;
        FirPsiSourceElement firPsiSourceElement2;
        Intrinsics.checkParameterIsNotNull((Object)$this$generateContainsOperation, (String)"$this$generateContainsOperation");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        KtExpression ktExpression = base;
        if (ktExpression != null) {
            PsiElement $this$toFirSourceElement$iv = ktExpression;
            boolean $i$f$toFirSourceElement = false;
            firPsiSourceElement2 = new FirPsiSourceElement($this$toFirSourceElement$iv);
        } else {
            firPsiSourceElement2 = null;
        }
        FirPsiSourceElement baseSource = firPsiSourceElement2;
        KtOperationReferenceExpression ktOperationReferenceExpression = operationReference;
        if (ktOperationReferenceExpression != null) {
            PsiElement $this$toFirSourceElement$iv = ktOperationReferenceExpression;
            boolean $i$f$toFirSourceElement = false;
            firPsiSourceElement = new FirPsiSourceElement($this$toFirSourceElement$iv);
        } else {
            firPsiSourceElement = null;
        }
        FirPsiSourceElement operationReferenceSource = firPsiSourceElement;
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(baseSource);
        boolean bl = false;
        boolean bl2 = false;
        FirFunctionCallImpl $this$apply = firFunctionCallImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(operationReferenceSource, OperatorNameConventions.CONTAINS, null));
        $this$apply.setExplicitReceiver($this$generateContainsOperation);
        Collection collection = $this$apply.getArguments();
        FirExpression firExpression2 = argument;
        boolean bl4 = false;
        collection.add(firExpression2);
        FirFunctionCallImpl containsCall = firFunctionCallImpl;
        if (!inverted) {
            return containsCall;
        }
        firFunctionCallImpl = new FirFunctionCallImpl(baseSource);
        bl = false;
        bl2 = false;
        $this$apply = firFunctionCallImpl;
        boolean bl5 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(operationReferenceSource, OperatorNameConventions.NOT, null));
        $this$apply.setExplicitReceiver(containsCall);
        return firFunctionCallImpl;
    }

    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable FirSourceElement source, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(source);
        boolean bl = false;
        boolean bl2 = false;
        FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(source, name, null));
        return firQualifiedAccessExpressionImpl;
    }

    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable FirSourceElement source, @NotNull FirVariable<?> variable2) {
        Intrinsics.checkParameterIsNotNull(variable2, (String)"variable");
        FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(source);
        boolean bl = false;
        boolean bl2 = false;
        FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirResolvedNamedReferenceImpl(source, variable2.getName(), (AbstractFirBasedSymbol)variable2.getSymbol()));
        return firQualifiedAccessExpressionImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull KtDestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable, @NotNull Function2<? super KtAnnotated, ? super FirAbstractAnnotatedElement, Unit> extractAnnotationsTo, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrImplicitTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        Intrinsics.checkParameterIsNotNull(extractAnnotationsTo, (String)"extractAnnotationsTo");
        Intrinsics.checkParameterIsNotNull(toFirOrImplicitTypeRef, (String)"toFirOrImplicitTypeRef");
        PsiElement $this$toFirSourceElement$iv = multiDeclaration;
        boolean $i$f$toFirSourceElement = false;
        FirPsiSourceElement firPsiSourceElement = new FirPsiSourceElement($this$toFirSourceElement$iv);
        FirSourceElement firSourceElement = firPsiSourceElement;
        FirBlockImpl firBlockImpl = new FirBlockImpl(firSourceElement);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        if (tmpVariable) {
            Collection collection = $this$apply.getStatements();
            FirVariable<?> firVariable = container;
            boolean bl4 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl5 = false;
        List<KtDestructuringDeclarationEntry> list2 = multiDeclaration.getEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"multiDeclaration.entries");
        Iterator iterator2 = ((Iterable)list2).iterator();
        while (iterator2.hasNext()) {
            void index2;
            KtDestructuringDeclarationEntry entry;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry = (KtDestructuringDeclarationEntry)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"entry");
            PsiElement $this$toFirSourceElement$iv2 = ktDestructuringDeclarationEntry;
            boolean $i$f$toFirSourceElement2 = false;
            FirPsiSourceElement entrySource = new FirPsiSourceElement($this$toFirSourceElement$iv2);
            Collection collection = $this$apply.getStatements();
            FirSourceElement firSourceElement2 = entrySource;
            FirTypeRef firTypeRef = (FirTypeRef)toFirOrImplicitTypeRef.invoke((Object)entry.getTypeReference());
            Name name = entry.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"entry.nameAsSafeName");
            FirExpression firExpression2 = new FirComponentCallImpl(entrySource, ConversionUtilsKt.generateResolvedAccessExpression(entrySource, container), (int)(index2 + true));
            Name name2 = entry.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"entry.nameAsSafeName");
            FirPropertySymbol firPropertySymbol = new FirPropertySymbol(new CallableId(name2), false, null, 6, null);
            Visibility visibility = Visibilities.LOCAL;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.LOCAL");
            FirPropertyImpl firPropertyImpl = new FirPropertyImpl(firSourceElement2, session, firTypeRef, null, name, firExpression2, null, isVar, firPropertySymbol, true, new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            boolean bl6 = false;
            boolean bl7 = false;
            FirPropertyImpl $this$apply2 = firPropertyImpl;
            boolean bl8 = false;
            extractAnnotationsTo.invoke((Object)entry, (Object)$this$apply2);
            $this$apply2.getSymbol().bind((FirSymbolOwner)$this$apply2);
            bl6 = false;
            collection.add(firPropertyImpl);
            ++index2;
        }
        return firBlockImpl;
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session, @Nullable FirSourceElement source, @NotNull Name name, @NotNull FirExpression initializer2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        FirTypeRef firTypeRef = new FirImplicitTypeRefImpl(source);
        FirPropertySymbol firPropertySymbol = new FirPropertySymbol(new CallableId(name), false, null, 6, null);
        Visibility visibility = Visibilities.LOCAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.LOCAL");
        FirPropertyImpl firPropertyImpl = new FirPropertyImpl(source, session, firTypeRef, null, name, initializer2, null, false, firPropertySymbol, true, new FirDeclarationStatusImpl(visibility, Modality.FINAL));
        boolean bl = false;
        boolean bl2 = false;
        FirPropertyImpl $this$apply = firPropertyImpl;
        boolean bl3 = false;
        $this$apply.getSymbol().bind((FirSymbolOwner)$this$apply);
        return firPropertyImpl;
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session, @Nullable FirSourceElement source, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)specialName, (String)"specialName");
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        Name name = Name.special('<' + specialName + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable(session, source, name, initializer2);
    }

    public static final void generateAccessorsByDelegate(@NotNull FirModifiableVariable<?> $this$generateAccessorsByDelegate, @NotNull FirSession session, boolean member, boolean stubMode, @Nullable FirExpression receiver) {
        FirPureAbstractElement firPureAbstractElement;
        boolean bl;
        Object object;
        Object object2;
        FirFunctionCallImpl $this$apply;
        boolean bl2;
        boolean bl3;
        FirStatement firStatement;
        FirPureAbstractElement firPureAbstractElement2;
        FirElement firElement;
        Intrinsics.checkParameterIsNotNull($this$generateAccessorsByDelegate, (String)"$this$generateAccessorsByDelegate");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        FirVariable variable2 = $this$generateAccessorsByDelegate;
        FirDelegateFieldSymbol<?> firDelegateFieldSymbol = $this$generateAccessorsByDelegate.getDelegateFieldSymbol();
        if (firDelegateFieldSymbol == null) {
            return;
        }
        FirDelegateFieldSymbol<?> delegateFieldSymbol = firDelegateFieldSymbol;
        FirExpression firExpression2 = $this$generateAccessorsByDelegate.getDelegate();
        if (!(firExpression2 instanceof FirWrappedDelegateExpressionImpl)) {
            firExpression2 = null;
        }
        FirWrappedDelegateExpressionImpl firWrappedDelegateExpressionImpl = (FirWrappedDelegateExpressionImpl)firExpression2;
        if (firWrappedDelegateExpressionImpl == null) {
            return;
        }
        FirWrappedDelegateExpressionImpl delegate = firWrappedDelegateExpressionImpl;
        Function0<FirQualifiedAccessExpressionImpl> $fun$delegateAccess$1 = new Function0<FirQualifiedAccessExpressionImpl>(delegateFieldSymbol){
            final /* synthetic */ FirDelegateFieldSymbol $delegateFieldSymbol;

            @NotNull
            public final FirQualifiedAccessExpressionImpl invoke() {
                FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(null);
                boolean bl = false;
                boolean bl2 = false;
                FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
                boolean bl3 = false;
                $this$apply.setCalleeReference(new FirDelegateFieldReferenceImpl(null, null, this.$delegateFieldSymbol));
                return firQualifiedAccessExpressionImpl;
            }
            {
                this.$delegateFieldSymbol = firDelegateFieldSymbol;
                super(0);
            }
        };
        Function0<FirExpression> $fun$thisRef$2 = new Function0<FirExpression>(member){
            final /* synthetic */ boolean $member;

            @NotNull
            public final FirExpression invoke() {
                FirElement firElement;
                if (this.$member) {
                    FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(null);
                    boolean bl = false;
                    boolean bl2 = false;
                    FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
                    boolean bl3 = false;
                    $this$apply.setCalleeReference(new FirExplicitThisReference(null, null));
                    firElement = firQualifiedAccessExpressionImpl;
                } else {
                    firElement = new FirConstExpressionImpl<Object>(null, FirConstKind.Null.INSTANCE, null);
                }
                return (FirExpression)firElement;
            }
            {
                this.$member = bl;
                super(0);
            }
        };
        Function0<FirCallableReferenceAccessImpl> $fun$propertyRef$3 = new Function0<FirCallableReferenceAccessImpl>(variable2){
            final /* synthetic */ FirVariable $variable;

            @NotNull
            public final FirCallableReferenceAccessImpl invoke() {
                FirCallableReferenceAccessImpl firCallableReferenceAccessImpl = new FirCallableReferenceAccessImpl(null);
                boolean bl = false;
                boolean bl2 = false;
                FirCallableReferenceAccessImpl $this$apply = firCallableReferenceAccessImpl;
                boolean bl3 = false;
                $this$apply.setCalleeReference(new FirResolvedNamedReferenceImpl(null, this.$variable.getName(), (AbstractFirBasedSymbol)this.$variable.getSymbol()));
                $this$apply.setTypeRef(new FirImplicitKPropertyTypeRef(null, ConeStarProjection.INSTANCE));
                return firCallableReferenceAccessImpl;
            }
            {
                this.$variable = firVariable;
                super(0);
            }
        };
        FirWrappedDelegateExpressionImpl firWrappedDelegateExpressionImpl2 = delegate;
        if (stubMode) {
            firElement = new FirExpressionStub(null);
        } else {
            firPureAbstractElement2 = new FirFunctionCallImpl(null);
            firStatement = firWrappedDelegateExpressionImpl2;
            bl3 = false;
            bl2 = false;
            $this$apply = firPureAbstractElement2;
            boolean bl4 = false;
            $this$apply.setExplicitReceiver(receiver);
            $this$apply.setCalleeReference(new FirSimpleNamedReference(null, PROVIDE_DELEGATE, null));
            object2 = $this$apply.getArguments();
            object = $fun$thisRef$2.invoke();
            bl = false;
            object2.add(object);
            object2 = $this$apply.getArguments();
            object = $fun$propertyRef$3.invoke();
            bl = false;
            object2.add(object);
            firPureAbstractElement = firPureAbstractElement2;
            firWrappedDelegateExpressionImpl2 = firStatement;
            firElement = firPureAbstractElement;
        }
        firWrappedDelegateExpressionImpl2.setDelegateProvider((FirExpression)firElement);
        if (stubMode) {
            return;
        }
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            FirTypeRef firTypeRef = new FirImplicitTypeRefImpl(null);
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = new FirPropertyAccessorSymbol();
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.UNKNOWN");
            firPureAbstractElement2 = new FirPropertyAccessorImpl(null, session, firTypeRef, firPropertyAccessorSymbol, true, new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            firStatement = $this$generateAccessorsByDelegate;
            bl3 = false;
            bl2 = false;
            FirPureAbstractElement $this$Accessor = firPureAbstractElement2;
            boolean bl5 = false;
            object2 = new FirFunctionCallImpl(null);
            object = null;
            FirPureAbstractElement firPureAbstractElement3 = $this$Accessor;
            boolean bl6 = false;
            boolean bl7 = false;
            Object $this$apply2 = object2;
            boolean bl8 = false;
            ((FirFunctionCallImpl)$this$apply2).setExplicitReceiver((FirExpression)$fun$delegateAccess$1.invoke());
            ((FirFunctionCallImpl)$this$apply2).setCalleeReference(new FirSimpleNamedReference(null, GET_VALUE, null));
            Collection collection = ((FirFunctionCallImpl)$this$apply2).getArguments();
            Object object3 = $fun$thisRef$2.invoke();
            boolean bl9 = false;
            collection.add(object3);
            collection = ((FirFunctionCallImpl)$this$apply2).getArguments();
            object3 = $fun$propertyRef$3.invoke();
            bl9 = false;
            collection.add(object3);
            Object object4 = object2;
            FirExpression firExpression3 = (FirExpression)object4;
            Object object5 = object;
            object2 = new FirReturnExpressionImpl((FirSourceElement)object5, firExpression3);
            bl6 = false;
            bl7 = false;
            $this$apply2 = object2;
            boolean bl10 = false;
            ((FirReturnExpressionImpl)$this$apply2).setTarget(new FirFunctionTarget(null));
            ((FirReturnExpressionImpl)$this$apply2).getTarget().bind((FirFunction<?>)((FirTargetElement)((Object)$this$Accessor)));
            Object object6 = object2;
            FirStatement firStatement2 = (FirStatement)object6;
            ((FirPropertyAccessorImpl)firPureAbstractElement3).setBody(new FirSingleExpressionBlock(firStatement2));
            firPureAbstractElement = firPureAbstractElement2;
            firStatement.setGetter((FirPropertyAccessor)firPureAbstractElement);
        }
        if (variable2.isVar() && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            FirTypeRef firTypeRef = session.getBuiltinTypes().getUnitType();
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = new FirPropertyAccessorSymbol();
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.UNKNOWN");
            firPureAbstractElement2 = new FirPropertyAccessorImpl(null, session, firTypeRef, firPropertyAccessorSymbol, false, new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            firStatement = $this$generateAccessorsByDelegate;
            bl3 = false;
            bl2 = false;
            $this$apply = firPureAbstractElement2;
            boolean bl11 = false;
            FirValueParameterImpl parameter = new FirValueParameterImpl(null, session, new FirImplicitTypeRefImpl(null), DELEGATED_SETTER_PARAM, new FirVariableSymbol<FirValueParameter>($this$generateAccessorsByDelegate.getName()), null, false, false, false);
            object = ((FirPropertyAccessorImpl)((Object)$this$apply)).getValueParameters();
            bl = false;
            object.add(parameter);
            object = new FirFunctionCallImpl(null);
            FirFunctionCallImpl firFunctionCallImpl = $this$apply;
            bl = false;
            boolean bl12 = false;
            Object $this$apply3 = object;
            boolean bl13 = false;
            ((FirFunctionCallImpl)$this$apply3).setExplicitReceiver((FirExpression)$fun$delegateAccess$1.invoke());
            ((FirFunctionCallImpl)$this$apply3).setCalleeReference(new FirSimpleNamedReference(null, SET_VALUE, null));
            Collection collection = ((FirFunctionCallImpl)$this$apply3).getArguments();
            Object object7 = $fun$thisRef$2.invoke();
            boolean bl14 = false;
            collection.add(object7);
            collection = ((FirFunctionCallImpl)$this$apply3).getArguments();
            object7 = $fun$propertyRef$3.invoke();
            bl14 = false;
            collection.add(object7);
            collection = ((FirFunctionCallImpl)$this$apply3).getArguments();
            object7 = new FirQualifiedAccessExpressionImpl(null);
            bl14 = false;
            boolean bl15 = false;
            Object $this$apply4 = object7;
            boolean bl16 = false;
            ((FirQualifiedAccessExpressionImpl)$this$apply4).setCalleeReference(new FirResolvedNamedReferenceImpl(((FirQualifiedAccessExpressionImpl)$this$apply4).getSource(), DELEGATED_SETTER_PARAM, parameter.getSymbol()));
            bl14 = false;
            collection.add(object7);
            Object object8 = object;
            FirStatement firStatement3 = (FirStatement)object8;
            ((FirPropertyAccessorImpl)((Object)firFunctionCallImpl)).setBody(new FirSingleExpressionBlock(firStatement3));
            firPureAbstractElement = firPureAbstractElement2;
            firStatement.setSetter((FirPropertyAccessor)firPureAbstractElement);
        }
    }

    static {
        Name name = Name.identifier("getValue");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"getValue\")");
        GET_VALUE = name;
        Name name2 = Name.identifier("setValue");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"setValue\")");
        SET_VALUE = name2;
        Name name3 = Name.identifier("provideDelegate");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"provideDelegate\")");
        PROVIDE_DELEGATE = name3;
        Name name4 = Name.special("<set-?>");
        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"Name.special(\"<set-?>\")");
        DELEGATED_SETTER_PARAM = name4;
    }
}

