/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.CachingContext;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.DefaultIncrementalInputProperties;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.RebuildExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;

public class ResolveChangesStep<R extends Result>
implements Step<CachingContext, R> {
    private final ExecutionStateChangeDetector changeDetector;
    private static final String NO_HISTORY = "No history is available.";
    private final Step<? super IncrementalChangesContext, R> delegate;

    public ResolveChangesStep(ExecutionStateChangeDetector changeDetector, Step<? super IncrementalChangesContext, R> delegate) {
        this.changeDetector = changeDetector;
        this.delegate = delegate;
    }

    @Override
    public R execute(final CachingContext context) {
        final UnitOfWork work = context.getWork();
        final Optional<BeforeExecutionState> beforeExecutionState = context.getBeforeExecutionState();
        final ExecutionStateChanges changes = context.getRebuildReason().map(rebuildReason -> new RebuildExecutionStateChanges((String)rebuildReason, (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)((ImmutableSortedMap)beforeExecutionState.map(BeforeExecutionState::getInputFileProperties).orElse(null)), ResolveChangesStep.createIncrementalInputProperties(work))).orElseGet(() -> beforeExecutionState.map(beforeExecution -> context.getAfterPreviousExecutionState().map(afterPreviousExecution -> this.changeDetector.detectChanges((AfterPreviousExecutionState)afterPreviousExecution, (BeforeExecutionState)beforeExecution, work, ResolveChangesStep.createIncrementalInputProperties(work))).orElseGet(() -> new RebuildExecutionStateChanges(NO_HISTORY, beforeExecution.getInputFileProperties(), ResolveChangesStep.createIncrementalInputProperties(work)))).orElse(null));
        return this.delegate.execute(new IncrementalChangesContext(){

            @Override
            public Optional<ExecutionStateChanges> getChanges() {
                return Optional.ofNullable(changes);
            }

            @Override
            public CachingState getCachingState() {
                return context.getCachingState();
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return beforeExecutionState;
            }

            @Override
            public UnitOfWork getWork() {
                return work;
            }
        });
    }

    private static IncrementalInputProperties createIncrementalInputProperties(UnitOfWork work) {
        UnitOfWork.InputChangeTrackingStrategy inputChangeTrackingStrategy = work.getInputChangeTrackingStrategy();
        switch (inputChangeTrackingStrategy) {
            case NONE: {
                return IncrementalInputProperties.NONE;
            }
            case ALL_PARAMETERS: {
                return IncrementalInputProperties.ALL;
            }
            case INCREMENTAL_PARAMETERS: {
                ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                work.visitInputFileProperties((propertyName, value, incremental, fingerprinter) -> {
                    if (incremental) {
                        if (value == null) {
                            throw new InvalidUserDataException("Must specify a value for incremental input property '" + propertyName + "'.");
                        }
                        builder.put((Object)propertyName, value);
                    }
                });
                return new DefaultIncrementalInputProperties((ImmutableBiMap<String, Object>)builder.build());
            }
        }
        throw new AssertionError((Object)("Unknown InputChangeTrackingStrategy: " + (Object)((Object)inputChangeTrackingStrategy)));
    }
}

