/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.NativeResourceSet;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.internal.AbstractNativeLibraryBinarySpec;
import org.gradle.nativeplatform.internal.SharedLibraryBinarySpecInternal;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.internal.BinaryTasksCollectionWrapper;

public class DefaultSharedLibraryBinarySpec
extends AbstractNativeLibraryBinarySpec
implements SharedLibraryBinary,
SharedLibraryBinarySpecInternal {
    private final DefaultTasksCollection tasks = new DefaultTasksCollection(super.getTasks());
    private File sharedLibraryFile;
    private File sharedLibraryLinkFile;

    @Override
    public File getSharedLibraryFile() {
        return this.sharedLibraryFile;
    }

    @Override
    public void setSharedLibraryFile(File sharedLibraryFile) {
        this.sharedLibraryFile = sharedLibraryFile;
    }

    @Override
    public File getSharedLibraryLinkFile() {
        return this.sharedLibraryLinkFile;
    }

    @Override
    public void setSharedLibraryLinkFile(File sharedLibraryLinkFile) {
        this.sharedLibraryLinkFile = sharedLibraryLinkFile;
    }

    @Override
    public File getPrimaryOutput() {
        return this.getSharedLibraryFile();
    }

    @Override
    public FileCollection getLinkFiles() {
        return this.getFileCollectionFactory().create((MinimalFileSet)new SharedLibraryLinkOutputs());
    }

    @Override
    public FileCollection getRuntimeFiles() {
        return this.getFileCollectionFactory().create((MinimalFileSet)new SharedLibraryRuntimeOutputs());
    }

    @Override
    protected ObjectFilesToBinary getCreateOrLink() {
        return this.tasks.getLink();
    }

    @Override
    public SharedLibraryBinarySpec.TasksCollection getTasks() {
        return this.tasks;
    }

    private class SharedLibraryRuntimeOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private SharedLibraryRuntimeOutputs() {
        }

        public String getDisplayName() {
            return "Runtime files for " + DefaultSharedLibraryBinarySpec.this.getDisplayName();
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultSharedLibraryBinarySpec.this.hasSources();
        }

        @Override
        protected Set<File> getOutputs() {
            return Collections.singleton(DefaultSharedLibraryBinarySpec.this.getSharedLibraryFile());
        }
    }

    private class SharedLibraryLinkOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private SharedLibraryLinkOutputs() {
        }

        public String getDisplayName() {
            return "Link files for " + DefaultSharedLibraryBinarySpec.this.getDisplayName();
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultSharedLibraryBinarySpec.this.hasSources() && !this.isResourceOnly();
        }

        @Override
        protected Set<File> getOutputs() {
            return Collections.singleton(DefaultSharedLibraryBinarySpec.this.getSharedLibraryLinkFile());
        }

        private boolean isResourceOnly() {
            return this.hasResources() && !this.hasExportedSymbols();
        }

        private boolean hasResources() {
            for (NativeResourceSet windowsResourceSet : DefaultSharedLibraryBinarySpec.this.getInputs().withType(NativeResourceSet.class)) {
                if (windowsResourceSet.getSource().isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean hasExportedSymbols() {
            for (LanguageSourceSet languageSourceSet : DefaultSharedLibraryBinarySpec.this.getInputs()) {
                if (languageSourceSet instanceof NativeResourceSet || languageSourceSet.getSource().isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    private static class DefaultTasksCollection
    extends BinaryTasksCollectionWrapper
    implements SharedLibraryBinarySpec.TasksCollection {
        public DefaultTasksCollection(BinaryTasksCollection delegate) {
            super(delegate);
        }

        @Override
        public LinkSharedLibrary getLink() {
            return (LinkSharedLibrary)this.findSingleTaskWithType(LinkSharedLibrary.class);
        }
    }
}

