/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jd.gui.view.bean.OpenTypeListCellBean;

public class OpenTypeListCellRenderer
implements ListCellRenderer<OpenTypeListCellBean> {
    protected Color textSelectionColor = UIManager.getColor("List.selectionForeground");
    protected Color textNonSelectionColor = UIManager.getColor("List.foreground");
    protected Color infoSelectionColor;
    protected Color infoNonSelectionColor;
    protected Color backgroundSelectionColor = UIManager.getColor("List.selectionBackground");
    protected Color backgroundNonSelectionColor = UIManager.getColor("List.background");
    protected JPanel panel;
    protected JLabel label;
    protected JLabel info;

    public OpenTypeListCellRenderer() {
        this.infoSelectionColor = OpenTypeListCellRenderer.infoColor(this.textSelectionColor);
        this.infoNonSelectionColor = OpenTypeListCellRenderer.infoColor(this.textNonSelectionColor);
        this.panel = new JPanel(new BorderLayout());
        this.label = new JLabel();
        this.panel.add((Component)this.label, "West");
        this.info = new JLabel();
        this.panel.add((Component)this.info, "Center");
    }

    protected static Color infoColor(Color c) {
        if (c.getRed() + c.getGreen() + c.getBlue() > 381) {
            return new Color((int)((double)(c.getRed() - 127) * 0.7 + 127.0), (int)((double)(c.getGreen() - 127) * 0.7 + 127.0), (int)((double)(c.getBlue() - 127) * 0.7 + 127.0), c.getAlpha());
        }
        return new Color((int)(127.0 - (double)(127 - c.getRed()) * 0.7), (int)(127.0 - (double)(127 - c.getGreen()) * 0.7), (int)(127.0 - (double)(127 - c.getBlue()) * 0.7), c.getAlpha());
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends OpenTypeListCellBean> list, OpenTypeListCellBean value, int index, boolean selected, boolean hasFocus) {
        if (value != null) {
            this.label.setText(value.label);
            this.label.setIcon(value.icon);
            this.info.setText(value.packag != null ? " - " + value.packag : "");
            if (selected) {
                this.label.setForeground(this.textSelectionColor);
                this.info.setForeground(this.infoSelectionColor);
                this.panel.setBackground(this.backgroundSelectionColor);
            } else {
                this.label.setForeground(this.textNonSelectionColor);
                this.info.setForeground(this.infoNonSelectionColor);
                this.panel.setBackground(this.backgroundNonSelectionColor);
            }
        } else {
            this.label.setText(" ...");
            this.label.setIcon(null);
            this.info.setText("");
            this.label.setForeground(this.textNonSelectionColor);
            this.panel.setBackground(this.backgroundNonSelectionColor);
        }
        return this.panel;
    }
}

