/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.packet.namednumber.IpV4SecurityOptionCompartments;
import org.pcap4j.packet.namednumber.IpV4SecurityOptionHandlingRestrictions;
import org.pcap4j.packet.namednumber.IpV4SecurityOptionSecurity;
import org.pcap4j.packet.namednumber.IpV4SecurityOptionTransmissionControlCode;
import org.pcap4j.util.ByteArrays;

public final class IpV4Rfc791SecurityOption
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = -7385398208873489520L;
    private final IpV4OptionType type = IpV4OptionType.SECURITY;
    private final byte length;
    private final IpV4SecurityOptionSecurity security;
    private final IpV4SecurityOptionCompartments compartments;
    private final IpV4SecurityOptionHandlingRestrictions handlingRestrictions;
    private final IpV4SecurityOptionTransmissionControlCode tcc;

    public static IpV4Rfc791SecurityOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4Rfc791SecurityOption(rawData, offset, length);
    }

    private IpV4Rfc791SecurityOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 11) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 10. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[1 + offset] != 11) {
            throw new IllegalRawDataException("Invalid value of length field: " + rawData[1 + offset]);
        }
        this.length = rawData[1 + offset];
        this.security = IpV4SecurityOptionSecurity.getInstance(ByteArrays.getShort(rawData, 2 + offset));
        this.compartments = IpV4SecurityOptionCompartments.getInstance(ByteArrays.getShort(rawData, 4 + offset));
        this.handlingRestrictions = IpV4SecurityOptionHandlingRestrictions.getInstance(ByteArrays.getShort(rawData, 6 + offset));
        this.tcc = IpV4SecurityOptionTransmissionControlCode.getInstance(ByteArrays.getInt(rawData, 7 + offset) & 0xFFFFFF);
    }

    private IpV4Rfc791SecurityOption(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder: " + builder2);
        }
        this.security = builder2.security;
        this.compartments = builder2.compartments;
        this.handlingRestrictions = builder2.handlingRestrictions;
        this.tcc = builder2.tcc;
        this.length = builder2.correctLengthAtBuild ? (byte)this.length() : builder2.length;
    }

    @Override
    public IpV4OptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public IpV4SecurityOptionSecurity getSecurity() {
        return this.security;
    }

    public IpV4SecurityOptionCompartments getCompartments() {
        return this.compartments;
    }

    public IpV4SecurityOptionHandlingRestrictions getHandlingRestrictions() {
        return this.handlingRestrictions;
    }

    public IpV4SecurityOptionTransmissionControlCode getTcc() {
        return this.tcc;
    }

    @Override
    public int length() {
        return 11;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        rawData[2] = (byte)((Short)this.security.value() >> 8);
        rawData[3] = (byte)((Short)this.security.value()).shortValue();
        rawData[4] = (byte)((Short)this.compartments.value() >> 8);
        rawData[5] = (byte)((Short)this.compartments.value()).shortValue();
        rawData[6] = (byte)((Short)this.handlingRestrictions.value() >> 8);
        rawData[7] = (byte)((Short)this.handlingRestrictions.value()).shortValue();
        rawData[8] = (byte)((Integer)this.tcc.value() >> 16);
        rawData[9] = (byte)((Integer)this.tcc.value() >> 8);
        rawData[10] = (byte)((Integer)this.tcc.value()).shortValue();
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.getType());
        sb.append("] [option-length: ").append(this.getLengthAsInt());
        sb.append(" byte] [security: ").append(this.security);
        sb.append("] [compartments: ").append(this.compartments);
        sb.append("] [handlingRestrictions: ").append(this.handlingRestrictions);
        sb.append("] [tcc: ").append(this.tcc);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV4Rfc791SecurityOption other = (IpV4Rfc791SecurityOption)obj;
        return this.length == other.length && this.security.equals(other.security) && this.compartments.equals(other.compartments) && this.handlingRestrictions.equals(other.handlingRestrictions) && this.tcc.equals(other.tcc);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.security.hashCode();
        result2 = 31 * result2 + this.compartments.hashCode();
        result2 = 31 * result2 + this.handlingRestrictions.hashCode();
        result2 = 31 * result2 + this.tcc.hashCode();
        return result2;
    }

    public static final class Builder
    implements LengthBuilder<IpV4Rfc791SecurityOption> {
        private byte length;
        private IpV4SecurityOptionSecurity security;
        private IpV4SecurityOptionCompartments compartments;
        private IpV4SecurityOptionHandlingRestrictions handlingRestrictions;
        private IpV4SecurityOptionTransmissionControlCode tcc;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV4Rfc791SecurityOption option) {
            this.length = option.length;
            this.security = option.security;
            this.compartments = option.compartments;
            this.handlingRestrictions = option.handlingRestrictions;
            this.tcc = option.tcc;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder security(IpV4SecurityOptionSecurity security) {
            this.security = security;
            return this;
        }

        public Builder compartments(IpV4SecurityOptionCompartments compartments) {
            this.compartments = compartments;
            return this;
        }

        public Builder handlingRestrictions(IpV4SecurityOptionHandlingRestrictions handlingRestrictions) {
            this.handlingRestrictions = handlingRestrictions;
            return this;
        }

        public Builder tcc(IpV4SecurityOptionTransmissionControlCode tcc) {
            this.tcc = tcc;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV4Rfc791SecurityOption build() {
            return new IpV4Rfc791SecurityOption(this);
        }
    }
}

