/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;

public abstract class ExtFormatter
extends Formatter {
    @Override
    public final String format(LogRecord record) {
        return this.format(ExtLogRecord.wrap(record));
    }

    public abstract String format(ExtLogRecord var1);

    @Override
    public String formatMessage(LogRecord record) {
        Object[] parameters;
        ResourceBundle bundle = record.getResourceBundle();
        String msg = record.getMessage();
        if (msg == null) {
            return null;
        }
        if (bundle != null) {
            try {
                msg = bundle.getString(msg);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((parameters = record.getParameters()) == null || parameters.length == 0) {
            return this.formatMessageNone(record);
        }
        if (record instanceof ExtLogRecord) {
            ExtLogRecord extLogRecord = (ExtLogRecord)record;
            ExtLogRecord.FormatStyle formatStyle = extLogRecord.getFormatStyle();
            if (formatStyle == ExtLogRecord.FormatStyle.PRINTF) {
                return this.formatMessagePrintf(record);
            }
            if (formatStyle == ExtLogRecord.FormatStyle.NO_FORMAT) {
                return this.formatMessageNone(record);
            }
        }
        return msg.indexOf(123) >= 0 ? this.formatMessageLegacy(record) : this.formatMessageNone(record);
    }

    public boolean isCallerCalculationRequired() {
        return true;
    }

    protected String formatMessageNone(LogRecord record) {
        return record.getMessage();
    }

    protected String formatMessageLegacy(LogRecord record) {
        return MessageFormat.format(record.getMessage(), record.getParameters());
    }

    protected String formatMessagePrintf(LogRecord record) {
        return String.format(record.getMessage(), record.getParameters());
    }
}

