/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.retry;

import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import java.time.Duration;

final class AutoValue_RetryPolicy
extends RetryPolicy {
    private final int maxAttempts;
    private final Duration initialBackoff;
    private final Duration maxBackoff;
    private final double backoffMultiplier;

    AutoValue_RetryPolicy(int maxAttempts, Duration initialBackoff, Duration maxBackoff, double backoffMultiplier) {
        this.maxAttempts = maxAttempts;
        if (initialBackoff == null) {
            throw new NullPointerException("Null initialBackoff");
        }
        this.initialBackoff = initialBackoff;
        if (maxBackoff == null) {
            throw new NullPointerException("Null maxBackoff");
        }
        this.maxBackoff = maxBackoff;
        this.backoffMultiplier = backoffMultiplier;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public Duration getInitialBackoff() {
        return this.initialBackoff;
    }

    @Override
    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    @Override
    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public String toString() {
        return "RetryPolicy{maxAttempts=" + this.maxAttempts + ", initialBackoff=" + this.initialBackoff + ", maxBackoff=" + this.maxBackoff + ", backoffMultiplier=" + this.backoffMultiplier + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RetryPolicy) {
            RetryPolicy that = (RetryPolicy)o;
            return this.maxAttempts == that.getMaxAttempts() && this.initialBackoff.equals(that.getInitialBackoff()) && this.maxBackoff.equals(that.getMaxBackoff()) && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.maxAttempts;
        h$ *= 1000003;
        h$ ^= this.initialBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBackoff.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.backoffMultiplier) >>> 32 ^ Double.doubleToLongBits(this.backoffMultiplier));
    }
}

