/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.access;

import java.util.Optional;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class DenyAccessAuthenticator
implements Authenticator {
    public void authenticate(AuthenticationFlowContext context) {
        String errorMessage = Optional.ofNullable(context.getAuthenticatorConfig()).map(AuthenticatorConfigModel::getConfig).map(f -> (String)f.get("denyErrorMessage")).orElse("access-denied");
        context.getEvent().error("access_denied");
        Response challenge = context.form().setError(errorMessage, new Object[0]).createErrorPage(Response.Status.UNAUTHORIZED);
        context.failure(AuthenticationFlowError.ACCESS_DENIED, challenge);
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

